/* +++Date last modified: 02-Sep-1996 */

/*
**  prtoggle()
**
**  Tee's all standard output to the printer.
**
**  Parameters: None
**
**  Returns:  0 if operation was successful.
**           -1 if stdout or stdin is redirected.
**
**  Side effects: Flushes the keyboard buffer
**
**  Original Copyright 1988-1991 by Bob Stout as part of
**  the MicroFirm Function Library (MFL)
**
**  The user is granted a free limited license to use this source file
**  to create royalty-free programs, subject to the terms of the
**  license restrictions specified in the LICENSE.MFL file.
*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include "sniptype.h"
#include "sniprint.h"
#include "pchwio.h"

static unsigned head, tail;
static int idx = 0;
static unsigned keystack[16][2];

int ungetkey(unsigned key)
{
        int count;

        head = peekw(0x40, 0x1a);
        tail = peekw(0x40, 0x1c);
        count = tail - head;
        if (0 > count)
                count += (16 * sizeof(unsigned));
        count >>= 1;

        if (15 > count)
        {
                keystack[idx][0] = peek(0x40, tail);
                keystack[idx][1] = tail;
                pokew(0x40, tail, key);
                tail += sizeof(unsigned);
                if (0x3e <= tail)
                        tail = 0x1e;
                pokew(0x40, 0x1c, tail);
                return key;
        }
        return EOF;
}

int prtoggle(void)
{
      if (!isatty(fileno(stdin)) || !isatty(fileno(stdout)))
            return -1;
      while (kbhit())           /* Flush the keyboard buffer            */
            getch();
      ungetkey('P' - 64);       /* Stuff a Ctrl-P into the buffer       */
      system("");               /* Let COMMAND.COM do the work          */
      return 0;
}
