/* +++Date last modified: 28-Sep-1996 */

/*
**  SETENVAR.C - Program which sets the DOS master environment upon exit
**
**  Original Copyright 1988-1991 by Bob Stout as part of
**  the MicroFirm Function Library (MFL)
**
**  The user is granted a free limited license to use this source file
**  to create royalty-free programs, subject to the terms of the
**  license restrictions specified in the LICENSE.MFL file.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include "sniptype.h"
#include "pchwio.h"
#include "errors.h"                       /* For cant()     */

static unsigned head, tail, start, end;
static int idx = 0;
static unsigned keystack[16][2];

/*
**  ungetkey()
**
**  Stuffs characters into the keyboard buffer.
**
**  Parameters: 1 - Extended character to stuff
**
**  Returns: Success_ or EOF
**
**  Note: This function assumes that the keyboard buffer is in
**        the normal (for IBM) location of 40:1E.
**
*/

int ungetkey(unsigned key)
{
      int count;

      head  = peekw(0x40, 0x1a);
      tail  = peekw(0x40, 0x1c);
      start = peekw(0x40, 0x80);
      end   = peekw(0x40, 0x82);

      count = tail - head;
      if (0 > count)
            count += (16 * sizeof(unsigned));
      count >>= 1;

      if (15 > count)
      {
            disable();
            keystack[idx][0] = peekw(0x40, tail);
            keystack[idx][1] = tail;
            poke(0x40, tail, key);
            tail += sizeof(unsigned);
            if (end <= tail)
                  tail = start;
            poke(0x40, 0x1c, tail);
            enable();
            return key;
      }
      return EOF;
}

/*
**  KB_stuff()
**
**  Stuffs strings into the keyboard buffer.
**
**  Parameters: 1 - String to stuff
**
**  Returns: Success_ if successful
**           Error_   in case of error, plus keyboard buffer is
**                    restored
**
**  Note: This function assumes that the keyboard buffer is in
**        the normal (for IBM) location of 40:1E.
*/

int KB_stuff(char *str)
{
      int ercode = Success_;

      idx = 0;
      while (*str)
      {
            if (EOF == ungetkey((unsigned)(*str++)))
            {
                  disable();
                  while (0 <= --idx)
                  {
                        tail = keystack[idx][1];
                        poke(0x40, tail, keystack[idx][0]);
                  }
                  poke(0x40, 0x1c, tail);
                  enable();
                  ercode = Error_;
                  break;
            }
            else  ++idx;
      }
      idx = 0;
      return ercode;
}

main(int argc, char *argv[])
{
      FILE *bfile;

      if (3 > argc)
      {
            puts("\aUsage: SETENVAR envar datum");
            abort();
      }
      bfile = cant("$TMP$.BAT", "w");
      fprintf(bfile, "SET %s=%s\ndel $tmp$.bat\x1a", argv[1], argv[2]);
      fclose(bfile);
      while (kbhit())
            getch();
      KB_stuff("$tmp$\r");
      return 0;
}
