.I 0 2
/* +++Date last modified: 24-Aug-1996 */

.I 4 3
#include <time.h>
#include "ftime.h"

.D 7 2
.I 12 1
 typedef unsigned FTIME_T_;
.I 63 74

static void _ftimecnvrt(struct ftime *ft, struct tm *time, time_t *tt)
{
      time->tm_sec  = ft->ft_tsec * 2;
      time->tm_min  = ft->ft_min;
      time->tm_hour = ft->ft_hour;
      time->tm_mday = ft->ft_day;
      time->tm_mon  = ft->ft_month - 1;
      time->tm_year = ft->ft_year + 80;
      *tt = mktime(time);                 /* Fill in rest of the struct */
}

void ftime2tm(struct ftime *ft, struct tm *time)
{
      time_t tt;
      
      _ftimecnvrt(ft, time, &tt);
}

time_t ftime2time(struct ftime *ft)
{
      struct tm time;
      time_t tt;
      
      _ftimecnvrt(ft, &time, &tt);
      return tt;
}

#ifdef TEST

#include <stdio.h>
#include <stdlib.h>
#include "unistd.h"
#include "errors.h"
#include "sniptype.h"

#ifdef __WATCOMC__
 #pragma off (unreferenced);
#endif
#ifdef __TURBOC__
 #pragma argsused
#endif

main(int argc, char *argv[])
{
      struct ftime ft;
      struct tm time;
      FILE *fp;
      char timeline[80];

      fp = cant(argv[0], "r");
      if (Success_ != getftime(fileno(fp), &ft))
            ErrExit("getftime() failed");
      ftime2tm(&ft, &time);
      printf("ft_tsec = %d\n", ft.ft_tsec);
      printf("ft_min  = %d\n", ft.ft_min);
      printf("ft_hour = %d\n", ft.ft_hour);
      printf("ft_day  = %d\n", ft.ft_day);
      printf("ft_month= %d\n", ft.ft_month);
      printf("ft_year = %d\n", ft.ft_year);
      puts("");
      printf("tm_sec  = %d\n", time.tm_sec);
      printf("tm_min  = %d\n", time.tm_min);
      printf("tm_hour = %d\n", time.tm_hour);
      printf("tm_mday = %d\n", time.tm_mday);
      printf("tm_mon  = %d\n", time.tm_mon);
      printf("tm_year = %d\n", time.tm_year);

      strftime(timeline, 80, "\n%c\n", &time);
      puts(timeline);
      return EXIT_SUCCESS;
}

#endif /* TEST */
