/* Project SWORD
   V2.0

   SubSystem : Basic functions usefull for all the system
   File      : Include/Common/Basic.H
   ErrNos    : 200..299
   Author    : Eric NICOLAS
   Overview  : Some usefull functions. Get path to the system.
   UpDate    : Nov 13, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _COMMON_BASIC_H_
#define _COMMON_BASIC_H_

// ===== Defines ============================================================

#define max(a,b)    (((a) > (b)) ? (a) : (b))
#define min(a,b)    (((a) < (b)) ? (a) : (b))

#ifdef __TURBOC__
#define MaxInt      32767
#define MinInt     -32768
#define PACKED
#else
#define MaxInt      2147483647
#define MinInt     -2147483648
#define PACKED      __attribute__ ((packed))
#endif

// Numros d'erreur

#define erSWORDPATHmissing       200

// ===== Global Variables ===================================================

extern char *ShortVersion;        // Name of the program : Short version
extern char *LongVersion;         // Long version
extern char *SwordPath;           // Path to Sword system files
extern char *AppPath;             // Path to the application
extern char *SwordVer;            // Version number of Sword (string)

// ===== Functions ==========================================================

#ifdef __cplusplus
extern "C" {
#endif

//----- Init/Done de l'unit ------------------------------------------------

void InitBasic(char *Arg);
void DoneBasic(void);

//----- Autres routines utiles ----------------------------------------------

void GetCurDir(char *S);
void ToAntiSlash(char *S);
void ToSlash(char *S);
int  Random(int Max);       // Nombre alatoire de 0  Max-1
long GetTime(void);         // Temps en centiemes de secondes
void Delay(long NCentSeconds);   // Attends NCentSeconds centiemes secondes
void RemoveTABS(char *Str, int TabLength);

#ifdef __cplusplus
}
#endif

#endif
