/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Include/Graphics/Graphics.H
   ErrNos    : 2000..2099
   Author    : Eric NICOLAS
   Overview  : Init / Done of the module Graphics
   UpDate    : Oct 14, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GRAPHICS_GRAPHICS_H_
#define _GRAPHICS_GRAPHICS_H_

#include <grx.h>
#include <mousex.h>
#include "Graphics/Rect.H"
#include "Graphics/FontSys.H"
#include "Graphics/Colors.H"
#include "Graphics/Zone.H"
#include "Graphics/ScrZone.H"
#include "Graphics/Desktop.H"
#include "Graphics/Window.H"
#include "Graphics/Shell.H"
#include "Graphics/Mapping.H"

// Defines

#define MouseCursorArrow      0
#define MouseCursorHand       1
#define MouseCursorSize1      2
#define MouseCursorSize2      3
#define MouseCursorButton     4
#define MouseCursorInactivity 5

// Error Nos

#define erNoMouseDetected     2000

// Global variables

extern char *EndingMessage;
extern char  CurrentMouseAspect;

// Functions

void InitGraphics(void);
void DoneGraphics(void);

void ChangeMouseAspect(int MouseAspect);
void RestoreMouseAspect(void);

#endif // _GRAPHICS_GRAPHICS_H_
