/* Project SWORD
   V2.0

   SubSystem : Samples programs : Hello World application
   File      : Samples/Hello/Hello.CC
   Author    : Eric NICOLAS
   Overview  : Hello sample program main file
   UpDate    : Nov 20, 1995

** Copyright (C) 1993,1995 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Sword.H"

#define cmHelloWindow 10000

TFont *BigFont;

// ==== HELLO WINDOW OBJECT ==================================================

// This objet draw the inside of the Hello Window, show a uniform light gray
// background, with a big HELLO text

struct THello : TZone
{ THello(TRect& R);
  virtual void Draw(TRect& Clip);
};

THello::THello(TRect& R) : TZone(R)
{ // Tell the object that it must grow with its parent window
  SetOptions(opCSHiX | opCSHiY);
}

void THello::Draw(TRect& )
{ // Select the LightGray color and draw the background
  SetSysColor(GetColor(LightGray));
  Bar(0,0,Where.L()-1,Where.H()-1);
  // Select the black color and draw the text
  SetSysColor(GetColor(Black));
  PutStr(20,20,"Hello World !",BigFont);
  PutStr(20,60,"S. W. O. R. D.",BigFont);
}

// ==== APPLICATION OBJECT ===================================================

// This object is the application object. Construct the main menu, and
// create a Hello window in response to the menu command.

struct THelloApp : TApp
{ THelloApp(char *argv0);
  virtual boolean HandleCommand(long Command, char Info08b=0, short Info16b=0, long Info32b=0, void *InfoPtr=NULL);
};

THelloApp::THelloApp(char *argv0) : TApp(argv0)
{ // Create main menu
  TMenu *Menu=new TMenu("Hello sample",opMainMenu);
    Menu->Insert(new TMenuChoice("&Hello Window",0,cmHelloWindow));
    Menu->Insert(new TMenuChoice());
    Menu->Insert(new TMenuChoice("&Quit",ScanAltX,cmQuit));
    Menu->InitChoices();
  Desktop->Insert(Menu);
}

boolean THelloApp::HandleCommand(long Command, char Info08b, short Info16b, long Info32b, void *InfoPtr)
{ if (TApp::HandleCommand(Command,Info08b,Info16b,Info32b,InfoPtr)) return TRUE;
  switch(Command)
  { case cmQuit:
      ExitCode=1;
      return TRUE;
    case cmHelloWindow:
      TWindow *Window=new TStdWindow(100,100,300,300,"Hello Word !",TRUE);
      Window->Insert(new THello(Window->Inside));
      Desktop->Insert(Window);
      return TRUE;
  }
  return FALSE;
}

// ==== MAIN PROGRAMM ========================================================

int main(char , char *argv[])
{ THelloApp *HelloApp;

  // Load the big font for showing 'Hello' text
  BigFont=new TFont("TMS38");

  // Execute Application
  HelloApp=new THelloApp(argv[0]);
  HelloApp->Run();
  delete HelloApp;

  // destry big font
  delete BigFont;

  return 0;
}
