/* Project SWORD
   V2.0

   SubSystem  : Little usefull graphical objects
   CommandNos : 3100..3199
   File       : Src/Gadgets/Button.CC
   Authors    : Olivier PAYEN, Eric NICOLAS
   Overview   : Objects TButton and TStdButton
   UpDate     : Oct 11, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"

// ----- Object TButton

short RegTButton;
char *IdentTButton = "TButton";

// Delais en 1/100 de secondes

#define DelayTime    15
#define RepetTime    8
#define DownTime     15

// Contructors

TButton::TButton() : TZone()
{ Init();
}

TButton::TButton(int X, int Y, int L, int H, long _Command, int _ScanCode, int _Options) :
  TZone(X,Y,L,H)
{ Init(_Command,_ScanCode,_Options);
}

TButton::TButton(TRect& R, long _Command, int _ScanCode, int _Options) :
  TZone(R)
{ Init(_Command,_ScanCode,_Options);
}

void TButton::Init(long _Command, int _ScanCode, int _Options)
{ Register=RegTButton;
  Ident=IdentTButton;
  Command=_Command;
  ScanCode=_ScanCode;
  SetOptions(opSelectable | opGetAllEvents);
  if (_Options & boDisabled)
  { SetStatus(sfDisabled);
    _Options&=~boDisabled;
  }
  ButtonOptions=_Options;
}

TButton::~TButton(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

// Events

boolean TButton::MouseLUp(TPoint& , int )
{ if (GetStatus(sfDown))
  { ClearStatus(sfDown);
    Invalidate();
    if (GetStatus(sfMouseIn))
      if (!(ButtonOptions & boImmediate)) Action();
    return TRUE;
  }
  return FALSE;
}

boolean TButton::MouseLDown(TPoint& , int )
{ if (!GetStatus(sfDisabled))
    if (GetStatus(sfMouseIn))
    { SetStatus(sfDown);
      Invalidate();
      if (ButtonOptions & boImmediate) Action();
      if (ButtonOptions & boRepetition) SetAlarm(cmButtonReAction,DelayTime,this);
      return TRUE;
    }
  return FALSE;
}

boolean TButton::HandleCommand(long Command, char , short , long , void *InfoPtr)
{ switch(Command)
  { case cmSelect   :
    case cmUnSelect :
      if (Focus()) Invalidate();
      break;
    case cmButtonReAction :
      if (InfoPtr==this)
        if (GetStatus(sfDown) && GetStatus(sfMouseIn))
        { Action();
          SetAlarm(cmButtonReAction,RepetTime,this);
        }
      break;
  }
  return FALSE;
}

boolean TButton::KeyDown(int SC)
{ if (TZone::KeyDown(SC)) return TRUE;
  if (!GetStatus(sfDisabled))
  { int C=SC;
    if (ButtonOptions & boNoCase) ScanCodeUpr(C);
    if (GetStatus(sfSelected))
      if (C==(int)' ')
      { KeyboardAction();
        return TRUE;
      }
    if (ButtonOptions & boShiftedScanCode)
    { // Touche = ScanCode+Shift
      if (GetToggleStatus() & tgShift)
        if (C==ScanCode)
        { KeyboardAction();
          return TRUE;
        }
    }
    else
    { // Touche = ScanCode
      if (C==ScanCode)
      { KeyboardAction();
        return TRUE;
      }
    }
  }
  return FALSE;
}

// Graphics

void TButton::DrawSelect(int Depl)
{ SetSysColor(GetColor(1));
  Rectangle(4+Depl,4+Depl,Where.L()-5+Depl,Where.H()-5+Depl);
}

void TButton::DrawInside(int )
{ }

int TButton::DrawFrame()
{ return Frame3D(GetStatus(sfDown));
}

void TButton::Draw(TRect& )
{ int D;
  SetSysColor(GetColor(2));
  Bar(0,0,Where.L()-1,Where.H()-1);
  D=DrawFrame();
  if (GetStatus(sfDisabled)) SetSysColor(GetColor(1));
                        else SetSysColor(GetColor(0));
  DrawInside(D);
  if (Focus()) DrawSelect(D);
}

// Action

void TButton::Action(void)
{ SetCommand(Command,this);
}

void TButton::KeyboardAction(void)
{ SetStatus(sfDown);
  Invalidate();
  ShowDrawingNow();
  Delay(DownTime);
  ClearStatus(sfDown);
  Invalidate();
  ShowDrawingNow();
  Action();
}

// Objects streams

void TButton::Read(TDisk* file)
{ TZone::Read(file);
  file->Read(&Command,sizeof(long));
  ReadInt(file,&ScanCode);
  ReadInt(file,&ButtonOptions);
}

void TButton::Write(TDisk* file)
{ TZone::Write(file);
  file->Write(&Command,sizeof(long));
  WriteInt(file,ScanCode);
  WriteInt(file,ButtonOptions);
}

// ----- StdButton

short RegTStdButton;
char *IdentTStdButton = "TStdButton";

TStdButton::TStdButton() : TButton()
{ Init();
}

TStdButton::TStdButton(int X, int Y, int L, int H, long _Command, int _ScanCode, int _Options, char* _Text, TMapping* _Mapp) :
  TButton(X,Y,L,H,_Command,_ScanCode,_Options)
{ Init(_Text,_Mapp);
}

TStdButton::TStdButton(TRect& R, long _Command, int _ScanCode, int _Options, char* _Text, TMapping* _Mapp) :
  TButton(R,_Command,_ScanCode,_Options)
{ Init(_Text,_Mapp);
}

void TStdButton::Init(char* _Text, TMapping* _Mapp)
{ Register=RegTStdButton;
  Ident=IdentTStdButton;
  Mapp=_Mapp;
  if (_Text!=NULL) ParamText=strdup(_Text); else ParamText=NULL;
  Init2();
}

void TStdButton::Init2(void)
{ int L=Where.L()-8;
  // :: If there is a mapping, compute its position and kepp its space
  if (Mapp!=NULL)
  { dXM=Where.L()-3-Mapp->Width;
    dYM=(Where.H()-3-Mapp->Height)/2+1;
    L-=Mapp->Width+4;
  }
  // :: If there is a text, truncate it to L, and compute its position
  if (ParamText==NULL) Text=NULL;
  else
  { Text=strdup(ParamText);
    FontSystem->TruncSysStr(L,ParamText,Text);
    dXT=4+(L-FontSystem->WidthSysStr(Text))/2;
    dYT=(Where.H()-FontSystem->HeightStr(Text))/2;
    // Search for a HotKey in the system text
    char *P=strchr(Text,'&');
    if (P!=NULL) ScanCode=(short)(*(P+1));
  }
}

TStdButton::~TStdButton()
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TStdButton::Done(void)
{ if (Text!=NULL)      free(Text);
  if (ParamText!=NULL) free(ParamText);
  if (Mapp!=NULL)
    if (Mapp->Options & MAP_Delete) delete Mapp;
  TButton::Done();
}

void TStdButton::DrawInside(int Depl)
{ if (Text!=NULL) PutSysStr(dXT+Depl,dYT+Depl,Text,FontSystem);
  if (Mapp!=NULL) Mapp->Draw(dXM+Corner.X()+Depl,dYM+Corner.Y()+Depl);
}

void TStdButton::SetColorGroup(char ColorGroup)
{ if (Mapp!=NULL) Mapp->SetColorGroup(ColorGroup);
  TButton::SetColorGroup(ColorGroup);
}

// Objects streams

void TStdButton::Read(TDisk* file)
{ char Tmp;
  TButton::Read(file);
  if (ParamText!=NULL) free(ParamText);
  ReadString(file,&ParamText);
  file->Read(&Tmp,sizeof(char));
  if (Tmp)
  { // If there is no mapping, generate one in order to be able to read the new
    if (Mapp==NULL) Mapp=new TSysIcone(7,7,ICO_OK);
    // Read the new mapping
    Mapp->Read(file);
  }
  else
  { if (Mapp!=NULL) delete Mapp;
    Mapp=NULL;
  }
  Init2();
}

void TStdButton::Write(TDisk* file)
{ char Tmp;
  TButton::Write(file);
  WriteString(file,ParamText);
  Tmp=(Mapp!=NULL);
  file->Write(&Tmp,sizeof(char));
  if (Tmp) Mapp->Write(file);
}

// ----- Standard Buttons

TOKButton::TOKButton(int X, int Y) :
  TStdButton(X,Y,60,23,cmOK,ScanReturn,0,"OK",new TSysIcone(16,11,ICO_OK))
{ }

TCancelButton::TCancelButton(int X, int Y) :
  TStdButton(X,Y,80,23,cmCancel,ScanEscape,0,"Cancel",new TSysIcone(13,12,ICO_Cancel))
{ }
