/* Project SWORD
   V2.0

   SubSystem : Basic objects, General use mecanisms
   File      : Src/Mecanism/Collec.CC
   Author    : Eric NICOLAS
   Overview  : Objects TCollection, TSortedCollection : Abstract objects
               for arrays and sorted arrays of variable size
   UpDate    : Mar 18, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Collec.H"

// ----- Object TCollection

// Constructor / Destructor

TCollection::TCollection(long BeginSize, long SizeIncr)
{ Array=NULL;
  IncrSize=SizeIncr;
  ReSize(BeginSize);
  CurrentItems=0;
}

TCollection::~TCollection()
{ delete Array;
}

void TCollection::DeleteItems()
{ long i;
  for(i=0;i<CurrentItems;i++)
    delete Array[i];
}

// Acces to datas

long TCollection::Put(Pvoid *Item)
{ if (CurrentItems==CurrentSize) ReSize(CurrentSize+IncrSize);
  Array[CurrentItems]=*Item;
  CurrentItems++;
  return (CurrentItems-1);
}

void *TCollection::Get(long Position)
{ if ((Position>=0)&&(Position<CurrentItems))
    return Array[Position];
  else
    return NULL;
}

long TCollection::NbElements()
{ return CurrentItems;
}

// Memory Management

void TCollection::ReSize(long NewSize)
{ Pvoid *NewArray;
  // Allocate a new array of the desired size
  NewArray=new Pvoid[NewSize];
  if (Array!=NULL)
  { // Transfer form old to new Array
    memcpy(NewArray,Array,CurrentSize*sizeof(Pvoid));
    // DeAllocate old array
    delete Array;
  }
  Array=NewArray;
  CurrentSize=NewSize;
}

// ---- TSortedCollection

// Constructor

TSortedCollection::TSortedCollection(long BeginSize, long SizeIncr) :
  TCollection(BeginSize,SizeIncr)
{ Doublons=FALSE;
}

// Acces to datas

long TSortedCollection::Put(Pvoid *Item)
{ long PosToInsert;
  // Treat first the case of the first item in the list
  if (CurrentItems==0) return TCollection::Put(Item);
  // Then the case of next items
  PosToInsert=GetPosition(*Item);
  // Doublons checking
  if (!Doublons)
    if (Comparison(Item,Array[PosToInsert])==0)
    { // The item is already in the collectio
      // So we can destroy it and replace it by the item in the collection
      delete (*Item);
      *Item=Array[PosToInsert];
      return PosToInsert;
    }
  // The item is not in the list. Insert it before PosToInsert
  if (CurrentItems==CurrentSize) ReSize(CurrentSize+IncrSize);
  #ifdef __TURBOC__
  memmove(Array+PosToInsert+1,Array+PosToInsert,(CurrentItems-PosToInsert)*sizeof(Pvoid));
  #else
  memcpy(Array+PosToInsert+1,Array+PosToInsert,(CurrentItems-PosToInsert)*sizeof(Pvoid));
  #endif
  Array[PosToInsert]=*Item;
  CurrentItems++;
  return PosToInsert;
}

long TSortedCollection::GetPosition(Pvoid &Item)
{ long i1,i2,im;
  // Treat first particular case : No Elements
  if (CurrentItems==0) return -1;
  // Preparation
  i1=0; i2=CurrentItems-1;
  if (Comparison(Item,Array[i1])<=0) return i1;
  if (Comparison(Item,Array[i2])==0) return i2;
  if (Comparison(Item,Array[i2])> 0) return i2+1;
  // Normal cases
  while(i2-i1>1)
  { im=(i1+i2)/2;
    switch(Comparison(Array[im],Item))
    { case -1 : i1=im; break;
      case  0 : return im;
      case  1 : i2=im; break;
    }
  }
  return i2;
}

// Sorting methods

void TSortedCollection::DoSort(long a, long b)
{ long  i=a,j=b;
  Pvoid x=Array[(i+j)/2],t;
  do
  { while( Comparison(Array[i],x) < 0 ) i++;
    while( Comparison(x,Array[j]) < 0 ) j--;
    if (i<=j)
    { t=Array[i]; Array[i]=Array[j];  Array[j]=t;
      i++; j--;
    }
  } while(i<=j);
  if (a<j) DoSort(a,j);
  if (i<b) DoSort(i,b);
}

void TSortedCollection::Sort(void)
{ DoSort(0,CurrentSize-1);
}
