/* Project SWORD
   V2.0

   SubSystem : Mathematical toolbox
   File      : LibSrc/ToolBox/Math/Math.CC
   Author    : Eric NICOLAS
   Overview  : General functions for Math toolbox initialization
   UpDate    : May 18, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <math.h>
#include "Common/Common.H"
#include "ToolBox/Math/Math.H"

static char *ErrorMsgs[8]  =
          { "Acces to a vector out of its size",
			"Operations between vectors of different size",
			"Acces to a matrix out of its size",
			"Operations between matrixes of different size",
			"Operations with a vector of a wrong size",
			"Operation only possible on a square matrix",
			"Singular Matrix",
			"Impossible to factorise a constant"
		  };

static char *GetErrorMessage(int Error)
{ if ((Error>=MError_Base) && (Error<=MError_End))
  { int NoMessage;
    switch(Error)
    { case MError_Vector_OutOfSize     : NoMessage=0; break;
      case MError_Vector_MixingSizes   : NoMessage=1; break;
      case MError_Matrix_OutOfSize     : NoMessage=2; break;
      case MError_Matrix_MixingSizes   : NoMessage=3; break;
      case MError_Matrix_VectorSize    : NoMessage=4; break;
      case MError_Matrix_Rectangular   : NoMessage=5; break;
      case MError_Matrix_Singularity   : NoMessage=6; break;
      case MError_Poly_NoFactorisation : NoMessage=7; break;
    }
    return ErrorMsgs[NoMessage];
  }
  return NULL;
}

void InitMath(void)
{ AddErrorHandler(GetErrorMessage);
}

void DoneMath(void)
{ }
