//=======================================================================
//  mymodal.cxx - Source file for myModalDialog class
//  Copyright (C) 1995  Bruce E. Wampler
//
//  This program is part of the V C++ GUI Framework example programs.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  (see COPYING) along with this program; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//=======================================================================

#include "mymodal.h"
#include <v/vnotice.h>

//	The following would be automatically generated by Vigr.  There
//	should be some regular algroithm for generating the #defines -
//	e.g., 2 letters from class name (md), something from the Cmd type (CB),
//	and a value to distinguish each label from aother.  The user should
//	also be able to override the default generated name.  There can be
//	some standard names such as xxBtnOK, etc.  The idea is to get some
//	good compromise for uniqueness, ease of generation, and readability.
//	Each module should have labels starting at the next 100, with the
//	top level window starting with 100.

const ItemVal mmLbl1 = 300;
const ItemVal mmBtn1 = 301;
const ItemVal mmBtn2 = 302;
const ItemVal mmBtnCncl = 303;
const ItemVal mmBtnOK = 304;

// This would also be automatically generated by Vigr. One of the functions
// of Vigr is to allow the user to specify types and positions of Cmds in the
// dialogs.
//
    static DialogCmd DefaultCmds[] =
      {

	{C_Label, mmLbl1, 0,"X",NoList,CA_MainMsg,isSens,NoFrame, 0, 0},
	
	{C_Button, mmBtn1, mmBtn1," Test 1 ",NoList,CA_None,isSens,NoFrame, 0, mmLbl1},
	{C_Button, mmBtn2, mmBtn2," Test 2 ", NoList,CA_None,isSens,NoFrame,
		mmBtn1,mmLbl1},

	{C_Button, M_Cancel, M_Cancel," Cancel ",NoList,CA_None,isSens,NoFrame,
		0, mmBtn1},
	{C_Button, M_OK, M_OK, "   OK   ", NoList, CA_DefaultButton, 
		isSens, NoFrame, M_Cancel, mmBtn1},

	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };


//======================>>> myModalDialog::myModalDialog <<<==================
  myModalDialog::myModalDialog(vBaseWindow* bw) :
    vModalDialog(bw)
  {
    UserDebug(Constructor,"myModalDialog::myModalDialog()\n")
    AddDialogCmds(DefaultCmds);		// add the predefined commands
  }

//===================>>> myModalDialog::~myModalDialog <<<====================
  myModalDialog::~myModalDialog()
  {
    UserDebug(Destructor,"myModalDialog::~myModalDialog() destructor\n")
  }

//====================>>> myModalDialog::DialogCommand <<<====================
  void myModalDialog::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)
  {
    // After the user has selected a command from the dialog,
    // this routine is called with the value.  This code would be generated
    // by Vigr.

    vNoticeDialog note(this);

    UserDebug2(CmdEvents,"myModalDialog::DialogCommand(id:%d, val:%d)\n",id, retval)

    switch (id)		// We will do some things depending on value
      {
	case mmBtn1:		// Button
	  {
	    note.Notice(" Test 1 ");
	    break;
	  }

	case mmBtn2:		// Button
	  {
	    note.Notice(" Test 2 ");
	    break;
	  }
      }

    vModalDialog::DialogCommand(id,retval,ctype);
  }
