/*
------------------------------------------------------------------------
| Source File   | X10_C.H                                              |
|               |                                                      |
| System        | X-10 Professional Developers Library for C, v. 3.1   |
|               |                                                      |
| Purpose       | Header file to use with the X10_???.LIB              |
|               |                                                      |
| Author        | Dale Morrison                                        |
| Copyright     | Smart Home Technology, 1993, 1994                    |
----------------------------------------------------------------------*/

#define     ALL_UNITS_OFF       17
#define     HAIL_REQ            18
#define     DIM                 19
#define     EXTENDED_DATA       20  /* Not used by X10 */
#define     ON                  21
#define     PRESET_DIM_LOW      22  /* Not used by X10 */
#define     ALL_LIGHTS_OFF      23  /* Not used by X10 */
#define     STATUS_OFF          24
#define     ALL_LIGHTS_ON       25
#define     HAIL_ACK            26
#define     BRIGHT              27
#define     STATUS_ON           28
#define     OFF                 29
#define     PRESET_DIM_HIGH     30  /* Not used by X10 */
#define     EXTENDED_CODE       31  /* Not used by X10 */
#define     STATUS_REQ          32

#define     SWITCH              1
#define     LAMP                2
#define     APPL                3
#define		CTRLER				4

#define     NO                  0
#define     YES                 1

#define     FALSE               0
#define     TRUE                1

#define     TRANSMIT            0
#define     RECEIVE             1

#define     SAVE                0
#define     LOAD                1
#define     LOAD_BEGIN          1
#define     LOAD_MODULE         2
#define     LOAD_END            3
#define     SAVE_BEGIN          4
#define     SAVE_MODULE         5
#define     SAVE_END            6

#define     NO_REFRESH          0
#define     REFRESH             1

#define     RUNNING             0
#define     EXPIRED             1
#define     CHECKED             2
#define     CANCELLED           3

#define     STEPS               0
#define     PERCENT             1

#define     DAYLIGHT_START      0
#define     DAYLIGHT_END        1

#define     MDY                 0
#define     DMY                 1
#define     YMD                 2

enum {SUN, MON, TUE, WED, THU, FRI, SAT};

typedef struct {
    char unit[18];
    int funct;
} x10cmd_struct;

typedef struct x10_addr_tag {
    char unit_addr[4];
    struct x10_addr_tag *prev, *next;
} x10_addr_node;

typedef struct {
    x10_addr_node *head;
    x10_addr_node *tail;
} group_struct;

#undef X10DECL
#undef X10INIT

#ifdef __X10_TC_DECL
    #define X10DECL
    #define X10INIT(x)  x
#else
    #define X10DECL     extern
    #define X10INIT(x)
#endif

X10DECL x10cmd_struct X10Cmd;

X10DECL char    X10Date[11] X10INIT(= "");
X10DECL char    X10Time[9] X10INIT(= "");
X10DECL int     X10Dow X10INIT(= 0);
X10DECL char    Dawn [9] X10INIT(= "");
X10DECL char    Sunrise [9] X10INIT(= "");
X10DECL char    Sunset [9] X10INIT(= "");
X10DECL char    Dusk [9] X10INIT(= "");
X10DECL int     ShowTransmit X10INIT(= 0);
X10DECL int     PowerOutage X10INIT(= 0);
X10DECL int     DateType X10INIT(= 0);


void    add_to_group(group_struct *group, char *unit_addr, ...);
void    add_to_time(char *time, int min, char *new_time);

void    brighten_selected_modules(char *house, int steps);
void    bring_selected_to_level(char *house, int level);

void    cancel_timer(int num);
void    clear_x10cmd(x10cmd_struct *cmd_var);
void    close_tw523(char *filename);

int     date_is(char *date);
int     date_is_after(char *date);
int     date_is_before(char *date);
int     date_is_between(char *date1, char *date2);
void    delete_group(group_struct *group);
int     dim_by(int type);
void    dim_group(group_struct *group, int level);
void    dim_module(char *unit_addr, int level);
void    dim_selected_modules(char *house, int steps);
void    disable_com_interrupt(void);
void    display_status(char *house);
void    display_x10_globals(void);
int     dow_is(int dow);
int     dow_is_between(int dow1, int dow2);
int     dow_is_not(int dow);

void    enable_com_interrupt(void);

void    flash_module(char *unit_addr, int times);
void    flash_selected_modules(char *house, int times);
void    flush_buffer(int tx_rx);
void    force_group(group_struct *group, int on_off);
void    force_module(char *unit_addr, int on_off);
void    force_selected_modules(char *house, int on_off);

char *  get_time(char *time);
int     get_x10cmd(x10cmd_struct *cmd_var);
void    get_x10date(long *secs);
int     get_x10time(void);

void    increment_module_step(char *unit_addr, int steps);
void    increment_selected_step(char *house, int steps);

void    initialize_module(char *unit_addr, int type, int level, int refresh, void *udp);
int		init_timers(int num);

long    load_status(char *filename);
void    load_sun_times(void);

int     module_init_step(char *unit_addr);
int     module_level(char *unit_addr);
int     module_max(char *unit_addr);
int     module_refresh(char *unit_addr);
int     module_selected(char *unit_addr);
int     module_step(char *unit_addr);
int     module_type(char *unit_addr);
void *  module_udp(char *unit_addr);

int     no_daylight_time(void);

void    open_tw523(char *filename);

void    pause(int secs);
void    play_catchup(char *filename);
int     pop_x10cmd(int tx_rx, int *house, int *funct);
void    push_x10cmd(int tx_rx, int house, int funct);

void    refresh_all_modules(char *house);
void    refresh_entire_system(void);
void    refresh_group(group_struct *group);
void    refresh_module(char *unit_addr);
void    refresh_selected_modules(char *house);
int     reset_timer(int num);
void	reverse_group(group_struct *group);

long    save_status(char *filename);
void    select_modules(char *unit_addr, ...);
void    send_x10cmd(char house, int cmd);

void    set_all_refresh(char *house, int refresh);
void    set_all_selected(char *house, int select);
void    set_all_step(char *house, int step);
void    set_all_type(char *house, int mod_type);

void    set_catchup_refresh(void (*funct)());
void    set_daylight_flag(int yes_no);
void    set_daylight_funct(int type, int (*funct)());
void    set_daylight_time(void);
void    set_display_funct(int type, void (*funct)());
void	set_electrical_freq(int hz);
void    set_map_coord(float lng, float lat, float tz, char *sdt, char *edt);

void    set_module_step(char *unit_addr, int step);
void    set_module_refresh(char *unit_addr, int refresh);
void    set_module_selected(char *unit_addr, int select);
void    set_module_type(char *unit_addr, int mod_type);
void    set_module_udp(char *unit_addr, void *udp);

void    set_recv_timeout(float secs);
void	set_repeat(int count);
int     set_repeat_default(int count);
void    set_selected_step(char *house, int step);
void    set_standard_time(void);
void    set_status_funct(int type, int (*funct)());

void    set_time(char *new_time);

void    start_timer(int num, char *time);
int     status_read(void *buffer, int size);
int     status_write(void *buffer, int size);

int     time_is(char *time);
int     time_is_after(char *time);
int     time_is_before(char *time);
int     time_is_between(char *time1, char *time2);
int     time_is_not(char *time);

long    timer_count(int num);
int     timer_expired(int num);
int     timer_status(int num);
void    turn_all_modules(char *house, int on_off);
void    turn_group(group_struct *group, int on_off);
void    turn_module(char *unit_addr, int on_off);
void    turn_selected_modules(char *house, int on_off);

int     x10cmd_is(x10cmd_struct *cmd_var, char *unit, int funct);
int     x10cmd_waiting(int tx_rx);
