unit Calcdemo;



interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, DB, DBTables,
  Grids, DBGrids, DBCtrls, TabNotBk, Adcalcbt;

type
  TTAdrockCalcEditDemoForm = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Panel2: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Bevel1: TBevel;
    DataSource1: TDataSource;
    Table1: TTable;
    TabbedNotebook1: TTabbedNotebook;
    Panel5: TPanel;
    Label6: TLabel;
    Label8: TLabel;
    Bevel2: TBevel;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    Label17: TLabel;
    Label18: TLabel;
    Label20: TLabel;
    Label19: TLabel;
    Panel4: TPanel;
    SetCalendarFontButton: TBitBtn;
    FontDialog1: TFontDialog;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label4: TLabel;
    Label7: TLabel;
    Label22: TLabel;
    Label5: TLabel;
    GroupBox2: TGroupBox;
    RadioButton7: TRadioButton;
    RadioButton8: TRadioButton;
    RadioButton9: TRadioButton;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    GroupBox5: TGroupBox;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    Label23: TLabel;
    ShowButtonNeverRadioButton: TRadioButton;
    RadioButton11: TRadioButton;
    RadioButton12: TRadioButton;
    VersionLabel: TLabel;
    AdrockCalcEdit1: TAdrockCalcEdit;
    AdrockCalcEdit2: TAdrockCalcEdit;
    AdrockCalcEdit3: TAdrockCalcEdit;
    AdrockCalcEdit4: TAdrockCalcEdit;
    AdrockCalcEdit5: TAdrockCalcEdit;
    AdrockCalcEdit6: TAdrockCalcEdit;
    Table1EmpNo: TIntegerField;
    Table1LastName: TStringField;
    Table1FirstName: TStringField;
    Table1Salary: TFloatField;
    AdrockCalcEdit7: TAdrockCalcEdit;
    Label10: TLabel;
    ShowCalcFunctionsCheckBox: TCheckBox;
    SpaceBetweenButtonsLabel: TLabel;
    ScrollBar1: TScrollBar;
    Label9: TLabel;
    Bevel4: TBevel;
    AdrockCalcEdit9: TAdrockCalcEdit;
    AdrockCalcEdit10: TAdrockCalcEdit;
    AdrockCalcEdit11: TAdrockCalcEdit;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    MaxDecimalsLabel: TLabel;
    ScrollBar2: TScrollBar;
    procedure SetCalendarFontButtonClick(Sender: TObject);
    procedure RadioButton3Click(Sender: TObject);
    procedure RadioButton4Click(Sender: TObject);
    procedure RadioButton5Click(Sender: TObject);
    procedure RadioButton6Click(Sender: TObject);
    procedure RadioButton7Click(Sender: TObject);
    procedure RadioButton8Click(Sender: TObject);
    procedure RadioButton9Click(Sender: TObject);
    procedure TabbedNotebook1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure ShowButtonNeverRadioButtonClick(Sender: TObject);
    procedure RadioButton11Click(Sender: TObject);
    procedure RadioButton12Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ShowCalcFunctionsCheckBoxClick(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure ScrollBar2Change(Sender: TObject);
  private
    { Private declarations }
    InUpdateFromRadioButton : Boolean;
  public
    { Public declarations }
  end;

var
  TAdrockCalcEditDemoForm: TTAdrockCalcEditDemoForm;

implementation

{$R *.DFM}

procedure TTAdrockCalcEditDemoForm.SetCalendarFontButtonClick(Sender: TObject);
begin
     FontDialog1.Font.Assign(AdrockCalcEdit1.CalculatorFont);
     FontDialog1.Execute;
     AdrockCalcEdit1.CalculatorFont.Assign(fontDialog1.Font);
end;

procedure TTAdrockCalcEditDemoForm.RadioButton3Click(Sender: TObject);
begin
     AdrockCalcEdit1.CalculatorPosition := cpLeftTop;
end;

procedure TTAdrockCalcEditDemoForm.RadioButton4Click(Sender: TObject);
begin
    AdrockCalcEdit1.CalculatorPosition := cpRightTop;
end;

procedure TTAdrockCalcEditDemoForm.RadioButton5Click(Sender: TObject);
begin
    AdrockCalcEdit1.CalculatorPosition := cpLeftBottom;

end;

procedure TTAdrockCalcEditDemoForm.RadioButton6Click(Sender: TObject);
begin
    AdrockCalcEdit1.CalculatorPosition  := cpRightBottom;
end;

procedure TTAdrockCalcEditDemoForm.RadioButton7Click(Sender: TObject);
begin
    AdrockCalcEdit1.Alignment := taCenter;
end;

procedure TTAdrockCalcEditDemoForm.RadioButton8Click(Sender: TObject);
begin
    AdrockCalcEdit1.Alignment := taLeftJustify;
end;

procedure TTAdrockCalcEditDemoForm.RadioButton9Click(Sender: TObject);
begin
    AdrockCalcEdit1.Alignment := taRightJustify;
end;

procedure TTAdrockCalcEditDemoForm.TabbedNotebook1Change(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
  AllowChange := TRUE;
  if (NewTab = 2) then
   begin
     try;
       Table1.Open;
     except;
       MessageDlg('Sorry, unable to open the Database Table', mtError, [mbOK], 0);
       AllowChange := FALSE;
     end;
   end
  else
    Table1.Open;
end;

procedure TTAdrockCalcEditDemoForm.ShowButtonNeverRadioButtonClick(Sender: TObject);
begin
    AdrockCalcEdit1.ShowButton := sbNever;
end;

procedure TTAdrockCalcEditDemoForm.RadioButton11Click(Sender: TObject);
begin
    AdrockCalcEdit1.ShowButton := sbFocused;
end;

procedure TTAdrockCalcEditDemoForm.RadioButton12Click(Sender: TObject);
begin
    AdrockCalcEdit1.ShowButton := sbAlways;
end;

procedure TTAdrockCalcEditDemoForm.FormCreate(Sender: TObject);
begin
     Caption := 'Sample program for TAdrockCalcEdit Version '+AdrockCalcedit1.Version;
     VersionLabel.Caption := 'TAdrockCalcEdit Version '+AdrockCalcedit1.Version;
     TabbedNotebook1.PageIndex :=0;
     SpaceBetweenButtonsLabel.Caption := 'Space Between Buttons = '+IntToStr(ScrollBar1.Position);
     MaxDecimalsLabel.Caption := 'Max Decimals = '+IntToStr(ScrollBar2.Position);
end;

procedure TTAdrockCalcEditDemoForm.ShowCalcFunctionsCheckBoxClick(Sender: TObject);
begin
     AdrockCalcEdit1.ShowCalcFunctions := not AdrockCalcEdit1.ShowCalcFunctions;
end;

procedure TTAdrockCalcEditDemoForm.ScrollBar1Change(Sender: TObject);
begin
     AdrockCalcEdit1.ButtonGap := ScrollBar1.Position;
     SpaceBetweenButtonsLabel.Caption := 'Space Between Buttons = '+IntToStr(ScrollBar1.Position);
end;

procedure TTAdrockCalcEditDemoForm.ScrollBar2Change(Sender: TObject);
begin
     AdrockCalcEdit1.MaxDecimals := ScrollBar2.Position;
     MaxDecimalsLabel.Caption := 'Max Decimals = '+IntToStr(ScrollBar2.Position);
end;

end.
