;           09h interrupt handler (keyboard)
;           Part of "The Super Console Defender"
;           Copyright (c) RaMax (Rayevskiy Maxim) 1994-1996
                                                          
int_09:     cli             ;Don't interrupt me         
            push   ax       ;Save registers to be used
            push   ds                                 
            mov    ax,  cs  ;Make the data addressable
            mov    ds,  ax  
            in     al,  60h ;Read the scan-code
            sti             ;Enable interrupts
                                              
            mov    ah,  al ; Save the scan-code in another register
            and    al,  7fh; Get the numeric part og the code    
                                                             
      irp   theKey,CTRL,ALT,DELETE,INSERT,END                
            cmp    al,  sc&theKey&  ;Keys are recognized here
            jne    @After&theKey&                            
            mov    al,  m&theKey&                            
            jmp    @Key                                      
@After&theKey&:                                              
      endm                                                   
                                                             
@nextKey:                                                    
            cmp    keys,mCTRL+mALT+mINSERT ;CTRL-ALT-INS ?   
            jne    @more2    ; No - test for other keys
            test   status,indialog ; In dialog ?             
            jnz    old_09    ; Yes - call the old handler
            call   eoi       ; No - clear the interrupt
            pop    ds
            jmp    dialog
                     
@Key:       test ah, 80h ;Test whether the key was pressed or released
            jnz    @Keyreleased                                       
            or     keys,al  ;Pressed: set the flag               
            jmp    @nextKey                       
                                                  
@Keyreleased:                                     
            not    al       ;Released: clear the flag
            and    keys,al                           
            jmp    old_09                            
@more2:                                              
            test   status,indialog                   
            jz     @next1                            
            mov    ah,  keys                         
            and    ah,  mCTRL+mALT+mDELETE;CTRL-ALT-DEL ?
            cmp    ah,  mCTRL+mALT+mDELETE           
            je     @eoi ;Yes, this a reboot attempt while in dialog
                        ;Don't let it go!
            jmp    old_09                          
@next1:                                            
            test   status, closed ; Console open?
            jnz    @eoi           ; No, then continue    
            cmp    keys, mCTRL+mALT+mEND;CTRL-ALT-END?
            jne    old_09  ; No, continue
;           Two lines added
            cmp    passcount, 0
            je     old_09
;
            call   lock    ; Yes, lock the console
@eoi:                                             
            call   eoi                            
            pop    ds       
            pop    ax            
            iret          ; Return the control to the interrupted task
old_09:                                                               
            ; Restore the registers and transfer control to the previous   
            ; interrupt handler                                      
            pop    ds          
            pop    ax          
            db     0EAh        ; This is JMP FAR
adr_09:     dd     ?           ; This will the address of the previous 
                               ; interrupt handler                  
