; This is the source of the console defense utility "The Super Console Defender"
; Idea and realization Copyright (c) RaMax (Rayevskiy Maxim) 1994-1996
; Version 3.36e
; Last changes: 14 Jan 96
; Comments added: 14 May 95
; Translation into English: 5-7 Jan 96
; This is FreeWare, NOT public domain software.
; If you would like to use these sources, please contact me first.
; e-mail: RaMax@compuserve.com

version     equ    '3'
subver      equ    '7'
language    equ    'e'

left        equ    24 ; window's position
right       equ    56
top         equ    10
bottom      equ    14

paragraphstocopy  equ  1 ;Paragraphs to move upper by


wbuflen equ   2*(bottom-top+1)*(right-left+1); The length of the buffer used
;to save the contents of the area covered by the window
            include macros.asm ;  There is a window output macro in the file
            include common.mac
.model tiny                    ; Select the TINY memory model (COM file)
.code                          ; Start the code segment. (It is also the data
                               ;and stack because there are no more)
            org 100h           ;start the code at offset 100h (leave space for PSP)
start:      jmp    begin       ; get the control from DOS here
                               ; and jump to setup code

; Resident part of the code and common data start here


keep_sp     dw     ?    ;To save
keep_ss     dw     ?    ;the old stack

video_page  db     ?    ;Videopage's number

;Program's identification information follows

ProgID      db     'C_LOCK'           ;Program's name
IDend       label  byte
CompatID    db     version, subver, language   ;Compatibility information:
Compatend   label  byte                        ; if this data in loaded file
                                      ; is not the same, unload is impossible

                   ; Window's frame
box         db     ' The Super Console Defender ͻ'
            db     '                               '
            db     '                               '
            db     '                               '
            db     ' (c) RaMax  1996 ͼ'


                  ; Messages for the user
incorrect   db     'Incorrect password'
closedmess  db     'Console Locked'
enter2close db     'Enter a password for defense'
enter2open  db     'Enter the password to unlock'
          ; The lengths of the password in the main and temporary buffers
          ; are stored here
count       dw     0
passcount   dw     0
          ; The main and temporary buffers
password    db     25   dup    (0)
userpass    db     25   dup    (0)

; The keyboard state byte
keys        db     0

; The counter of the timer interrupts (ticks). Used for blinking frame.
ticks       db     0

; Program configuration byte
options     db     0
                        ; Possible options (bitmasks):
noFrame     equ    80h  ; - no blinking frame
noDefault   equ    40h  ; - default password off (not used)
graphics    equ    20h  ; - videocard is in graphics mode

status      db     0    ; Locker's status
                        ; Possible options:
opened      equ    0; - Not locking now
closedial   equ    1; - In dialog now, no reboot
                    ;   not locking now
closed      equ    2; - full lock
opendial    equ    3; - full lock, in dialog, no reboot
indialog    equ    1; - in dialog (any of two)

; Bitmaks for the keyboard state byte
mCTRL       equ    01h
mALT        equ    02h
mINSERT     equ    04h
mDELETE     equ    08h
mEND        equ    10h

; Keyboard scan codes
scCTRL      equ    1dh
scALT       equ    38h
scINSERT    equ    52h
scDELETE    equ    53h
scEND       equ    4fh

eoi         PROC   NEAR
            in     al,  61h; Send the End-Of-Interrupt signal..
            mov    ah,  al
            or     al,  80h
            out    61h, al ; ..to the keyboard..
            mov    al,  ah
            out    61h, al
            mov    al,  20h; .. and the interrupt controller
            out    20h, al
            ret
eoi         ENDP

UpCase      PROC   NEAR
            ; The letter to upper case conversion routine (CP866)
            ; AL - symbol
            cmp    al,  'a'
            jb     @_Exit
            cmp    al,  'z'
            ja     @_ChkCyr_Ah
            sub    al,  'z'-'Z'
            jmp    @_Exit
@_ChkCyr_Ah:cmp    al,  ''
            jb     @_Exit
            cmp    al,  ''
            ja     @_ChkCyr_Er
            sub    al,  ''-''
            jmp    @_Exit
@_ChkCyr_Er:cmp    al,  ''
            jb     @_Exit
            cmp    al,  ''
            ja     @_ChkCyr_Uk
            sub    al,  ''-''
            jmp    @_Exit
@_ChkCyr_Uk:cmp    al,  0F7h
            ja     @_Exit
            and    al,  0FEh
@_Exit:     ret
UpCase      ENDP

            include 09h.asm; keyboard handler
            include dialog.asm   ; User dialogs

; The subroutine to change to color of the screen's frame
; Programs EGA/VGA directly.
;            AL - frame's color

border      PROC NEAR
            push   dx
            push   ax
            mov    dx,  3DAh
@wait:      in al, dx
            test   al,  8h
            jz     @wait
            mov dx,  3C0h
            mov    al,  11h
            out    dx,  al
            pop    ax
            out    dx,  al
            mov    dx,  3dah
            in     al,  dx
            mov    dx,  3c0h
            mov    al,  20h
            out    dx,  al
            pop    dx
            ret
border      ENDP

; The subroutine performs the lock of the console
lock        PROC   NEAR
            mov    ax,  0002h ; mouse pointer off
            int    33h
            or     cs:status, closed
            ret
lock        ENDP

; Unlocking procedure
unlock      PROC   NEAR
            and    cs:status,NOT closed
            mov    ax,  0001h ; Mouse pointer on
            int    33h
            xor    al,  al
            call   border
            ret
unlock      ENDP


; Timer handler
int_08:
            push   ax ; Save the registers
            push   ds
            push   cs
            pop    ds
            test   options,  noFrame ; Frame off?
            jnz    @prev  ; Yes- call the previous handler
            inc    ticks ; Increase the tick counter

            cmp    ticks,36 ; ticks<36 ?
            jb     @docolor    ; Yes- leave the counter alone
            mov    ticks,0  ; No - Make it 0

            test   options, graphics
            jz     @testred

            test   status, indialog
            jz     @tryred18

            mov    al, 12h
            jmp    @anycolor


@docolor:
            cmp    ticks, 18 ; ࠢ  18
            jne    @prev
            test   options, graphics
            jz     @tryred18


            test   status,closed
            jz     @black
            jmp    @red

@testred:
            test   status,closed
            jz     @prev
@red:
            mov    al, 3ch
            jmp    @anycolor

@tryred18:
            test   status, closed
            jz     @prev
@black:
            xor    al,  al
@anycolor:
            call   border
@prev:
            pop ds
            pop ax ; restore registers
            db 0Eah  ;  And JMP FAR
adr_08:     dd     ?
; Please note, that I don't quite understand how the blinking frame works
; I did it without dryrunning and I know this works.


            include 2fh.asm ; 2fh handler
            include 33h.asm ; Mouse handler

;
;           Setup the program into memory (if possible)
;
begin:
            mov    ax, 0900h             ; Display the header
            mov    dx,  offset header
            int    21h
            mov    ah,  49h           ; Free the memory used
            mov    es,  ds:[2ch]      ; for the environment block
            int    21h
; Check the second copy
            mov    ax,  0bf00h
            cld
@90:        inc    ah                 ; Try all the possible values
            push   ax
            int    2fh
@100:       jmp    short @150
@110:       cmp    al,  0ffh          ; If not loaded
            jne    @120               ; try the next function
            mov    ax,  cs
            mov    bx,  es
            cmp    ax,  bx            ; If ES hasn't changed then
            je     @120               ; try the next
;
;           Compare identification portions
;
            mov    si,  offset ProgID
            mov    di,  si
            mov    cx,  offset IDend - offset ProgID
            repe   cmpsb
            jne    @120        ; No portion in memory
            mov    si,  offset IDend
            mov    di,  si
            mov    cx,  offset Compatend - offset IDend
            repe   cmpsb
            jne    WrongVer

            mov    ax,  es
            mov    progseg,ax ;  Found it! Memorize the segment
            jmp    @140  ;  JMP to second attempt handler (see params.asm)
WrongVer:
            pop    ax
            write  AnotherVer
            int    20h

@120:       pop    ax
@130:       cmp    ah,  0ffh   ; If not last function then
            jne    @90         ; try the next one
            cmp    byte ptr int_2f+2,0
                               ; There's a free number -
            je     @errmsg     ; now set it up!
            jmp    @160
@errmsg:    mov    ah,  9      ; Otherwise display the warning
            mov    dx,  offset no_free
            int    21h
            int    20h         ; and stop

;
;           Never mind this.
;
@150:       cmp    al,  0
            je     @continue
            jmp    @110
@continue:  pop    ax
            mov    byte ptr int_2f+2,ah
            mov    word ptr @100,9090h
            jmp    @130

            include params.asm ;  command-line options handler

;
;           Set the resident up
;

@160:
            mov ax,  cs ;  No resident copy found - make progseg=CS
            mov    progseg,ax
            cmp    byte ptr cs:80h,0 ; Command-line options?
            je     @install          ; There are no - start the setup
            call   @params           ; There are some - execute them first

@install:
            mov    ah,  9      ; Display the success message
            mov    dx,  offset install
            int    21h

     irp    No,2f,09,08,33  ; Save old vectors
            mov    ax,  35&No&h
            int    21h
            mov    word ptr adr_&No&,bx
            mov    word ptr adr_&No&+2,es
     endm

;Overwrite PSP
            mov    ax, cs
            sub    ax, paragraphstocopy
            mov    es, ax
            push   es

            mov    si, offset ProgID
            mov    di, si
            mov    cx, offset begin - offset ProgID
            cld
            rep    movsb
            pop    ds

     irp    No,2f,09,08,33  ; Setup new vectors
            mov    ax,  25&No&h
            mov    dx,  offset int_&No
            int    21h
     endm
            mov dx, offset begin+ wbuflen-16*paragraphstocopy
                                        ; length of memory to reserve
            int    27h ; Terminate but stay resident

;headers, messages and data. All non-resident

progseg     dw     0    ; Segment of the first copy of the program
;                       if there's no one, progseg=CS

header      db     13,'The Super Console Defender. The console locking utility. Part of FreeDOS.',10,13
            db     '  Version Unknown. (Around ', version, '.3', subver
            db     language,', I think)',10
            db     13,'Copyright (c) RaMax, 1995-96',10
            db     10,13,'The Mouse is dead + Less errors',10,13,'$'
already     db     10,13,'The Super Defender is defending you already...',10,13,'$'
no_free     db     10,10,13,'I am sorry, but someone wants you to remain unprotected:',7
            db     'loading impossible !',10,13,'$'
install     db     10,13,'The Super Defender is on duty now.',10,13
            db     'Press CTRL-ALT-INS(ERT) to enter the password',10,13
            db     'or CTRL-ALT-END to lock the console with the current password',10,13,'$'
AnotherVer  db     10,13, ' Another version of The Super Console Defender is found in memory.'
            db     10,13, '     Please use it or unload it prior to loading this one.',10,13,'$'
attached    db     10,13,' Impossible to unload The Super Defender:',10
            db     13,'  Some TSR is loaded after it, I guess.',10,13,'$'
removed     db     10,13,'  The Super Console Defender is completely removed.',10,13,'$'
help        db     10,'Use the following options:'
            db     10,13,'/l - blinking frame on/off',10,13
            db     '/u or /r - remove from memory',10,13
            db     '/c:password - lock the console with the password',10,13
            db     '/d:password - as above, but without locking',10,13
            db     'You can use "-" instead of "/". Options are not case-sensitive',10,13,'$'
closedbyc   db     10,13,'The console is locked from the command line',10,13
            db     'The Super Console Defender is Protecting you now.',10,13,'$'
Setdef      db     10,13, ' The password is loaded into internal buffer', 10, 13, '$'
remerror    db     13,'Fatal error while unloading...',10,13,'$'
lighton     db     'Useful blinking frame is on.',10,13,'$'
lightoff    db     'Annoying blinking frame is off.',10,13,'$'
passerr     db     'Invalid symbol is found in the password',10,13
            db     'Latin and cyrillic letters and digits are valid.',10,13,'$'
longpass    db     'Password is too long. Only 25 symbols are allowed.',10,13,'$'
colonerr    db     'While using option /C you missed the colon (":")',10,13,'$'
            end    start
