{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; advanced teqniques with data types

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBDAT;

type pMyElement = ^MyElement;
     MyElement = object (LinkageObjectType)

       constructor Initialize (Number : real);
       destructor Intercept; virtual;

       procedure Update (var Data; Size : word); virtual;
       procedure Element (var Data); virtual;
       procedure Dispose; virtual;

       procedure Display; virtual;

       function DataPointer (Position : word) : pointer; virtual;
       function DataSize : word; virtual;
       function IsAllocated : boolean; virtual;

     private

       NumberInElement : real;

     end;

     pMyList = ^MyList;
     MyList = object (LinkedListObjectType)

       constructor Initialize;

       procedure Add (var Data); virtual;
       procedure Insert (var Data; Index : word); virtual;

     end;

{ *** MyElement *** }

constructor MyElement.Initialize; begin InitializeEmpty; NumberInElement := Number; end;
destructor MyElement.Intercept; begin Dispose; Inherited Intercept; end;
procedure MyElement.Update; begin NumberInElement := Real(Data); end;
procedure MyElement.Element; begin Move (Data, NumberInElement, SizeOf(Real)); end;
procedure MyElement.Dispose; begin end;
procedure MyElement.Display; begin WriteLn (NumberInElement); end;
function MyElement.DataPointer;
begin DataPointer := Ptr (Seg(NumberInElement), Ofs(NumberInElement) + Pred(Position)); end;
function MyElement.DataSize; begin DataSize := SizeOf(NumberInElement); end;
function MyElement.IsAllocated; begin IsAllocated := Inherited IsAllocated; end;


{ *** MyList *** }

constructor MyList.Initialize;
begin Inherited Initialize (SizeOf(MyElement)); end;
procedure MyList.Add (var Data);
begin AddNode(New(pMyElement, Initialize(Real(Data)))); end;
procedure MyList.Insert (var Data; Index : word);
begin InsertNode(New(pMyElement, Initialize(Real(Data))), IndexedNode(Index)); end;


{ Test program }

var Numbers : MyList; Number : real;
begin
     WriteLn ('* My data type *');

     with Numbers do begin
          { Easy initialization when the element size is standardized }
          Initialize;

          { Add some elements to the new data type }
          Number := Pi;     Add (Number);
          Number := 1.414;  Add (Number);
          Number := 5;      Add (Number);

          { Check the result }
          Number := 0; Element (1, Number);
          WriteLn ('List contains ', Elements,
                 ' elements. The first is ', Number:0:5, '.');

          Intercept; { Don't forget to intercept all the links! }
     end;
end.