{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; reconstruction of a linked list object

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBDAT;

type tMyList = object (LinkedListObjectType)
       constructor Initialize;
       procedure Store (Text : string);
       procedure DoMyTask;
     end;


constructor tMyList.Initialize;
begin
     { Initiailize doubly linked list based on text strings }
     Inherited Initialize (SizeOf(String));
end;

procedure tMyList.Store (Text : string);
begin
     Add (Text); { Add string }
end;

{ Do some task to perform }
procedure tMyList.DoMyTask;
var Index : word;
begin
     if IsEmpty then WriteLn ('I am empty.') else WriteLn ('I contain something.');
     for Index := 1 to Elements do
         Write (String(ElementPointer(Index)^), ' ');
     WriteLn;
end;


var MyList : tMyList;

begin
     with MyList do begin
          Initialize;

          Store ('The object oriented approach');
          Store ('to data structures will make');
          Store ('life easier.');

          DoMyTask;
          Intercept;
     end;
end.
