{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; doubly linked structure sorting

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBDAT, EFLIBBAS;


const NumberOfElements = 500;

var Structure : LinkedListObjectType; Timer : TimerObjectType;
    Index, Number : word;


{ Add elements }
procedure Build;
begin
     if Structure.IsInitialized then
        for Index := 1 to NumberOfElements do begin
            Number := Succ(Random(High(Number)));
            Structure.Add (Number); { Add element }
        end;
end;

procedure TestCommonSorting;
begin
     with Structure do begin
          { Make sure that the structure is empty }
          Clear;

          { Disable active sorting }
          SetUnsortedOrder;

          Write ('Common sorting : ');

          Timer.Initialize;

          { Build structure without sorting it }
          Build;

          { Sort structure with QuickSort algorithm }
          Sort (AscendingOrder, QuickSortAlgorithm);

          WriteLn (Timer.ElapsedMS:0:0, ' [ms]');

          Timer.Intercept;
     end;
end;


procedure TestActiveSorting;
begin
     with Structure do begin
          { Make sure that the structure is empty }
          Clear;

          { Setup active sorting }
          SetAscendingOrder; { Ascending sort order }
          SetSearchMethod (BinarySearchMethod); { Use fast binary search }

          Write ('Active sorting : ');

          Timer.Initialize;

          { Active sorting during insertion of new elements }
          Build;

          WriteLn (Timer.ElapsedMS:0:0, ' [ms]');

          Timer.Intercept;
     end;
end;


begin
     { EFLIB supplies two ways of sorting doubly linked data structures:

        1) common sorting algorithms after the structure is built,
        2) active sorting where each new element is placed in sorted order.

       The common sorting can be performed with various sorting algorithms
       as implemented in DataObjectType (the parent object for all EFLIB
       data types). Active sorting can use linear or binary search for
       the the attachment node. Binary searching has supirior performance. }

     RandSeed := 0; { Control random seed }

     WriteLn ('* Doubly linked structure sorting performance *');

     Structure.Initialize (SizeOf(Number));

       TestCommonSorting;
       TestActiveSorting;

     Structure.Intercept;
     if GlobalDataError then WriteLn ('Error(s) reported!');
end.