{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; encryption filter with file streams

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBIO;

const EncryptionBuffer = 4096;

var Source, Target : StreamObjectPointerType;

{ ParamStr(1) must contain the input file, ParamStr(2) the output
  file and ParamStr(3) your keyword string. }

begin
     { Initialize source stream }
     Source := New (FileStreamObjectPointerType,
                    Initialize (ParamStr(1), EncryptionBuffer));

     { Initialize target stream as a filtered stream based on the
       encryption filter with a file stream as secondary stream. }
     Target := New (EncryptFilterObjectPointerType,
                    Initialize (ParamStr(3), New (FileStreamObjectPointerType,
                                { Keyword }  { Base stream (will be intercepted) }
                    Initialize (ParamStr(2), EncryptionBuffer))));
                                { Filename } { Buffer size }

     { Demonstrate seeking inside an filtered, encrypted stream }
     Target^.Seek(Target^.Size div 2); Target^.Seek(0);

     { Transfer all data from source to the target (the target is
       the secondary stream inside the encryption filter. }
     Source^.MoveOut (Target, Source^.Size);

     Source^.Free; Target^.Free;
end.