{$M 8192,0,0}
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}

PROGRAM Join_Text_Lines;
USES DOS;
VAR
  SavedExitProc: POINTER;  { CustomExit proc inserted into normal exit. }
  InFile, OutFile : TEXT;
  Width : INTEGER;

PROCEDURE NewLine; FORWARD;
PROCEDURE WriteStr (CONST s: STRING); FORWARD;
FUNCTION WordToHex (i: WORD): EXTSTR; FORWARD;

PROCEDURE CustomExit; FAR; {---- Always exit through here ----}
CONST
  NL = #13#10;
VAR
  message: STRING [79];
BEGIN
  ExitProc := SavedExitProc;
  IF (ExitCode > 0) THEN BEGIN
    NewLine;
    WriteStr ('Make1 v1.10 - Free DOS utility:  PCBoard file list line joiner.');
    WriteStr ('April 10, 1996. Copyright (c) 1996 by David Daniel Anderson - Reign Ware.'+NL);
    WriteStr ('Usage     :  Make1  <infile>  <outfile>  [max line width: 1-255]'+NL);
    WriteStr ('Examples  :  Make1  allfiles.lst  allfiles.one');
    WriteStr ('          :  Make1  oldfile  newfile  79'+NL);
  END;
  IF ErrorAddr <> NIL THEN
  BEGIN
    WriteStr ('An unanticipated error occurred, please contact DDA with the following data:');
    WriteLn ('Address = ', WordToHex (Seg (ErrorAddr^)), ':', WordToHex (Ofs (ErrorAddr^)));
    WriteLn ('Code    = ', ExitCode);
    ErrorAddr := NIL;
  END
  ELSE
    IF (ExitCode IN [1..254]) THEN BEGIN
      CASE ExitCode OF
        7 : message := 'File handling error.  Make sure you specified "infile" and "outfile" properly.';
        ELSE  message := 'Unknown error.';
      END;
      WriteLn ('Error encountered (#', ExitCode, '):'); WriteStr (message);
    END;
END;

PROCEDURE CheckIO; { Check IOResult, exit on error. }
BEGIN
  IF IOResult <> 0 THEN Halt (7);
END;

PROCEDURE NewLine;
BEGIN
  WriteLn;
END;

PROCEDURE WriteStr (CONST s: STRING);
BEGIN
  WriteLn (s);
END;

FUNCTION WordToHex (i: WORD): EXTSTR; {Convert a WORD variable to STRING[4]}
CONST
  HexLetters : ARRAY [0..15] OF CHAR = '0123456789ABCDEF';
BEGIN
  WordToHex := Concat (HexLetters [Hi (i) SHR 4], HexLetters [Hi (i) AND 15],
                       HexLetters [Lo (i) SHR 4], HexLetters [Lo (i) AND 15]);
END;

FUNCTION RTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [Length (InStr)] IN [#0, #9, #32]) DO
    Dec (InStr [0]);
  RTrim := InStr;
END;

FUNCTION LTrim (InStr: STRING): STRING; {Note, this is *not* a generic LTrim!}
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [1] IN [#0, #9, #32, #124]) DO
    Delete (InStr, 1, 1);
  LTrim := InStr;
END;

PROCEDURE AnalyzeCommandLine;
VAR
  vErr: Integer;
BEGIN
  IF ParamCount < 2 THEN Halt (255);

  Assign (InFile, ParamStr (1));
  Reset (InFile); CheckIO;

  Assign (OutFile, ParamStr (2));
  Rewrite (OutFile); CheckIO;

  Write ('Converting ' + ParamStr (1) + ' to ' + ParamStr (2));

  IF ParamStr (3) <> '' THEN
  BEGIN
    Val (ParamStr (3), Width, vErr);
    IF (vErr <> 0) OR (NOT (Width in [1..255])) THEN Width := 255;
  END;
END;

VAR
  HoldLine,
  TempLine: STRING;
  Next,
  Joined: BOOLEAN;

BEGIN
  SavedExitProc := ExitProc;
  ExitProc := @CustomExit;  { Insert custom exit procedure. }

  AnalyzeCommandLine;

  HoldLine := '';
  TempLine := '';
  Joined := FALSE;

  WHILE NOT EoF (InFile) DO
  BEGIN
    Next := FALSE;
    IF (HoldLine = '') THEN  {Advance to first line of file.}
    BEGIN
      ReadLn (InFile, HoldLine);
      HoldLine := RTrim (HoldLine);
      IF (HoldLine <> '') AND (HoldLine[1] = #32) THEN
        Next := TRUE;
    END;

    WHILE (NOT Eof (InFile)) AND (NOT Next) DO
    BEGIN
      ReadLn (InFile, TempLine);
      Joined := FALSE;

      IF (TempLine <> '') AND (TempLine[1] <> #32) THEN
        Next := TRUE
      ELSE
      BEGIN
        TempLine := LTrim (RTrim (TempLine));
        HoldLine := HoldLine + ' ' + TempLine;
        Joined := TRUE;
      END;
    END;

    IF (HoldLine <> '') THEN
    BEGIN
      WriteLn (OutFile, Copy (HoldLine, 1, Width));
      IF Joined
        THEN HoldLine := ''
        ELSE HoldLine := TempLine;
    END;
  END;

  IF NOT Joined THEN
    WriteLn (OutFile, Copy (HoldLine, 1, Width)); {Write last line read.}

  Close (InFile);
  Close (OutFile);
  WriteStr (', done!');
END.
