{$M 5120,0,655360}
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}
{$DEFINE MLDROP}

USES DOS;
{$I ML_INC.PAS}

VAR
  Total : WORD;
  NameList : ListLink;
  ParamIndex : BYTE;
  WorkFile : STRING;

  ListPath  : PATHSTR;    { List file path. }
  ListDir   : DIRSTR;     { List file dir.  }
  FileInfo : SEARCHREC;

BEGIN
  IF ParamCount < 2 THEN ExitOnError (1, 'Insufficient number of parameters.');
  NameList := NIL;
  Total := 0;

  IF NOT IsFile (ParamStr (1))
    THEN ExitOnError (3, 'The "MasterList" file was not found.');

  AddToList (NameList, ParamStr (1), Total);
  EditList (NameList, Total);
  WriteLn ('Starting with ', Total, ' unique members.');

  FOR ParamIndex := 2 to ParamCount DO
  BEGIN
    ListPath := GetFilePath (ParamStr (ParamIndex), ListDir);
    FindFirst (ListPath, Archive, FileInfo);

    WHILE DosError = 0 DO
    BEGIN
      DropFromList (NameList, ListDir + FileInfo.Name, Total);
      WriteLn ('Total members now: ', Total);
      FindNext (FileInfo);
    END;
  END;

  EditList (NameList, Total);
  WriteLn ('Unique members: ', Total);

  WriteList (NameList, ParamStr (1), Total);
  WriteLn ('Finished consolidating lists.');
END.
