unit Sfwu;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, BigText, Menus,
  StdCtrls, ShellAPI, gotow, about, IniFiles;

type
  TFsfw = class(TForm)
    BigText1: TBigText;
    Panel1: TPanel;
    OpenDialog1: TOpenDialog;
    FontDialog1: TFontDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    FindDialog1: TFindDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    N1: TMenuItem;
    Print1: TMenuItem;
    SetupPrinter1: TMenuItem;
    Font1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    Search1: TMenuItem;
    Goto1: TMenuItem;
    Find1: TMenuItem;
    Help1: TMenuItem;
    Contents1: TMenuItem;
    N3: TMenuItem;
    About1: TMenuItem;
    Clear1: TMenuItem;
    Timer1: TTimer;
    N8PointFont1: TMenuItem;
    procedure FormActivate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure Find1Click(Sender: TObject);
    procedure Clear1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure SetupPrinter1Click(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure Goto1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure N8PointFont1Click(Sender: TObject);
  private
    { Private declarations }
    function  MenuOn: Bool;
    function  MenuOff: Bool;
    function  OpenFile(var filetoopen: string): bool;
    procedure WMDropFiles(var msg : TMessage); message WM_DROPFILES;
    function  OpenInFile(szFile : String) : Bool;
  public
    { Public declarations }
  end;

var
  Fsfw: TFsfw;
  PgmTitle: String;
  ANSILoad: Bool;
  ANSIOn  : Bool;

implementation

{$R *.DFM}

procedure TFsfw.FormActivate(Sender: TObject);
var
 Ini    : TIniFile;
 szFile : String;
begin
   if ParamCount > 0 then
      begin
         if ParamCount > 1 then
               begin
                 if UpperCase(ParamStr(1)) = '-A' then
                    begin
                     ANSILoad := True;
                     ANSIOn   := True;
                     OpenInFile(ParamStr(2));
                   end;
               end
          else
                  OpenInFile(ParamStr(1));
      end
   else
     begin
        Ini  := TIniFile.Create('sfw.ini');
        with Ini do
          begin
            szFile :=ReadString('File', 'SFW', '');
          end;
        Ini.Free;
        if Length(szFile) > 0 then
            OpenInFile(szFile);
     end;
end;

procedure TFsfw.Exit1Click(Sender: TObject);
begin
     Application.Terminate;
end;

procedure TFsfw.Open1Click(Sender: TObject);
var
  fname : string;
  fextn : string;
begin
     ANSILoad := False;
     if ANSIOn then
        OpenDialog1.FilterIndex := 2
     else
        OpenDialog1.FilterIndex := 1;

     if OpenDialog1.Execute then
       begin
          fextn := ExtractFileExt(OpenDialog1.FileName);
          if Length(Fextn) = 0 then
             ANSIOn := True
          else
             ANSIOn := False;
          if ANSIOn then
             ANSILoad := True;
          fname := OpenDialog1.FileName;
          OpenFile(fname);
       end;
end;


procedure TFsfw.FormDestroy(Sender: TObject);
begin
     DragAcceptFiles(Handle, False);
end;

procedure TFsfw.Find1Click(Sender: TObject);
begin
     FindDialog1.Execute;
end;

{<<<<<<<<<<<<<<<<<<<<<<<<<<< >>>>>>>>>>>>>>>>>>>>>>>>>}


{
Turn the menu on.
}
function TFsfw.MenuOn: Bool;
begin
     Panel1.Caption        := 'Ready';
     clear1.enabled        := True;
     Open1.enabled         := True;
     SetupPrinter1.enabled := True;
     Print1.enabled        := True;
     Font1.enabled         := True;
     Exit1.enabled         := True;
     Find1.enabled         := True;
     Goto1.enabled         := True;
     Contents1.enabled     := True;
     About1.enabled        := True;

end;
{
Turn the menu off
}
function TFsfw.MenuOff: Bool;
begin
{     file1.enabled := False;
     search1.enabled := False;
     help1.enabled := False; }
     clear1.enabled        := False;
     Open1.enabled         := False;
     SetupPrinter1.enabled := False;
     Print1.enabled        := False;
     Font1.enabled         := False;
     Exit1.enabled         := False;
     Find1.enabled         := False;
     Goto1.enabled         := False;
     Contents1.enabled     := False;
     About1.enabled        := False;


end;
{
A normal file load from the Menu.
}
function TFsfw.OpenFile(var filetoopen: string): Bool;
begin
    Cursor         := crHourGlass;
    Panel1.Caption := 'Loading: ' + filetoopen;
    Application.ProcessMessages;
    MenuOff;
    if ANSILoad then
        BigText1.LoadFromFileANSI(filetoopen)
    else
        BigText1.LoadFromFile(filetoopen);
    MenuOn;
    Cursor := crDefault;
    ANSILoad := False;
    Fsfw.Caption := PgmTitle + filetoopen;
end;

{
Function OpenInFile - String - File to open.
         Returns    - Always true.
Opens the given file in szFile, if the file does not exist it errors and
terminates the application.  This is for command line type arguments and
.INI file type arguments.  The desired behavior was to quit the application
in either case when the file was not found.
}
function TFsfw.OpenInFile(szFile : String) : Bool;
begin
    Result:= True;
    if FileExists(szFile) then
       begin
          Cursor := crHourGlass;
          Panel1.Caption := 'Loading: ' + szFile + ' One Moment...';
          Application.ProcessMessages;
          MenuOff;
          if ANSILoad then
             BigText1.LoadFromFileANSI(szFile)
          else
             BigText1.LoadFromFile(szFile);
          Panel1.Caption := 'Lines ' + Inttostr(Bigtext1.Count);
          MenuOn;
          Cursor := crDefault;
          fsfw.Caption := PgmTitle + szFile;
          ANSILoad := False;
       end
   else
       begin
          MessageDlg('File Error ' +
                    szFile + CHR(13) + ' is Missing!' +
                    CHR(13)+ 'Application Terminating',
                    mtError, [mbOK], 0);
          Application.Terminate;
       end;
end;
{
Accept Files from the File Manager
Originally seen as part of Delphi & Filemngr Drag Drop
           (keeper@mindsprint.com(Mark R. Johnson)
           Thanks for his work.
}
procedure TFsfw.WMDropFiles(var msg : TMessage);
var
  i, n : word;
  size : word;
  fname : string;
  hdrop : word;
begin
     hdrop := msg.WParam;
     n := DragQueryFile(hdrop, $ffff, nil, 0);
     for i:= 0 to (n - 1) do begin
         size:= DragQueryFile(hdrop, i, nil, 0);
         if size < 255 then begin
            fname[0] := Chr(size);
            DragQueryFile(hdrop, i, @fname[1], size + 1);
         end;
     end;
     if Length(fname) > 0 then {Open only the last file }
        OpenFile(fname);
end;

{
This procedure is used to find text in the input file.  It uses the search
function of BigText.  When text is not found, it simply tells the user
that it was not, otherwise, the BigText area is scrolled to the correct
location and the user sees a blue line which has the text they were
searching for.
}
procedure TFsfw.FindDialog1Find(Sender: TObject);
var
   ToFind  : string;
   SrchDown: Bool;
   MCase   : Bool;
begin
     ToFind := FindDialog1.FindText;
     { Is search Down Checked - Default? }
     if (FindDialog1.Options*[frDown])=[frDown] then
        SrchDown := True
     else
        SrchDown := False;
     { Is MatchCase Checked - Default Yes }
     if (FindDialog1.Options*[frMatchCase])=[frMatchCase] then
        MCase := True
     else
        MCase := False;

     if BigText1.Search(ToFind, SrchDown, MCase) then
        begin
             ToFind := '';
        end
     else
         begin
              messagedlg('Text not found', mtInformation, [mbOK], 0);
         end; 
end;



procedure TFsfw.Clear1Click(Sender: TObject);
begin
     fsfw.Caption := PgmTitle;
     BigText1.Clear;

end;

procedure TFsfw.FormCreate(Sender: TObject);
begin
    if ParamCount > 0 then
       WindowState := wsMaximized;
     Fsfw.Paint;
     application.processmessages;
     DragAcceptFiles(Handle, true);
end;

procedure TFsfw.Print1Click(Sender: TObject);
begin
     MenuOff;
     Cursor := crHourGlass;
     Panel1.Caption := 'Printing - One Moment...';
     BigText1.Print;
     MenuOn;
     Cursor := crDefault;
end;

procedure TFsfw.SetupPrinter1Click(Sender: TObject);
begin
     PrinterSetupDialog1.Execute;
end;

procedure TFsfw.Font1Click(Sender: TObject);
begin
     if FontDialog1.Execute then
        begin
           BigText1.Font := FontDialog1.Font;
           BigText1.Invalidate;
        end;
end;

procedure TFsfw.Goto1Click(Sender: TObject);
var
  newpos : longint;
begin
     Gotowin.ShowModal;
     if Gotowin.gw_ok = true then
     begin
       if Length(gotowin.MaskEdit1.Text) > 0 then
         begin
          newpos := strtoint(gotowin.MaskEdit1.Text);
          if newpos <> 0 then
            begin
              newpos := newpos - 1;
              BigText1.ScrollTo(0, newpos);
            end;
         end;
     end;
end;

procedure TFsfw.About1Click(Sender: TObject);
begin
     AboutBox.ShowModal;
end;

procedure TFsfw.Contents1Click(Sender: TObject);
begin
  Application.HelpFile := 'SFW.HLP';
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TFsfw.Timer1Timer(Sender: TObject);
begin
     Panel1.Caption := 'Lines ' + Inttostr(Bigtext1.Count) +
                   ' Cur '  + IntToStr(BigText1.CurPos + 1);
end;

procedure TFsfw.N8PointFont1Click(Sender: TObject);
begin
{     BigText1.Font.Name         := 'Courier New';}
     if N8PointFont1.Caption = 'Font Size Up' then
        begin
           BigText1.Font.Size   := 8;
           N8PointFont1.Caption := 'Font Size Down';
           N8PointFont1.ShortCut:= TextToShortCut('Ctrl+D');
        end
     else
        begin
           BigText1.Font.Size   := 7;
           N8PointFont1.Caption := 'Font Size Up';
           N8PointFont1.ShortCut:= TextToShortCut('Ctrl+U');
        end;
      BigText1.Invalidate;
end;

initialization
   PgmTitle := 'Show File Windows ';
   ANSILoad := False;

end.
