{SRWADDME.PAS - Adding Shazam Report Wizard to existing projects}
{Copyright (c) 1995 ShazamWare Solutions, Inc.}

{--See SRWDEV.WRI for complete instructions on how to use this file.}
{--From Delphi, select File|Open File to open this file.}
{--Deviating from these instructions may result in unpredictable results.}
{--Only add the INDENTED lines, not the comments that start with STEP #.}

{STEP 2------------------------------------------------------------------------}
{Append the following lines to the uses statement of the project's DPR file.}
{Make sure you replace the semi-colon in your existing project with a comma}
{before appending this text.}

  SrwMain  IN 'SRWMAIN.PAS'  {frmSrwMain},
  SrwEdit  IN 'SRWEDIT.PAS'  {frmSrwEdit},
  SrwTable IN 'SRWTABLE.PAS' {frmSrwTable},
  SrwCode  IN 'SRWCODE.PAS',
  SrwFile  IN 'SRWFILE.PAS',
  SrwFormt IN 'SRWFORMT.PAS' {frmSrwFormat},
  SrwAbout IN 'SRWABOUT.PAS' {frmSrwAbout};


{STEP 3------------------------------------------------------------------------}
{Add the following lines after the BEGIN section of the project's DPR file, and}
{before any Application.CreateForm methods.  These are global SRW form object}
{variables that must be set to NIL for Shazam to load properly.  DO NOT TRY
{EXPLICTY LOADING SRW FORMS HERE AS THAT IS MANAGED AUTOMATICALLY.}

  {form object variables for shazam report wizard}
  frmSrwMain   := NIL;
  frmSrwAbout  := NIL;
  frmSrwTable  := NIL;
  frmSrwEdit   := NIL;
  frmSrwFormat := NIL;


{STEP 4------------------------------------------------------------------------}
{Open the form that Shazam Report Wizard will be launched from, move to the} 
{IMPLEMENTATION section of the form's Pascal file, and add the following to the USES}
{statement (remember to replace the existing semi-colon with a comma if you have already} 
{declared other forms and units):}

     SrwMain, SrwCode;



{STEP 5------------------------------------------------------------------------}
{Within your project, create a menu item or toolbar button titled Reports and}
{add the following line to its click event.  See SRWDEV.WRI for additional
{information.}

  {create main shazam report wizard form}
  IF frmSrwMain = NIL THEN BEGIN
     srwIsChild := False; {or True for mdi applications}
     srwParentForm := NIL; {or project's parent form name}
     Application.CreateForm(TfrmSrwMain, frmSrwMain);
  END;

  {customize shazam}


  {display shazam}
  frmSrwMain.Show;
  frmSrwMain.BringToFront;


{STEP 6------------------------------------------------------------------------}
{If you assigned srwParentForm := FormName, this will activate an Exit menu
{item on Shazam's File menu.  It executes the srwParentForm.Close method, which
{will immediately close your application unless your intercept this with
{something like the following code in your parent form's OnCloseQuery event.}

  {confirm with user that they actually want to exit}
  IF MessageDlg('Exit the SRW Demonstration Program?',
         mtConfirmation, [mbYes, mbNo], 1) = mrNo THEN BEGIN
     CanClose := False; {cancel the close event}
     Exit;
  END;

  {close application properly here, freeing resources, etc.}



