Option Explicit


'   this module contains interface parameters to both logicaip and winsock
'   and three sample routines to interface to logicaip


' Interface to LOGICAIP module */

Global Const FD_SETSIZE = 64
Global Const WSADESCRIPTION_LEN = 256
Global Const WSASYS_STATUS_LEN = 128
Global Const MAXSENDLEN = 32767
Global Const MAXCOMMLINE = 1536
Global Const MAXOUTLINE = 255
Global Const MAXFINDSTRING = 80
Global Const COMMBUFSIZE = 1600
Global Const ERROR_BUFFER_SIZE = 1024
Global Const INIT_NOT_CONNECTED = 5
Global Const IDM_DISCONNECT = 144


'   errors returned by logicaip.dll (internal errors)
Global Const ERR_CANT_MALLOC = 4001
Global Const ERR_SENDING_DATA = 4002
Global Const ERR_INITIALIZING = 4003
Global Const ERR_VER_NOT_SUPPORTED = 4004
Global Const ERR_EINVAL = 4005
Global Const ERR_SYS_NOT_READY = 4006
Global Const ERR_CANT_RESOLVE_HOSTNAME = 4007
Global Const ERR_CANT_GET_SOCKET = 4008
Global Const ERR_READING_SOCKET = 4009
Global Const ERR_NOT_A_SOCKET = 4010
Global Const ERR_BUSY = 4011
Global Const ERR_CLOSING = 4012
Global Const WAIT_A_BIT = 4013
Global Const ERR_CANT_RESOLVE_SERVICE = 4014
Global Const ERR_CANT_CONNECT = 4015
Global Const ERR_NOT_CONNECTED = 4016
Global Const ERR_CONNECTION_REFUSED = 4017

Global Const ST_ESTABLISH_COMM = 1
Global Const HINSTANCE_ERROR = 32
Global Const WM_COMMAND = &H111
Global Const CommBuffIdx = COMMBUFSIZE + 1
Global Const SOCK_STREAM = 1
Global Const SOCK_DGRAM = 2    '    datagram socket */
Global Const AF_INET = 2
Global Const SOL_SOCKET = &HFFFF      '          /* options for socket level */
Global Const SO_DEBUG = &H1      '          /* turn on debugging info recording */
Global Const SO_ACCEPTCONN = &H2     '          /* socket has had listen() */
Global Const SO_REUSEADDR = &H4       '         /* allow local address reuse */
Global Const SO_KEEPALIVE = &H8       '         /* keep connections alive */
Global Const SO_DONTROUTE = &H10      '         /* just use interface addresses */
Global Const SO_BROADCAST = &H20      ''         /* permit sending of broadcast msgs */
Global Const SO_USELOOPBACK = &H40    '         /* bypass hardware when possible */
Global Const SO_LINGER = &H80         '         /* linger on close if data present */
Global Const SO_OOBINLINE = &H100     '         /* leave received OOB data in line */
Global Const SO_DONTLINGER = SO_LINGER'
Global Const IPPROTO_IP = 0    '              /* dummy for IP */


' WINSOCK errors trapped  by LOGICAIP
' The error message descriptions show the corresponding Winsock
' error number. The corresponding Visual Basic error code can
' be obtained by adding 15001 to the number displayed in the
' message and vice-versa.

Global Const IPP_Wsaeintr = 10004'          [10004] Interrupted system call.
Global Const IPP_BadFileNum = 10009'        [10009] Bad file number.
Global Const IPP_WSAEACCES = 10013'         [10013] Permission denied.
Global Const IPP_WSAEFAULT = 10014'         [10014] Bad address.
Global Const IPP_WSAEINVAL = 10022'         [10022] Invalid argument.
Global Const IPP_WSAEMFILE = 10024'         [10024] Too many open files.
Global Const IPP_WSAEWOULDBLOCK = 10035'    [10035] Operation would block.
Global Const IPP_WSAEINPROGRESS = 10036'    [10036] Operation now in progress.
Global Const IPP_WSAEALREADY = 10037'       [10037] Operation already in progress.
Global Const IPP_WSAENOTSOCK = 10038'       [10038] Socket operation on non-socket.
Global Const IPP_WSAEDESTADDRREQ = 10039'   [10039] Destination address required.
Global Const IPP_WSAEMSGSIZE = 10040'       [10040] Message too long.
Global Const IPP_WSAEPROTOTYPE = 10041'     [10041] Protocol wrong type for socket.
Global Const IPP_WSAENOPROTOOPT = 10042'    [10042] Bad protocol option.
Global Const IPP_WSAEPROTONOSUPPORT = 10043'[10043] Protocol not supported.
Global Const IPP_WSAESOCKTNOSUPPORT = 10044'[10044] Socket type not supported.
Global Const IPP_WSAEOPNOTSUPP = 10045'     [10045] Operation not supported on socket.
Global Const IPP_WSAEPFNOSUPPORT = 10046'   [10046] Protocol family not supported.
Global Const IPP_WSAEAFNOSUPPORT = 10047'   [10047] Address family not supported by protocol family.
Global Const IPP_WSAEADDRINUSE = 10048'     [10048] Address already in use.
Global Const IPP_WSAEADDRNOTAVAIL = 10049'  [10049] Can' t assign requested address.
Global Const IPP_WSAENETDOWN = 10050'       [10050] Network is down.
Global Const IPP_WSAENETUNREACH = 10051'    [10051] Network is unreachable.
Global Const IPP_WSAENETRESET = 10052'      [10052] Net dropped connection or reset.
Global Const IPP_WSAECONNABORTED = 10053'   [10053] Software caused connection abort.
Global Const IPP_WSAECONNRESET = 10054'     [10054] Connection reset by peer.
Global Const IPP_WSAENOBUFS = 10055'        [10055] No buffer space available.
Global Const IPP_WSAEISCONN = 10056'        [10056] Socket is already connected.
Global Const IPP_WSAENOTCONN = 10057'       [10057] Socket is not connected.
Global Const IPP_WSAESHUTDOWN = 10058'      [10058] Can' t send after socket shutdown.
Global Const IPP_WSAETOOMANYREFS = 10059'   [10059] Too many references, can' t splice.
Global Const IPP_WSAETIMEDOUT = 10060'      [10060] Connection timed out.
Global Const IPP_WSAECONNREFUSED = 10061'   [10061] Connection refused.
Global Const IPP_WSAELOOP = 10062'          [10062] Too many levels of symbolic links.
Global Const IPP_WSAENAMETOOLONG = 10063'   [10063] File name too long.
Global Const IPP_WSAEHOSTDOWN = 10064'      [10064] Host is down.
Global Const IPP_WSAEHOSTUNREACH = 10065'   [10065] No Route to Host.
Global Const IPP_WSAENOTEMPTY = 10066'      [10066] Directory not empty.
Global Const IPP_WSAEPROCLIM = 10067'       [10067] Too many processes.
Global Const IPP_WSAEUSERS = 10068'         [10068] Too many users.
Global Const IPP_WSAEDQUOT = 10069'         [10069] Disc Quota Exceeded.
Global Const IPP_WSAESTALE = 10070'         [10070] Stale NFS file handle.
Global Const IPP_WSAEREMOTE = 10071'        [10071] Too many levels of remote in path.
Global Const IPP_WSASYSNOTREADY = 10091'    [10091] Network SubSystem is unavailable.
Global Const IPP_WSAVERNOTSUPPORTED = 10092'[10092] WINSOCK DLL Version out of range.
Global Const IPP_WSANOTINITIALISED = 10093' [10093] Successful WSASTARTUP not yet performed.
Global Const IPP_WSAHOST_NOT_FOUND = 11001' [11001] Host not found.
Global Const IPP_WSATRY_AGAIN = 11002'      [11002] Non-Authoritative Host not found (try again).
Global Const IPP_WSANO_RECOVERY = 11003'    [11003] Non-Recoverable error.
Global Const IPP_WSANO_DATA = 11004'        [11004] Valid name, no data record for requested name.
Global Const i_NNTPComm = 12000

'   set default to the mostly supported socket version
Const SocketVersion = &H101

Type fd_set_type
  
  fd_count As Integer
  fd_array(FD_SETSIZE) As Integer

End Type

Type timeval
  
  tv_sec As Long
  tv_usec As Long

End Type

Type sockaddr_in
  
  sin_family As Integer
  sin_port As Long
  sin_addr As Long
  sin_zero(7) As String * 1

End Type

Type in_addr
 
 temp As Long

End Type

Type sockaddr
  
  sa_family As Integer
  sa_data(14) As Variant

End Type

Type WSAdata_type
   
   wVersion As Integer
   wHighVersion As Integer
   szDescription As String * 257
   szSystemStatus As String * 129
   iMaxSockets As Integer
   iMaxUdpDg As Integer
   lpVendorInfo As String * 200

End Type

Type sockproto
  
  sp_family As Integer
  sp_protocol As Integer

End Type

Type linger
  
  l_onoff As Integer
  l_linger As Integer

End Type

Type hostent
	
	h_name As String
	h_aliases(20) As String
	h_addrtype As Integer
	h_length As Integer
	h_addr_list(20) As String

End Type

Type servent
	s_name As String
	s_aliases(20) As String
	s_port As Integer
	s_proto As String

End Type

'   funtion declarations for winsock.dll
Declare Function bind Lib "winsock.dll" (ByVal s As Integer, Addr As sockaddr, ByVal namelen As Integer) As Integer
Declare Function htonl Lib "winsock.dll" (ByVal A As Long) As Long
Declare Function inet_addr Lib "winsock.dll" (ByVal s As String) As Long
Declare Function inet_ntoa Lib "winsock.dll" (ByVal in As Long) As Long
Declare Function ntohl Lib "winsock.dll" (ByVal A As Long) As Long
Declare Function Socket Lib "winsock.dll" (ByVal af As Integer, ByVal typesock As Integer, ByVal protocol As Integer) As Integer
Declare Function htons Lib "winsock.dll" (ByVal A As Integer) As Integer
Declare Function ntohs Lib "winsock.dll" (ByVal A As Integer) As Integer
Declare Function HConnect Lib "winsock.dll" Alias "Connect" (ByVal sock As Integer, Addr As sockaddr, ByVal structlen As Integer) As Integer
Declare Function Send Lib "winsock.dll" (ByVal sock As Integer, ByVal Msg As String, ByVal MsgLen As Integer, ByVal flag As Integer) As Integer
Declare Function Recv Lib "winsock.dll" (ByVal sock As Integer, ByVal Msg As String, ByVal MsgLen As Integer, ByVal flag As Integer) As Integer
Declare Function FD_ISSET Lib "winsock.dll" Alias "__WSAFDIsSet" (ByVal s As Integer, passed_set As fd_set_type) As Integer
Declare Function WSAStartup Lib "winsock.dll" (ByVal A As Integer, b As WSAdata_type) As Integer
Declare Function WsaCleanup Lib "winsock.dll" () As Integer
Declare Function CloseSocket Lib "winsock.dll" (ByVal sock As Integer) As Integer
Declare Function SetSockOpt Lib "winsock.dll" (ByVal sock As Integer, ByVal level As Integer, ByVal OptName As Integer, ByVal SockName As String, ByVal SockLen As Integer) As Integer
Declare Function WsaAsyncSelect Lib "winsock.dll" (ByVal sock As Integer, ByVal hWnd As Integer, ByVal wmsg As Integer, ByVal lEvent As Long) As Integer
Declare Function Accept Lib "winsock.dll" (ByVal sock As Integer, ByVal Buf As String, ByVal buflen As Integer) As Integer
Declare Function WsaGetLastError Lib "winsock.dll" () As Integer
Declare Function WsaCancelBlockingCall Lib "winsock.dll" () As Integer
Declare Function GetHostByName Lib "winsock.dll" (ByVal HostName As String) As Integer
Declare Function WsaAsyncGetHostByName Lib "winsock.dll" (ByVal hWnd As Integer, ByVal wmsg As Integer, ByVal TheName As String, servent As servent, ByVal buflen As Integer) As Integer
Declare Function WSAAsyncGetServByName Lib "winsock.dll" (ByVal hWnd As Integer, ByVal wmsg As Any, ByVal TheName As String, ByVal Proto As String, ByVal Buf As String, ByVal buflen As Integer) As Integer
Declare Function GetHostName Lib "winsock.dll" (ByVal TheName As String, ByVal buflen As Integer) As Integer
Declare Function GetServByName Lib "winsock.dll" (ByVal TheName As String, ByVal Proto As String) As Integer
Declare Function ioctlsocket Lib "Winsock.dll" (ByVal s As Integer, ByVal Cmd As Long, ByVal argp As Integer) As Integer
Declare Function getservbyport Lib "Winsock.dll" (Port As Any, Proto As Any) As Integer
Declare Function shutdown Lib "Winsock.dll" (ByVal s As Integer, ByVal how As Integer) As Integer
Declare Function WsaIsBlocking Lib "Winsock.dll" () As Integer

Declare Sub FreeLibrary Lib "Kernel" (ByVal hLibModule As Integer)
Declare Function GetProcAddress Lib "Kernel" (ByVal hInst As Integer, ByVal lszProcName As String) As Integer
Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wmsg As Integer, ByVal wParam As Integer, lParam As Any) As Long
Declare Function GetCurrentTask Lib "Kernel" () As Integer
Declare Function lstrcpy Lib "Kernel" (ByVal lpString1 As Any, ByVal lpString2 As Any) As Long


'   these are function declarations for logicaip


'   this one connects asked service to the passed port number
Declare Function LG_VBconnect Lib "LOGICAIP.dll" (ByVal HostName As String, ByVal service As String) As Integer

'   ask for name of the host provided an internet name
Declare Function LG_gethostname Lib "LOGICAIP.dll" (ByVal HostName As String, ByVal namelen As Integer) As Integer

'   returns if socket can be read for data
Declare Function LG_get_buffer Lib "LOGICAIP.dll" (ByVal TimeOut As Long, ByVal the_socket As Integer) As Integer

'   returns if socket can be written
Declare Function LG_write_buffer Lib "LOGICAIP.dll" (ByVal TimeOut As Long, ByVal the_socket As Integer) As Integer

'   locks or unlocks socket
Declare Sub LG_ioctlcommand Lib "LOGICAIP.dll" (ByVal Wait As Integer, ByVal the_socket As Integer)

'   returns how many bytes are waiting. Call it after LG_Get_buffer
Declare Function LG_peekfordata Lib "LOGICAIP.dll" (ByVal the_socket As Integer, ByVal HowManyBytes As Long) As Long

Dim ActiveSockets() As Integer

Dim Started As Integer

'   we store values that mean error here
Dim FirstError As Integer

'   we store maxsockets and maxmessagesize here
Dim b  As WSAdata_type

'   this is to shut down connection on related socket
Sub CloseActualSocket (TheSocket)

On Local Error Resume Next

	Dim Action As Integer
	Action = shutdown(TheSocket, 2)
	If Action <> Zero Then Action = WsaGetLastError()
	
	If Action = IPP_WSAEINPROGRESS Then

	    Action = WsaCancelBlockingCall()
	    Action = shutdown(TheSocket, 2)

	End If
	
	Action = CloseSocket(TheSocket)
	If Action <> Zero Then Action = WsaGetLastError()
	
	If Action = IPP_WSAEINPROGRESS Then

	    Action = WsaCancelBlockingCall()
	    Action = CloseSocket(TheSocket)

	End If

	'   needed to know if socket was killed. See closesockets
	Dim Cnt As Integer
	For Cnt = 1 To UBound(ActiveSockets)
	
	    If ActiveSockets(Cnt) = TheSocket Then

		ActiveSockets(Cnt) = Zero
	    
	    End If

	Next Cnt

End Sub

'   closes all open sockets loaded into the array
Sub CloseTheSockets ()

On Local Error Resume Next



    Dim Cnt As Integer
    For Cnt = 0 To UBound(ActiveSockets)
    
	If ActiveSockets(Cnt) > Zero Then
	
	    Dim Action As Integer
	    CloseActualSocket ActiveSockets(Cnt)

	End If

    Next Cnt

    Action = WsaCleanup()

End Sub

'   returns an error message
Function ConnErrMessage (ConnectError As Integer) As String

On Local Error Resume Next


Dim Mesg As String
Select Case ConnectError
		
		    
    
    Case ERR_CANT_MALLOC, ERR_SENDING_DATA, ERR_INITIALIZING, ERR_VER_NOT_SUPPORTED

    Case ERR_EINVAL, ERR_SYS_NOT_READY, ERR_CANT_GET_SOCKET, ERR_READING_SOCKET

    Case ERR_NOT_A_SOCKET, ERR_CLOSING, ERR_NOT_CONNECTED
	

    Case WAIT_A_BIT
    
	Mesg = s_Wait_A_Bit
    
    Case i_ServerTimedOut
    
	Mesg = s_ServerTimedOut
	
    Case IPP_WSAEINPROGRESS
    
	Mesg = s_PreviousInProgress
	Dim Action As Integer
	Action = WsaCancelBlockingCall()

    Case ERR_BUSY
	
	Mesg = s_Err_Busy
	
    Case ERR_CANT_RESOLVE_SERVICE, ERR_CANT_RESOLVE_HOSTNAME
	
	Mesg = s_ERR_CANT_RESOLVE_SERVICE
	
    Case IPP_WSAETIMEDOUT                   '      [10060] Connection timed out.
	
	Mesg = s_IPP_WSAETIMEDOUT
	
    Case IPP_WSAECONNREFUSED                '   [10061] Connection refused.
	
	Mesg = s_IPP_WSAECONNREFUSED
	
    Case IPP_WSAEHOSTDOWN, IPP_WSAENETDOWN, IPP_WSAENETUNREACH                  '   [10064] Host is down.
    
	Mesg = s_IPP_WSAEHOSTDOWN
	
    Case IPP_WSAEHOSTUNREACH                '   [10065] No Route to Host.
    
	Mesg = s_IPP_WSAEHOSTUNREACH
	
    Case IPP_WSAEPROCLIM, IPP_WSAEUSERS '       [10067] Too many users.
		    
	Mesg = s_IPP_WSAEUSERS
	
    Case ERR_CONNECTION_REFUSED
    
	Mesg = s_IPP_ServerRefusesConnection
	
    Case Else

	Mesg = s_UnknownError
	
	       
End Select

    ConnErrMessage = Mesg

End Function

'   pass this function the name of the user to quit connection
'   from server.
'   Warning. This function doesn't close the socket. You must call
'   closeactualsocket
Function DoQuit (Socket As Integer, User As String) As Integer


    '   socket really opened?
    If Socket > Zero Then

	Dim Action As Integer, Cmd As String
	Cmd = "QUIT " & CrLf()
	Action = SendData(Cmd, Socket)
	ServerDialog Cmd

	If Len(User) Then
	
	    Stmsg s_DisconnectingServer & User, Void
	
	End If
	
	'   be sure server quits to set update status on on pop server
	Do While RecvData(10, "", Socket) = Zero
	
	    ProcessWinEvents
	    
	    If LastIpError(Zero, Socket) Then Exit Function

	Loop
	
    End If
    
    DoQuit = True

End Function

'   loops until socket returns data. Is up to you to be sure
'   that there is data waiting. Anyway there is a timer which exits the loop
'   if data take too long or there is no data and you are banging the
'   socket for nothing
Function GetMoreData (Socket As Integer) As String

    Dim RetVal As Integer
    Dim TheData As String
    Dim Start As Long
    Start = Timer

    Do While RetVal = Zero
    
	RetVal = RecvData(0, TheData, Socket)
	
	If UndoJob(Zero) Then Exit Do
	If LastIpError(Zero, Socket) Then Exit Do
	ProcessWinEvents
	If Timer > 500 + Start Then
	
	    RetVal = LastIpError(i_ServerTimedOut, Socket)
	    Exit Do

	End If

    Loop
    
    GetMoreData = TheData

End Function

Private Function InitializeComms () As Integer

    '   FreeLibrary GetModuleHandle("Logicaip.dll")

    '   must see how many sockets are available
    Dim RetVal As Integer
    RetVal = WSAStartup(ByVal SocketVersion, b)
    '   returns
    '   wVersion As Integer
    '   wHighVersion As Integer
    '   szDescription As String * 257
    '   szSystemStatus As String * 129
    '   iMaxSockets As Integer
    '   iMaxUdpDg As Integer
    '   lpVendorInfo As String * 200
    
    '   returns non zero if error
    If RetVal = IPP_WSAEINPROGRESS Then
    
	'   attempt unlocking the socket
	RetVal = WsaCancelBlockingCall()
	RetVal = WSAStartup(ByVal SocketVersion, b)
	If RetVal Then

	    '   if not success exit while complaining the error
	    Msg Zero, Msg_NoAction, ConnErrMessage(WsaGetLastError()), IdExclamation
	    Exit Function

	End If
	    
    End If

    Dim Success As Integer
    Success = WsaCleanup()
    
    '   return error if return value>available sockets
    '   (as dll returns the socket number)
    If RetVal = Zero Then
    
	
	FirstError = AddOne(b.iMaxSockets)
	'   MaxMessageSize = b.iMaxUdpDg
    
    Else

	Msg Zero, Msg_NoAction, ConnErrMessage(WsaGetLastError()), IdExclamation
	Exit Function

    End If

'   first connection
ReDim ActiveSockets(1)
Started = True
InitializeComms = True

End Function

'   this is the hearth connection to logicaip. Starts a new
'   connection provided a service name
'   and type of connection you want. Modify parameters to get
'   finger or www or any other type of connection
Function MRRInitComm (NNTPHost As String, CommType As Integer) As Integer

On Local Error Resume Next

If Not Started Then If Not InitializeComms() Then Exit Function

Stmsg s_Connecting, Void
    
Dim NNTPPort As String
If CommType = i_NNTPComm Then
    
    '   receive news
    NNTPPort = "119"
	
ElseIf CommType = i_PopServer Then
    
    '   receive mail
    NNTPPort = "110"

ElseIf CommType = i_NNTPServer Then
    
    '   send mail
    NNTPPort = "25"

End If
    
	'   Dim Success As Integer
	'   Success = LoadLibrary("Logicaip.dll")
	
	'   returns the number of the socket
	Dim RetVal As Integer
	RetVal = LG_VBconnect(ByVal NNTPHost, ByVal NNTPPort)
    
	Select Case RetVal
    
	    Case Zero
	    
		MRRInitComm = -1
		
	    '   this is a logicaip.dll error
	    Case Is >= FirstError
	    
		Msg Zero, Msg_NoAction, ConnErrMessage(RetVal), IdExclamation
		Exit Function

	    Case Else

		Stmsg s_Connected, Void
		
		ActiveSockets(UBound(ActiveSockets)) = RetVal
		'   return the number of the socket
		MRRInitComm = ActiveSockets(UBound(ActiveSockets))
		ReDim Preserve ActiveSockets(AddOne(UBound(ActiveSockets)))
		
		

	End Select

End Function

'   this function is to retrieve data from the open socket
Private Function RecvData (TimeOut As Integer, TheData As String, TheSocket As Integer) As Integer

On Local Error Resume Next


'   returns -1 if there is data waiting, zero if nope, wait_a_bit if
'   operation in progress, error if socket error<> from Wait_a_bit
'   reset
LG_ioctlcommand -1, TheSocket

Dim LastError As Integer
LastError = LastIpError(i_Reset, TheSocket)

'   Static LocalTimeout As Integer

'   LG_ioctlcommand 0, TheSocket

Select Case LG_get_buffer(ByVal TimeOut, TheSocket)


    Case WAIT_A_BIT

	'   tell user that we are waiting for an answer from the server
	Stmsg s_WaitABit, Void

	'   loop if operation in progress returned
	Dim Wait As Integer
	Wait = RecvData(TimeOut, TheData, TheSocket)

    Case True
    
	'   this one requests the number of bytes waiting, if any
	'   returns -1 if errors, zero if no bytes, the number of bytes if any
	Dim Peek As Long
	Dim HowManyBytes As Long
	Peek = LG_peekfordata(ByVal TheSocket, ByVal HowManyBytes)
	If Peek > Zero Then
   
	    Dim LocalBuffer As String
	    LocalBuffer = Space(Peek)
	    
	    Dim Receive As Integer
	    
	    While WsaIsBlocking() = True

		ProcessWinEvents

	    Wend
		
	    Receive = Recv(ByVal TheSocket, ByVal LocalBuffer, ByVal Len(LocalBuffer), ByVal 0)
	    
	    If Receive > Zero Then

		Dim Received As Long
		Received = lstrcpy(Received, LocalBuffer)
		
		If Len(LocalBuffer) > 1 Then
	
		    If Len(Trim(LocalBuffer)) Then TheData = LocalBuffer
		    '   do not!! STRIP!!!
		    'Left(Trim(LocalBuffer), SubtractOne(Len(Trim(LocalBuffer))))
		
		End If

		RecvData = Receive
		
	    ElseIf Receive = -1 Then

		LastError = WsaGetLastError()
		Receive = LastIpError(LastError, TheSocket)
		Msg Zero, Msg_NoAction, ConnErrMessage(LastError), Msg_Stop
		RecvData = Zero
		Peek = -1

	    Else

	    End If

	ElseIf Peek = -1 Then

		LastError = WsaGetLastError()
		If LastError <> IPP_WSAEWOULDBLOCK Then
		
		    Receive = LastIpError(LastError, TheSocket)
		    Msg Zero, Msg_NoAction, ConnErrMessage(LastError), Msg_Stop
		    RecvData = -1

		End If

	Else

		LastError = WsaGetLastError()
		    Receive = LastIpError(LastError, TheSocket)
		If LastError <> IPP_WSAEWOULDBLOCK Then
		
		    Msg Zero, Msg_NoAction, ConnErrMessage(LastError), Msg_Stop
		
		End If
		    
		    RecvData = -1


	End If

	'   reset the flag
	'   LocalTimeout = Zero
    
    Case Is > Zero

	'   this is only used to retrieve a timeout error if any
	'   If TimeOut = Zero Then TimeOut = 5
	
	'   socket error returned by LG_Get_Buffer
	LastError = WsaGetLastError()
	Receive = LastIpError(WsaGetLastError(), TheSocket)
	'   Msg Zero, Msg_NoAction, ConnErrMessage(LastError), Msg_Stop

	'   reset message
	'   If LocalTimeout > TimeOut * 50 Then Stmsg OneSpace, Void
	
	'   reset the flag
	'   LocalTimeout = Zero
	
    Case Else

	'   this is only used to retrieve a timeout error if any
	'   If TimeOut = Zero Then TimeOut = 5
	'   TheData = Void
	'   LocalTimeout = LocalTimeout + TimeOut
	'   If TimeOut > Zero Then
	
	    '   If LocalTimeout >= TimeOut * 100 Then
	
		'   Receive = LastIpError(i_ServerTimedOut, TheSocket)
	    
		'   if not success exit complaining the error
		'   Msg Zero, Msg_NoAction, ConnErrMessage(i_ServerTimedOut), IdExclamation
	    
		'   LocalTimeout = Zero
	
	    '   ElseIf LocalTimeout > TimeOut * 5 Then
	
	
		'   tell user that we are waiting for an answer from the server
		'   Stmsg s_WaitingForAnswer, Void

	    '   Else
	    
	    
	    '   End If

	'   Else
	    

	
	'   End If
	
	    '   do nothing. no data vaiting

End Select

'   it seems that consenting doevents we can lose data
'   ProcessWinEvents
If Len(TheData) Then Debug.Print TheData
End Function

'   returns the number  of bytes sent
Function SendData (TheData As String, TheSocket As Integer) As Integer

On Local Error Resume Next

'   avoid to send data on a socket wich has a buffer filled
'   with data to be retrieved
While RecvData(0, Void, TheSocket) > Zero


Wend

Dim OldLen As Integer
OldLen = Len(TheData)


Dim LastError As Integer
'   reset
LastError = LastIpError(i_Reset, TheSocket)

'   make socket a non-blocking socket
Dim RetVal As Integer
LG_ioctlcommand -1, TheSocket

Dim Writable As Integer
While Writable >= Zero

    '   see if we can send data
    Writable = LG_write_buffer(ByVal 0, ByVal TheSocket)
    
    Select Case Writable
    
	Case WAIT_A_BIT
	
	    ProcessWinEvents

	Case Zero
	
	    ProcessWinEvents

	Case True ' exit while

	Case Else

	    LastError = LastIpError(WsaGetLastError(), TheSocket)
	    SendData = -1
	    Msg Zero, Msg_NoAction, ConnErrMessage(LastError), Msg_Stop
	    Exit Function

    End Select

Wend

Dim Action As Integer
'   MaxMessageSize:see initialization routine MRRINITCOMM
'   but in winvngen this is declared as
Const MaxMessageSize = 512

If Len(TheData) <= MaxMessageSize Then

    Action = Send(ByVal TheSocket, ByVal TheData, ByVal Len(TheData), 0)
    
    If Action > Len(TheData) Then
    
	LastError = WsaGetLastError()
	SendData = LastIpError(LastError, TheSocket)
	Msg Zero, Msg_NoAction, ConnErrMessage(LastError), Msg_Stop
	Exit Function

    End If


Else

    Dim AdjustData As String
    AdjustData = Left(TheData, MaxMessageSize)
    TheData = Right(TheData, Len(TheData) - Len(AdjustData))
    
    Dim BytesSent As Long

    Do


	BytesSent = BytesSent + Len(AdjustData)
	
	Action = SendData(AdjustData, TheSocket)
	
	If Action > Len(AdjustData) Then
    
	    LastError = WsaGetLastError()
	    SendData = LastIpError(LastError, TheSocket)
	    Msg Zero, Msg_NoAction, ConnErrMessage(LastError), Msg_Stop
	    Exit Function

	End If
	
	If Len(TheData) > MaxMessageSize Then
	
	    AdjustData = Left(TheData, MaxMessageSize)
	    TheData = Right(TheData, Len(TheData) - Len(AdjustData))

	ElseIf TheData = Void Then

	    Exit Do

	Else

	    AdjustData = TheData
	    TheData = Void

	End If

	    
	Stmsg s_BytesSent, Num(BytesSent)

    Loop

End If

    
SendData = OldLen
If Len(TheData) Then Debug.Print TheData
End Function

'   when starting a new operation you will clean the buffer for
'   related socket to be sure data you request pertain to your own task
Sub CleanBuffer (Socket As Integer)

Dim LocalBuffer As String

'   clear the buffer
While RecvData(1, LocalBuffer, Socket) > Zero

    ProcessWinEvents
    
    
Wend


End Sub

