program tbl;

var
 tbor,
 tsize,
  j,
  cols : byte;
  width : array[1..12] of word;
  wide,
  s,
  sub,
  title : string;
  nowrap,
  valign,
  align : string[8];
  f : text;
  lines : word;


{$I readparm.prc }
{$I exists.prc }
{$I readline.prc }
{$I getfield.prc }
{$I value.prc }

procedure usage;
begin
    writeln('tbl input.txt second.txt config');
    halt;
end;

procedure cfg;
var cfg : string[12];
begin
   if paramstr(3)<>'' then cfg := paramstr(3)
                      else cfg := 'tbl.cfg';
   cols := value(read_params(cfg,'cols'));
   wide := read_params(cfg,'width');
   title := read_params(cfg,'title');
   tsize := value(read_params(cfg,'title_size'));
   tbor  := value(read_params(cfg,'table_border'));
   align  := read_params(cfg,'align');
   nowrap  := read_params(cfg,'nowrap');
   valign := read_params(cfg,'valign');
   sub := readline(1,paramstr(2));
end;

procedure header;
var sub:text;
      s:string;
begin
    writeln('<html>');
    writeln('<h',tsize,'>');
    writeln(title);
    writeln('</h',tsize,'>');
    writeln('<p>');
    if file_exists(paramstr(2)) then
    begin
      assign(sub,paramstr(2));
      reset(sub);
      repeat
          readln(sub,s);
          writeln(s);
      until eof(sub);
      close(sub);
    end;
    writeln('</p>');
    writeln('<TABLE BORDER="',tbor,'" ALIGN="'+align+'" NOWRAP="'+nowrap+'"><TR>');
end;

begin
    if paramcount<2 then usage;
    cfg;
    assign(f,paramstr(1));
    reset(f);
    assign(output,'');
    rewrite(output);

    header;

    readln(f,s);  {do the header line}
    for j:=1 to cols do
      begin
          if j=1 then
          writeln('<TD VALIGN="'+valign+'" ALIGN="'+align+
          '" COLSTART="',j,'" WIDTH="'+get_field(1,wide)+'"><B>'+
          get_field(1,s)+'</B></TD>')
          else
          if j=cols then {last one!}
          writeln('<TD COLSTART="',cols,'" width="'+get_field(cols,wide)+'"><b>'+get_field(cols,s)+'</b></TD><TR><TR>')
          else {must be one in the middle}
          writeln('<TD COLSTART="',j,'" width="'+get_field(j,wide)+'"><b>'+get_field(j,s)+'</b></TD>');
      end;
      writeln;

    lines := 1;
    repeat            { now do the data }
        readln(f,s);
        inc(lines);
        for j:=1 to cols do
          begin
              if j=1 then writeln('<TD COLSTART="1">'+get_field(1,s)+'</TD>')
              else
              if j=cols then writeln('<TD COLSTART="',cols,'">'+
              get_field(cols,s)+'</TD></TR><TR>')
              else writeln('<TD COLSTART="',j,'">'+get_field(j,s)+'</TD>');
          end;
          writeln;
    until eof(f);

    close(f);
    writeln('</TABLE>');
    writeln('<p>');
    writeln('</p>');
    writeln('</html>');
    close(output);
end.
