/****************************************************************************

    Module  : DockWin.c

    Changes :  20/8/93 - Changed code which distinguishes between Windows
               .EXEs & DOS .EXEs to correctly choose.
               20/8/93 - Added use of RePaintSlot func to individually repaint
               slots.

               13/9/93 - Changed code which sets the window position when the
               user starts an application which has it's window position
               stored. Code now finds top parent window of currently active
               window instead of currently active window.

               30/3/94 - corrected code to handle the mail box shrinking &
               getting the correct size after. Tidied up the mail timer when
               the app finished. Corrected a bug which allowed the right
               button click to be processed whilst a slot was being dragged.

			   3.0 beta 1 - Added code to handle new slot type for sub-docks

			   3.0 beta 2 - Fixed drag slot code to only display hand icon
			   when a slot is moved and dock is not locked.
			   Fix logic in popping out sub-docks when dock is locked

			   3.0 beta 3 - Added support for dragging slots between sub-docks

			   3.0 beta 4 - Fixed bug in code for dragging a slot off the dock
			   was causing an access violation.
			   Fixed Bug which caused part of the delete slot code to execute
			   when the "Lock Slots in Dock" option was set and the left mouse
			   button was pressed over a slot and released out side the dock.
			   Fixed minor bug in painting of Slots which are under the mouse
			   when the dock window is brgought to the front

			   3.0 beta 5 - Fixed a DialogBox() which should have been a 
			   DialogBoxParam call in WM_RBUTTONDOWN : SLOT_SPECIAL_MAIL.
			   When popping up sub-dock options dialog, ensure all children
			   of the sub dock are popped in (incase sub-dock is re-sized)
               Moved handling of Dropped files into a separate function

*****************************************************************************/

/****************************************************************************

    FUNCTION: DockWinProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)

****************************************************************************/


#include <windows.h>            /* include standard windows header */
#include <shellapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys\stat.h>
#include <string.h>
#include "freedock.h"           /* include control message definitions */
#include "dock_reg.h"
#include "titles.h"
//#include "hooks.h"

/**********************************************************
	Global Data for the various system metrics we need
**********************************************************/
extern GLOBAL_METRICS gMetrics;
extern GLOBAL_OPTIONS gOptions;

FARPROC  lpfnAboutDockDlgProc;	// Used in dockutil.c

/**************************************************************************
	Make all WinProc static variables global to save stack space.
**************************************************************************/

	static HDC      Win_hdc, Screen_hdc;
    static HCURSOR  hRemCur;
    static BOOL     bDragIcon, bRemoveSlot, bSlotOffDock, bInitialMoveActionsDone;
    static HBITMAP  hbmUnderIcon, hbmNewUnderIcon, hbmTmp;
    static HBITMAP  hbmOldUnderIcon, hbmOldNewUnderIcon, hbmOldTmp, hbmOldIconCache;
    static HDC      hdcUnderIcon, hdcNewUnderIcon, hdcTmp;
    struct stat     StatBuf;
	static FARPROC  lpfnAppOptionsDlgProc, lpfnMainOptionsDlgProc, lpfnMailOptionsDlgProc, lpfnClockOptionsDlgProc,
    	            lpfnWinExitOptionsDlgProc, lpfnSubDockOptionsDlgProc;

    static short int OldLeft, OldTop, OffLeft, OffTop;  // Old coordinates and Offset coordinates
    static RECT     MoveRect, Rect;
    static BOOL     bDragDock;
    static BOOL     bWindowPositioned = FALSE;
	static HCURSOR  hCurHand, hCurOld;
	static SLOT_TYPE OrigSlotType;


long FAR PASCAL DockWinProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
 	   DOCK_STRUCT   *ThisDock, 	// The dock for which this function is currently processing a message
	 				 *SubDock;		// A temporary sub-dock pointer
	   SLOT_ENTRY	 *SlotHit,		// Slot found under cursor (or NULL if none)
	   				 *StartSlot, *EndSlot;
static SLOT_ENTRY	 *OrigSlot;		// Slot originally under cursor

       PAINTSTRUCT  ps;         /* paint struct , used when painting window */
       UINT         Status;
       int          i;
       short int    NewX, NewY;
       DOCK_POS     DockOrientation;
static HWND         hwndRoot;
static LPARAM       lpButtonDown; // Used to discard an unwanted WM_MOUSEMOVE msg

	/*********************************************************
		Get the address of the dock struct for this window
		from the dock resistry
	*********************************************************/
	ThisDock = GetDockStruct( hwnd );
	DockOrientation = GetDockOrientation( hwnd );

    /* Select messages which are handled by this procedure */

    switch (message) {

        case WM_CREATE:             /* The window has just been created */
			/*****************************
				Register this window
			*****************************/
			{
				CREATESTRUCT *create;

				create = (CREATESTRUCT *)lParam;
				ThisDock = (DOCK_STRUCT *)(create->lpCreateParams);

				//	Initialise Dock Window var 
				ThisDock->hwndDock = hwnd;
		
				RegisterDock( hwnd, create->hwndParent, ThisDock );
			}

            /**********************************************************************
                Create bitmaps and device contexts for the icon cache Item at end
                of cache is for TmpSlot/Icons scratch space
				These are always the default (correct) slot width and height so
				that the slot icons & buttons are stored at 1:1 and then scaled
				when painted on the dock
            **********************************************************************/
            Win_hdc = GetDC(hwnd);
            ThisDock->hbmIconCache = CreateCompatibleBitmap( Win_hdc,  DEF_SLOT_WIDTH * (gOptions.MaxDockSize+1), DEF_SLOT_HEIGHT );
            ThisDock->hdcIconCache = CreateCompatibleDC(Win_hdc);
            ThisDock->hbmOldIconCache = SelectObject(ThisDock->hdcIconCache, ThisDock->hbmIconCache);
            ReleaseDC( hwnd, Win_hdc );
			/**********************************************************            
            	Initialise each Slots Icon position within the cache
				and the pointer to the parent Dock
			**********************************************************/                                                                       
			for( i=0; i < gOptions.MaxDockSize; i++ ){
				ThisDock->Slot[i].hwndSubDock = NULL;
			 	ThisDock->Slot[i].IconIndex = i * DEF_SLOT_WIDTH;
				ThisDock->Slot[i].Dock = ThisDock;
			}                                                                       
			
            /*****************************************
                Read in all slot info for this dock
            *****************************************/
           	ReadSlotOptions( ThisDock );

			/*****************************************************
				Limit Dock Size to max value set in .INI file
			*****************************************************/
			ThisDock->SlotCount = (ThisDock->SlotCount < gOptions.MaxDockSize)?ThisDock->SlotCount:gOptions.MaxDockSize;

			/**********************************************************************
				The following code is only executed when createing the root dock
				since it only needs to be executed once and must be setup for
				all sub-docks
			**********************************************************************/
			if( ThisDock->DockType == ROOT_DOCK ){
	            /****************************************************
    	            Create a bitmap to store what is under the icon
        	        when moving a slot, + A scratch pad of the same
            	    size. (Tmp)
	            ****************************************************/
    	        Win_hdc = GetDC(hwnd);

				hbmUnderIcon 	= CreateCompatibleBitmap( Win_hdc, DEF_SLOT_WIDTH, DEF_SLOT_HEIGHT );
            	hbmNewUnderIcon = CreateCompatibleBitmap( Win_hdc, DEF_SLOT_WIDTH, DEF_SLOT_HEIGHT );
	            hbmTmp 			= CreateCompatibleBitmap( Win_hdc, DEF_SLOT_WIDTH, DEF_SLOT_HEIGHT );
    	        hdcUnderIcon    = CreateCompatibleDC(Win_hdc);
        	    hdcNewUnderIcon = CreateCompatibleDC(Win_hdc);
            	hdcTmp          = CreateCompatibleDC(Win_hdc);

	            ReleaseDC(hwnd, Win_hdc);

				hbmOldUnderIcon    = SelectObject(hdcUnderIcon,    hbmUnderIcon);
        	    hbmOldNewUnderIcon = SelectObject(hdcNewUnderIcon, hbmNewUnderIcon);
            	hbmOldTmp          = SelectObject(hdcTmp,          hbmTmp);

	            hCurHand = LoadCursor(gOptions.hAppInst, "Hand");
    	        /**************************************************
        	    * Create all proc instances for all dialog boxes *
            	**************************************************/
	            lpfnAppOptionsDlgProc     = MakeProcInstance((FARPROC) AppOptionsDlgProc, gOptions.hAppInst);
    	        lpfnWinExitOptionsDlgProc = MakeProcInstance((FARPROC) WinExitOptionsDlgProc, gOptions.hAppInst);
        	    lpfnMailOptionsDlgProc    = MakeProcInstance((FARPROC) MailOptionsDlgProc, gOptions.hAppInst);
            	lpfnMainOptionsDlgProc    = MakeProcInstance((FARPROC) MainOptionsDlgProc, gOptions.hAppInst);
	            lpfnClockOptionsDlgProc   = MakeProcInstance((FARPROC) ClockOptionsDlgProc, gOptions.hAppInst);
    	        lpfnAboutDockDlgProc 	  = MakeProcInstance((FARPROC) AboutDockDlgProc, gOptions.hAppInst);
        	    lpfnSubDockOptionsDlgProc = MakeProcInstance((FARPROC) SubDockOptionsDlgProc, gOptions.hAppInst);

            	if (gOptions.AlwaysOnTop) {
                	SetWindowPos(hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);
	            }
    	        if (gOptions.MailActive) {
        	        SetTimer(hwnd, MAIL_TIMER, gOptions.MailFreq * 1000 * 60, NULL);
            	}

                /****************************************
                    Initialise pop-up titles
                ****************************************/
                EnableTitles();

//                // Register with the MaxView Hook DLL
//                RegisterClient( hwnd, gOptions.hAppInst );

			} /* End of ROOT_DOCK only Code */

            /******************************************************
                Identify this window as a drag and drop acceptor
            ******************************************************/
            DragAcceptFiles(hwnd, TRUE);

            bDragIcon = FALSE;
            bDragDock = FALSE;

            return 0;               /* end of WM_CREATE */

//        case TBHM_APPMAXIMIZED:
//             // An Application has been maximized, do we need to handle it ?
//             if( !gOptions.MaxView ){
//                return 0;
//             }
//            // Handle App Window
//
//             return 0;

        case WM_PAINT:
             /** Make sure the dock is in the correct position **/
             /** Cannot do this from WM_CREATE Message         **/
 	 		 /** Only applies to Root Dock					  **/
     		 if( (ThisDock->DockType == ROOT_DOCK) && !bWindowPositioned ){
    		     SetRootDockPos( ThisDock, DockOrientation + QX_HORZ );
                 bWindowPositioned = TRUE;
             }

			 Win_hdc = BeginPaint(hwnd, &ps);
             StartSlot = FindSlotHitInDock( ThisDock, ps.rcPaint.left, ps.rcPaint.top );
             EndSlot = FindSlotHitInDock( ThisDock, ps.rcPaint.right, ps.rcPaint.bottom );

			 for (i = StartSlot->Index; i <= EndSlot->Index; i++) {
                 PaintSlot(Win_hdc, ThisDock, &ThisDock->Slot[i]);
             }
			 EndPaint(hwnd, &ps);
			 return 0;
    
        case WM_ACTIVATEAPP :
             // Activating another App, so hide Title if displayed & stop Timer
             if(wParam == 0){
                 /*************************************
                     Kill Timer for pop-up titles
                 *************************************/
                 DisableTitles();
             }
             return 0;

        case WM_KILLFOCUS :
             // Focus is changing kill timer if focus to be passed to non-FreeDock Window
             if( !IsDockWindow( (HWND)wParam )){
                 /*************************************
                     Kill Timer for pop-up titles
                 *************************************/
                 DisableTitles();
             }
             // Else focus going to FreeDock window, so leave timer running
             return 0;

        case WM_SETFOCUS :
             if( !IsDockWindow( (HWND)wParam )){
                 // Non-FreeDock window loosing focus, so start timer
                 EnableTitles();
             }
             return 0;

        case WM_ACTIVATE :
             if(wParam != 0){
                 // This application is being activated, so start title timer
                 /*************************************
                     Start Timer for pop-up titles
                 *************************************/
                 EnableTitles();
             }
             return 0;

        case WM_TIMER:
            // Timer messages are only processed by the root dock
			if(ThisDock->DockType != ROOT_DOCK) return 0;

            if (wParam == MAIL_TIMER) {
                stat(gOptions.MailPath, &StatBuf);
                if (StatBuf.st_size > gOptions.MailBoxSize) {
                    gOptions.MailBoxSize = (unsigned long) StatBuf.st_size;
                    i = 0;
                    while ((ThisDock->Slot[i].SlotType != SLOT_SPECIAL_MAIL) && (i < 4))
                        i++;
                    if (ThisDock->Slot[i].SlotType != SLOT_SPECIAL_MAIL){
                        KillTimer(hwnd, MAIL_TIMER);
                        return 0;
                    }
                    gOptions.bMailInBox = TRUE;
                    UtilLoadIcon( ThisDock, &ThisDock->Slot[i] );
                    if (gOptions.MailSound) {
                        MessageBeep(MB_ICONHAND);
                    }
                    RePaintSlot(ThisDock, &ThisDock->Slot[i], FALSE);
                } 
                else if (StatBuf.st_size < gOptions.MailBoxSize) {
                    gOptions.MailBoxSize = (unsigned long) StatBuf.st_size;
                }
            }
            return 0;

        case WM_LBUTTONDOWN:
            SetCapture(hwnd);
            lpButtonDown = lParam;
            DisableTitles();
            OldLeft = (short int)LOWORD(lParam);
            OldTop =  (short int)HIWORD(lParam);
			// Save the original slot type and slot index
            OrigSlot = FindSlotHitInDock(ThisDock, OldLeft, OldTop);
            if( (OrigSlot->SlotType == SLOT_USED) ||
				(OrigSlot->SlotType == SLOT_SPECIAL_SUB) ){

				bInitialMoveActionsDone = FALSE;
                bRemoveSlot = FALSE;
                bDragDock = FALSE;
            }
            else if(OrigSlot->SlotType == SLOT_SPECIAL_TITLE){
				bInitialMoveActionsDone = FALSE;
				bDragIcon = FALSE;
				OffLeft = OldLeft; // Save offset of mouse
				OffTop = OldTop; // from top left of rect
            }
            else{ // Otherwise it is a builtin slot
                bDragDock = FALSE;
                bDragIcon = FALSE;
                bRemoveSlot = FALSE;
            }
            return 0;

        case WM_LBUTTONUP:
            EnableTitles();
            ReleaseCapture();
			// Only Tidy up if the mouse was actually moved
			if( bInitialMoveActionsDone ){
				if ( bDragDock ){
					DrawFocusRect( Screen_hdc, &MoveRect ); // Erase old frame
					bDragDock = FALSE;
				
					gOptions.RootDockLeft += ((short int)LOWORD(lParam) - OffLeft);
					gOptions.RootDockTop += ((short int)HIWORD(lParam) - OffTop);
					SetRootDockPos( ThisDock, DockOrientation + QX_HORZ ); // Move Dock to new position

					ReleaseDC(NULL, Screen_hdc);
					WriteDockOptions( ThisDock );	// Update Position entry in ini file
				}
				else if( bDragIcon ){
            	    SetCursor(hCurOld);

                    Screen_hdc = GetDC(NULL);
					BitBlt( Screen_hdc, OldLeft-(gOptions.SlotWidth/2), OldTop-(gOptions.SlotHeight/2), 
							gOptions.SlotWidth, gOptions.SlotHeight, hdcUnderIcon, 0, 0, SRCCOPY);
        	        ReleaseDC(NULL, Screen_hdc);

					// Reset Slot status flag to true state
	                OrigSlot->SlotType = OrigSlotType;

    	            if(bRemoveSlot  && !gOptions.DockLocked ){
						// Deleteing Sub-Docks requires specail treatment
						if(OrigSlot->SlotType == SLOT_SPECIAL_SUB){
							DestroyDock( OrigSlot->hwndSubDock );
						}
						else{
							DeleteSlotOptions( ThisDock, OrigSlot ); // Delete entry in ini file
						}
                		UtilEmptySlot( OrigSlot );
                	        RePaintSlot(ThisDock, OrigSlot, TRUE);
            	    }
        	        else{
		                SlotHit = FindSlotHitInSubDocks(ThisDock, LOWORD(lParam), HIWORD(lParam));
	    	            if ( (SlotHit != OrigSlot) && (!gOptions.DockLocked) ){   // if the slot actually moved
							// If the slot can be dropped here
            		        if( (SlotHit->SlotType == SLOT_USED) ||
								(SlotHit->SlotType == SLOT_SPECIAL_SUB) ||
        	            		(SlotHit->SlotType == SLOT_FREE) ){

								// There is a special case which must be handled here, that is when
								// a slot from a child dock is dragged onto the sub-dock slot of
								// one of it's parent docks. If this is not stopped, the sub dock
								// will disconnect itself from the main dock and be un-reachable.
								// Going in the other direction, i.e. a sub-dock slot being dragged
								// into it's own sub-dock or one of it's children is stopped by all
								// child sub-docks being popped in when the drag starts with a sub-dock.
								if( SlotHit->SlotType == SLOT_SPECIAL_SUB ){
									if( IsAParentDock(SlotHit->hwndSubDock, OrigSlot) ){
										// Repaint original location
	    		                	    RePaintSlot( OrigSlot->Dock, OrigSlot, FALSE );
										// All done here							
										return 0;
									}
									if ( IsDockPoppedOut( SlotHit->hwndSubDock ) ){
									PopInChildren( SlotHit->hwndSubDock );
									}
									DeleteSlotOptions( SlotHit->Dock, SlotHit );
								}

								// If either (or both) slot(s) is a sub-dock, we need to delete all
								// slot options to allow the new numbering to be written to the .INI file
								if( OrigSlot->SlotType == SLOT_SPECIAL_SUB ){
									DeleteSlotOptions( OrigSlot->Dock, OrigSlot );
								}
					
								SwapSlots( OrigSlot, SlotHit );
								
								WriteSlotOptions( SlotHit->Dock,  SlotHit  );	// Update entry in ini file
								WriteSlotOptions( OrigSlot->Dock, OrigSlot );	// Update entry in ini file
					
	        	                RePaintSlot( OrigSlot->Dock, OrigSlot, FALSE );
    		                    RePaintSlot( SlotHit->Dock,  SlotHit,  FALSE );
							}
		                    else {   // Slot must be a special, can't move a slot to here.
    	                    	RePaintSlot( OrigSlot->Dock, OrigSlot, FALSE );
        	            	}
                    	}
						else{
							RePaintSlot( SlotHit->Dock, SlotHit, FALSE );
						}
    	            }
					// Only repaint hit slot of there was one.
					if( !bRemoveSlot ){
						// Repaint Destination Slots
						// Always paint the slot hit
    	    	        RePaintSlot(SlotHit->Dock, SlotHit , TRUE);
						if( SlotHit->Index > 0 ){
							// Paint the slot before SlotHit (if Safe)
	                		RePaintSlot(SlotHit->Dock, &(SlotHit->Dock->Slot[SlotHit->Index-1]), TRUE);
						}
						if( SlotHit->Index < SlotHit->Dock->SlotCount ){
							// Paint the slot after SlotHit (if safe)
    	        	      	RePaintSlot(SlotHit->Dock, &(SlotHit->Dock->Slot[SlotHit->Index+1]), TRUE);
						}
					}
    	            bDragIcon = FALSE;
	            }
			}
            else{
				// Else this was a click since the mouse did not move between button down & up
				// Reset Slot status flag to true state, only if it was a normal slot / sub-dock
  	            SlotHit = FindSlotHitInSubDocks(ThisDock, LOWORD(lParam), HIWORD(lParam));
                switch( OrigSlot->SlotType ){

				    case SLOT_SPECIAL_SUB :
					case SLOT_USED :
		    			 if( SlotHit == NULL ){  // A Return of NULL means the Dock is locked
			    		 	 bDragIcon = FALSE;	// and a button up event has occured out of the dock
				    	 	 bDragDock = FALSE;
					     	 return 0; 
    					 }
                         // Drop through here
                    case SLOT_SPECIAL_TITLE :
                    case SLOT_SPECIAL_CLOCK :
                    case SLOT_SPECIAL_EXIT :
                    case SLOT_SPECIAL_MAIL :

       	    	         RePaintSlot(SlotHit->Dock, SlotHit , FALSE);
            	    	 if( SlotHit->SlotType == SLOT_SPECIAL_SUB ){
		    				 // Toggle sub-dock state.
			    			 SubDock = GetDockStruct( SlotHit->hwndSubDock );
				    		 // Check if this is a sub-dock which we need to pop out/in
					    	 if( IsDockPoppedOut( SlotHit->hwndSubDock) ){	// ThisDock is popped out
						    	 PopInChildren( SubDock->hwndDock );
    						 }
	    					 else {									// ThisDock is not popped out
		    					 SetSubDockWinPos( SubDock, TRUE );
			    			 }
				    	  }
					      else if (gOptions.SingleClickStart){
						     // Activate Slot with a single click
            	        	 SendMessage( hwnd, WM_LBUTTONDBLCLK, wParam, lParam );
	       				  }
                          break;

		    		} // end of switch
				bDragIcon = FALSE;
				bDragDock = FALSE;
            }
            return 0;

        case WM_MOUSEMOVE:
			// We are only interested in mouse movement if the left button is down.
			if (wParam != MK_LBUTTON){
                if( IsTitleShown() ){
                    ResetTitleTimer();
                }
				return 0;
			}
			
            // This piece of code is neccessary because if a FreeDock window
            // is out of focus or not active and the user clicks on a slot,
            // windows sends a WM_LBUTTONDOWN which is OK, but then sends a
            // WM_MOUSEMOVE which is not OK since the mouse has not moved since the
            // WM_LBUTTONDOWN event. If they were sent in the other order there would
            // be no problem
            // Discard Mouse move events from same point as button down.
            if( (lpButtonDown != 0L) && (lParam == lpButtonDown) ){
                lpButtonDown = 0L; // don't discard any more messages
                return 0;
            }

            // Are we about to drag an Icon ?
    		if( (!gOptions.DockLocked) && 
                ( (OrigSlot->SlotType == SLOT_USED) ||
				  (OrigSlot->SlotType == SLOT_SPECIAL_SUB) )){
                bDragIcon = TRUE;
                /***********************************************************
                    Delete slot temporaraly & FORCE a repaint before
                 	going any further.
                ***********************************************************/
                OrigSlotType = OrigSlot->SlotType;
				OrigSlot->SlotType = SLOT_FREE;
		    }
            // about to drag dock
            else if(OrigSlot->SlotType == SLOT_SPECIAL_TITLE){
				bDragDock = TRUE;
            }

			// DRAGGING THE MAIN DOCK
			if (bDragDock){
				// INITIAL ACTIONS
				if( !bInitialMoveActionsDone ){
	                hCurOld = SetCursor(hCurHand);

					Screen_hdc = GetDC(NULL);
					// Ensure no Sub-Docks sticking out when RootDock is moved
					PopInChildren( ThisDock->hwndDock );

					// GetWindowRect to get top & left coord of dock window
					{
		    		RECT		TmpRect;
					GetWindowRect( hwnd, &TmpRect );
					MoveRect.left   = TmpRect.left;
					MoveRect.top    = TmpRect.top;
					}
		
					if(DockOrientation == DOCK_HORZ){
						MoveRect.bottom = MoveRect.top + gOptions.SlotHeight;
						MoveRect.right  = MoveRect.left + ThisDock->SlotCount*gOptions.SlotHeight;
					}
					else{
						MoveRect.bottom = MoveRect.top + ThisDock->SlotCount*gOptions.SlotHeight;
						MoveRect.right  = MoveRect.left + gOptions.SlotWidth;
					}
					DrawFocusRect( Screen_hdc, &MoveRect );

					bInitialMoveActionsDone = TRUE;
				}

				DrawFocusRect( Screen_hdc, &MoveRect ); // Erase old frame
				OldLeft = (short int)LOWORD(lParam);
				OldTop  = (short int)HIWORD(lParam);
				// GetWindowRect to get top & left coord of dock window
				{
			    RECT	TmpRect;
				LONG 	DockLeft, DockTop;
				GetWindowRect( hwnd, &TmpRect );
				DockLeft   = TmpRect.left;
				DockTop    = TmpRect.top;
				MoveRect.left   = (DockLeft + OldLeft) - OffLeft;
				MoveRect.top    = (DockTop + OldTop) - OffTop;
				}

				if(DockOrientation == DOCK_HORZ){
					MoveRect.bottom = MoveRect.top + gOptions.SlotHeight;
					MoveRect.right  = MoveRect.left + ThisDock->SlotCount*gOptions.SlotHeight;
				}
				else{
					MoveRect.bottom = MoveRect.top + ThisDock->SlotCount*gOptions.SlotHeight;
					MoveRect.right  = MoveRect.left + gOptions.SlotWidth;
				}
				DrawFocusRect( Screen_hdc, &MoveRect );
			}
			// DRAGGING A SLOT
			else if(bDragIcon){
				// INITIAL ACTIONS
				// Carry out initial actions for MOUSEMOVE state
				if( !bInitialMoveActionsDone ){
					RECT	  rect;   // only used in this block for screen <-> client coords
                    short int ccOldLeft, ccOldTop; // Client Coords

	                hCurOld = SetCursor(hCurHand);
					// If moving a sub-dock slot, popin all children.
					if ( (OrigSlotType == SLOT_SPECIAL_SUB) &&
						       IsDockPoppedOut( OrigSlot->hwndSubDock ) ){
						PopInChildren( OrigSlot->hwndSubDock );
					}

					// Because we use the Screen DC when dragging slots, we need to
					// Modify client coords to Screen Coords used in Dragging Slots
					GetWindowRect( hwnd, &rect );
                    ccOldTop = OldTop;
                    ccOldLeft = OldLeft;
					OldTop  += (short int)rect.top + gMetrics.DockFrameHeight;  // Correct for window border
					OldLeft += (short int)rect.left + gMetrics.DockFrameWidth; //

                    Win_hdc    = GetDC(hwnd);	//:-)
					Screen_hdc = GetDC( NULL );

					/******************************************
                         Paint the area under the blank slot
                    ******************************************/
					BlankSlot( Win_hdc, ThisDock, OrigSlot );

                    /*****************************************
                    Copy what will be under the Icon
                    *****************************************/
                    BitBlt( hdcUnderIcon, 0, 0, gOptions.SlotWidth, gOptions.SlotHeight,
                            Screen_hdc, OldLeft-(gOptions.SlotWidth/2), OldTop-(gOptions.SlotHeight/2), SRCCOPY);
                    /********************
                        Draw the Icon
                    ********************/
                    UtilDrawIcon( Win_hdc, ThisDock, OrigSlot, 
                                  ccOldLeft-(gOptions.SlotWidth/2), // correct client -> screen convertion
                    			  ccOldTop-(gOptions.SlotHeight/2),  // since this draw is to the window
                    			  TRUE);

                    ReleaseDC(NULL, Screen_hdc); //:-)
                    ReleaseDC(hwnd, Win_hdc);	

					bInitialMoveActionsDone = TRUE;
				}

                if( IsCursorOutOfDock( ThisDock, (int)LOWORD(lParam), (int)HIWORD(lParam)) ){
                    if(!bRemoveSlot){
                        bSlotOffDock = FALSE;
                        bRemoveSlot = TRUE;
                        hRemCur = LoadCursor(gOptions.hAppInst, "RemoveSlot");
                        SetCursor( hRemCur );
                    }
					// Commented out to ensure that slot is drawn correctly until it is
					// completely dragged off the dock.
                }
                else if(bRemoveSlot){
                    bRemoveSlot = FALSE;
                    SetCursor(hCurHand);
                    DestroyCursor(hRemCur);
                }

                /*****************************************************************
                    The following is an attempt at getting flicker free dragging
                    of a slot around the dock, third buffer required to eliminate
                    trailing/leading edge flicker when dragging
                *****************************************************************/
				{
				// Modify client coords to Screen Coords used in Dragging Slots
				RECT	rect;
				GetWindowRect( hwnd, &rect );
                NewX = (short int)LOWORD(lParam) + (short int)rect.left;
                NewY = (short int)HIWORD(lParam) + (short int)rect.top;
				}
                Screen_hdc = GetDC(NULL);

				// Blit what will be covered to Tmp
                BitBlt( hdcNewUnderIcon, 0, 0, gOptions.SlotWidth, gOptions.SlotHeight,
                        Screen_hdc, NewX-(gOptions.SlotWidth/2), NewY-(gOptions.SlotHeight/2), SRCCOPY);

                // Blit UnderIcon to old-new in tmp
                BitBlt( hdcNewUnderIcon, (OldLeft)-NewX, (OldTop)-NewY, gOptions.SlotWidth, gOptions.SlotHeight,
                        hdcUnderIcon, 0, 0, SRCCOPY);

                // Draw complete Icon into buffer & then blit to screen
                UtilDrawIcon( hdcTmp, ThisDock, OrigSlot, 0, 0, TRUE );

                // Draw Icon into Under Icon Bmp at new-old
                UtilDrawIcon( hdcUnderIcon, ThisDock, OrigSlot, NewX-(OldLeft), NewY-(OldTop), TRUE);

                // Blit complete icon to screen
                BitBlt( Screen_hdc, NewX-(gOptions.SlotWidth/2), NewY-(gOptions.SlotHeight/2), 
                		gOptions.SlotWidth, gOptions.SlotHeight, hdcTmp, 0, 0, SRCCOPY);

                // Replace what was covered by the icon, and is not covered by new pos
                BitBlt( Screen_hdc, (OldLeft-(gOptions.SlotWidth/2)), (OldTop-(gOptions.SlotHeight/2)), 
                		gOptions.SlotWidth, gOptions.SlotHeight, hdcUnderIcon, 0, 0, SRCCOPY);

                // Save new image of what's under the icon.
                BitBlt( hdcUnderIcon, 0, 0, gOptions.SlotWidth, gOptions.SlotHeight,
                        hdcNewUnderIcon, 0, 0, SRCCOPY);

                // Save new posn
                OldLeft = NewX;
                OldTop = NewY;

                if(!bSlotOffDock) bSlotOffDock = TRUE;
                ReleaseDC(NULL, Screen_hdc);
			}
            return 0;


        case WM_LBUTTONDBLCLK:
            /******************************************************
               First need to find which button has been hit.
            ******************************************************/

            SlotHit = FindSlotHitInDock(ThisDock, LOWORD(lParam), HIWORD(lParam));

            switch ( SlotHit->SlotType) {
				case SLOT_SPECIAL_SUB:
					// NO ACTION
					break;

                case SLOT_USED:
					RePaintSlot( ThisDock, SlotHit, FALSE);
                    ExecSlot( SlotHit, SlotHit->CmdLine );
                    break;

                case SLOT_SPECIAL_MAIL:
                	gOptions.bMailInBox = FALSE;
                    UtilLoadIcon( ThisDock, SlotHit );
                    RePaintSlot(ThisDock, SlotHit, FALSE);
                    break;

                case SLOT_SPECIAL_EXIT:
                    if (gOptions.WinExitConfirm) {
#ifdef WIN32
                        switch( gOptions.ShutdownAction ){
                            case FD_LOGOFF :
                                 if( MessageBox(hwnd, "Do you really want to Log Off ?",
                                    "FreeDock", MB_OKCANCEL | MB_ICONSTOP) == IDOK){
                                     ExitWindowsEx( EWX_LOGOFF, 0 );
                                 }
                                 break;
                            case FD_SHUTDOWN :
                                 if( MessageBox(hwnd, "Do you really want to Shutdown ?",
                                    "FreeDock", MB_OKCANCEL | MB_ICONSTOP) == IDOK){
                                     GetShutdownPrivilege ();
                                     ExitWindowsEx( EWX_SHUTDOWN, 0 );
                                 }
                                 break;
                            case FD_REBOOT :
                                 if( MessageBox(hwnd, "Do you really want to Shutdown & Restart ?",
                                    "FreeDock", MB_OKCANCEL | MB_ICONSTOP) == IDOK){
                                     GetShutdownPrivilege ();
                                     ExitWindowsEx( EWX_REBOOT, 0 );
                                 }
                                 break;
                            default :
                                 break;
                        }
#else
                        if( MessageBox(hwnd, "Do you really want to exit Windows ?",
                            "FreeDock", MB_OKCANCEL | MB_ICONSTOP) == IDOK){
                            ExitWindows(0, 0);
                        }
#endif
                    } 
                    else {
#ifdef WIN32
                        switch( gOptions.ShutdownAction ){
                            case FD_LOGOFF :
                                 ExitWindowsEx( EWX_LOGOFF, 0 );
                                 break;
                            case FD_SHUTDOWN :
                                 ExitWindowsEx( EWX_SHUTDOWN, 0 );
                                 break;
                            case FD_REBOOT :
                                 ExitWindowsEx( EWX_REBOOT, 0 );
                                 break;
                            default :
                                 // Dunno
                                 break;
                        }
#else
                        ExitWindows(0, 0);
#endif
                    }
                    break;

                case SLOT_SPECIAL_TITLE:
                    DisableTitles();
                    DialogBoxParam(gOptions.hAppInst, "ABOUTDOCKDLG", hwnd, lpfnAboutDockDlgProc,
                                   (LPARAM)hwnd);
                    EnableTitles();
                    break;

            }
            return 0;

        case WM_DROPFILES:
			ProcessDroppedFiles( ThisDock, (HANDLE)wParam);
            return 0;

        case WM_RBUTTONDOWN:
            /**********************************************************
              If we are currently dragging a slot or the dock  around
              then ignore any buttons being pressed
          ************************************************************/
            if( bDragIcon || bDragDock ) return 0;

            SlotHit = FindSlotHitInDock(ThisDock, LOWORD(lParam), HIWORD(lParam));

            switch ( SlotHit->SlotType ) {
                case SLOT_USED:
                case SLOT_FREE:
                    DisableTitles();
                    Status = DialogBoxParam( gOptions.hAppInst, "APPOPTIONSDLG", hwnd, 
                    						lpfnAppOptionsDlgProc, (LPARAM)SlotHit );
                    EnableTitles();
                    break;

                case SLOT_SPECIAL_TITLE:
					// pop-in any child docks, since the dock scaling can be changed in this
					// dialog
					PopInChildren( ThisDock->hwndDock );
                    DisableTitles();
                    Status = DialogBoxParam( gOptions.hAppInst, "MAINOPTIONSDLG", hwnd, 
                    						 lpfnMainOptionsDlgProc, (LPARAM)ThisDock);
                    EnableTitles();
                    break;


				case SLOT_SPECIAL_SUB:
					// First ensure that the children of this sub dock are popped in
					PopInChildren( SlotHit->hwndSubDock );
                    DisableTitles();
                    Status = DialogBoxParam( gOptions.hAppInst, "SUBDOCKOPTIONSDLG", hwnd, 
                    						lpfnSubDockOptionsDlgProc, (LPARAM)SlotHit );
                    EnableTitles();
					break;

                case SLOT_SPECIAL_EXIT:
                    DisableTitles();
                    Status = DialogBox(gOptions.hAppInst, "WINEXITOPTIONSDLG", hwnd, lpfnWinExitOptionsDlgProc);
                    EnableTitles();
                    break;

                case SLOT_SPECIAL_MAIL:
                    DisableTitles();
                    Status = DialogBoxParam(gOptions.hAppInst, "MAILOPTIONSDLG", hwnd, 
                    						lpfnMailOptionsDlgProc, (LPARAM)ThisDock);
                    EnableTitles();
                    break;

                case SLOT_SPECIAL_CLOCK:
                    DisableTitles();
                    Status = DialogBox(gOptions.hAppInst, "CLOCKOPTIONSDLG", hwnd, lpfnClockOptionsDlgProc);
                    EnableTitles();
                    break;
            }

            return 0;

        case WM_QUIT:
        case WM_DESTROY:
		    if ( ThisDock->DockType == ROOT_DOCK ){
                DestroyTitleWindow();
//                DeRegisterClient( hwnd );
	            FreeProcInstance(lpfnAppOptionsDlgProc);
    	        FreeProcInstance(lpfnAboutDockDlgProc);
        	    FreeProcInstance(lpfnWinExitOptionsDlgProc);
            	FreeProcInstance(lpfnMailOptionsDlgProc);
	            FreeProcInstance(lpfnMainOptionsDlgProc);
    	        FreeProcInstance(lpfnClockOptionsDlgProc);
        	    KillTimer(ThisDock->hwndDock, MAIL_TIMER);
				SelectObject(hdcUnderIcon,      hbmOldUnderIcon);
	            SelectObject(hdcNewUnderIcon,   hbmOldNewUnderIcon);
    	        SelectObject(hdcTmp,            hbmOldTmp);
				DeleteObject(hbmUnderIcon);
            	DeleteObject(hbmNewUnderIcon);
            	DeleteObject(hbmTmp);
				DeleteDC(hdcUnderIcon);
            	DeleteDC(hdcNewUnderIcon);
            	DeleteDC(hdcTmp);
	            DestroyCursor(hCurHand);
    	        // Delete UtilLoadIcon() internal bitmap handle.
        	    UtilLoadIcon( NULL, NULL );
	            PostQuitMessage(0);
			}

            /*******************************************************************
            	Release all the Device Contexts	and bitmaps used by this dock
            *******************************************************************/
            SelectObject(ThisDock->hdcIconCache, ThisDock->hbmOldIconCache);
            DeleteObject(ThisDock->hbmIconCache);
			DeleteDC(ThisDock->hdcIconCache);
			
			// Don't call this since it erases the .INI entries for the dock
			// DestroyDock( hwnd );

			return 0;
    }

    /* return all unused mesages to the system */
    return DefWindowProc(hwnd, message, wParam, lParam);
}
