#include <windows.h>    // includes basic windows functionality
#include <stdio.h>      // includes standard file i/o functionality
#include <string.h>     // includes string functions
#include "hooks.h"

// Prototype call back function.
LRESULT CALLBACK CBTProc( int nCode, WPARAM wParam, LPARAM lParam);

static HHOOK hHook = NULL;

// Client List must be WPARAM & not HWND since HWND is declared as
// * void which has no size
static WPARAM  ClientList[MAX_CLIENTS];
static int     ClientCount = 0;

BOOL FAR PASCAL RegisterClient( HWND hwndClient, HANDLE hInst ){

    int         i;

    if( hHook == NULL ){
        return FALSE;
    }

    // Check List is not full
    if( ClientCount < MAX_CLIENTS ){
        //Check that Client is not already registered
        for( i=0 ; i < ClientCount; i++){
            if( hwndClient == (HWND)ClientList[i] ){
                return(FALSE);
            }
        }
        // Other wise add it to the end of the list
        ClientList[ClientCount++] = (WPARAM)hwndClient;
        return(TRUE);
    }
    else {
        return(FALSE);
    }
}

BOOL FAR PASCAL DeRegisterClient( HWND hwndClient ){
    
    int i;
    
    // Find CLient in list    
    for( i=0 ; i < ClientCount; i++){
        if( hwndClient == (HWND)ClientList[i] ){
            // Found Client in non-last list entry
            if ( i != ClientCount-1  ){
                // copy last client in list over this one
                ClientList[i] = ClientList[ClientCount-1];
            }
            // Delete last entry in list
            ClientCount--;
            return(TRUE);
        }
    }
    // Can't find client
    return(FALSE);
}

void NotifyClients( HWND hwndMaxWindow ){
    
    int i;

    if( ClientCount > 0 ){
        for( i = 0; i < ClientCount; i++ ){
            // Use SendMessage to allow each dock to move the app window.
            SendMessage( (HWND)ClientList[i], TBHM_APPMAXIMIZED, (WPARAM)hwndMaxWindow, 0L );
        }
    }
}


BOOL FAR PASCAL InstallHook( void ){

    HINSTANCE hInst;

    if( hHook != NULL ){
        return TRUE;
    }

    hInst = LoadLibrary( "HOOKDK32.DLL" );

    if( hInst == NULL ){
        return FALSE;
    }

    hHook = SetWindowsHookEx( WH_CBT, 
                              CBTProc, 
                              hInst,
                              0L);
    return (hHook != NULL);
}

BOOL FAR PASCAL RemoveHook( void ){
    if( hHook != NULL ){
        UnhookWindowsHookEx( hHook );
    }
    return (TRUE);
}


/****************************************************************
  WH_CBT hook procedure
 ****************************************************************/

LRESULT CALLBACK CBTProc( int nCode, WPARAM wParam, LPARAM lParam){

    HWND hwndMaxWindow; 
    WORD swWord;        // ShowWindowWord

    if (nCode < 0)  /* do not process message */
        return CallNextHookEx(hHook, nCode, wParam, lParam);

    switch (nCode) {
        case HCBT_MINMAX:
             hwndMaxWindow = (HWND)wParam;
             swWord = LOWORD(lParam);
             if( swWord == SW_SHOWMAXIMIZED	){
                NotifyClients ( hwndMaxWindow );
             }
             break;
    }

    return CallNextHookEx(hHook, nCode, wParam, lParam);
}


