/****************************************************************************

    Module  : Main.c

	v3.0 beta 2 : Changes to support multiple instances of FreeDock under
				  WIN32.
    v3.0 beta 5 : Modified code used in 16 bit version to detect running
                  previous instance and switch to that window.

*****************************************************************************/

#include <windows.h>
#include <stdio.h>		// for sprintf()
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "freedock.h"
#include "dock_reg.h"
#include "titles.h"
//#include "hooks.h"

/**********************************************************
	Global Data for the various system metrics we need
**********************************************************/
GLOBAL_METRICS gMetrics;
GLOBAL_OPTIONS gOptions;

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
    MSG       msg;
    WNDCLASS  wcDockClass;
	HWND	  hwndDock;
	char	  szRootDockID[MAX_DOCK_ID_LEN];


    /************************************************************************
		ON 16 BIT VERSION :
        Test to make sure this is the only copy of this application running
        on this machine, if not activate previous instance and exit.

		ON 32 BIT VERSION :
		Get the ID for the ROOT of this Dock by querying the
        FreeDockInstanceCount
    *************************************************************************/
#ifndef WIN32
    if (hPrevInstance) {
        HWND hwndPrev;
        char WindowCaption[MAX_FPATH_LEN];

        sprintf( WindowCaption, "%s [%s]", gOptions.szAppName, "1" );
        hwndPrev = FindWindow( gOptions.szAppName, gOptions.szAppName ); 
        ShowWindow( hwndPrev,SW_SHOW );
        exit (-1);
    }
	gOptions.RootDockID = 1;
#else
	gOptions.RootDockID = GetRootDockID();
#endif

	/*********************************************************************
	 * Set the name of the application                                        *
 	*********************************************************************/
	sprintf( gOptions.szAppName, "FreeDock %s %s", VersionText, OS_Bits );

    /*************************************************************
         Determine the size of the screen, used to size and
         position the window.
    *************************************************************/
    gMetrics.ScreenWidth     = GetSystemMetrics(SM_CXSCREEN);
    gMetrics.ScreenHeight    = GetSystemMetrics(SM_CYSCREEN);
    gMetrics.IconWidth       = GetSystemMetrics(SM_CXICON);
    gMetrics.IconHeight      = GetSystemMetrics(SM_CYICON);
	gMetrics.DlgTitleHeight  = GetSystemMetrics(SM_CYCAPTION);
	gMetrics.DlgFrameWidth   = GetSystemMetrics(SM_CXDLGFRAME);
	gMetrics.DlgFrameHeight  = GetSystemMetrics(SM_CYDLGFRAME);
	gMetrics.DockFrameWidth  = GetSystemMetrics(SM_CXBORDER);
	gMetrics.DockFrameHeight = GetSystemMetrics(SM_CYBORDER);

    ConvertINIFile();

	ReadGlobalOptions();

    /*********************************************
      * define and register the dock window class *
     *********************************************/

    wcDockClass.style = CS_DBLCLKS;
    wcDockClass.lpfnWndProc = (WNDPROC) DockWinProc;
    wcDockClass.cbClsExtra = 0;
    wcDockClass.cbWndExtra = 0;
    wcDockClass.hInstance = hInstance;
    wcDockClass.hCursor = LoadCursor(NULL, IDC_ARROW);
    wcDockClass.hbrBackground = GetStockObject(LTGRAY_BRUSH);
    wcDockClass.lpszMenuName = NULL;
    wcDockClass.lpszClassName = gOptions.szAppName;

#ifdef WIN32
    wcDockClass.hIcon = LoadIcon(hInstance, "FREEDOCK32");
#else
    wcDockClass.hIcon = LoadIcon(hInstance, "FREEDOCK16");
#endif

    if(!RegisterClass(&wcDockClass)) return FALSE;

    gOptions.hAppInst = hInstance;

    /********************************************
      create and show the root dock window
	  Root has no parent so set parent to NULL
    ********************************************/
	sprintf( szRootDockID, "%d", gOptions.RootDockID );
	hwndDock = CreateDock( ROOT_DOCK, NULL, szRootDockID );

    if(!hwndDock) return FALSE;

    ShowWindow(hwndDock, SW_SHOW);
    UpdateWindow(hwndDock);

    /*******************************
        Create the Title Window
    *******************************/
    InitTitleWindow( hInstance, hwndDock );

//    /*******************************************
//        Install the windows Hook if required
//    *******************************************/
//    if( gOptions.MaxView && !InstallHook() ) {
//        DockError( hwndDock, "Error Installing Window Hook." );
//    }

    /************************************************
         enter message processing loop
    ************************************************/

    while (GetMessage(&msg, NULL, 0, 0)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }

//    /*******************************************
//        Remove the windows Hook if required
//    *******************************************/
//    if( gOptions.MaxView && !RemoveHook() ) {
//        DockError( hwndDock, "Error Removing Window Hook." );
//    }

    return msg.wParam;      /* exit application */
}
