unit Unit3;

interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, StdCtrls, Mask, DBCtrls, DB, DBTables, DACMgr;

type
	TForm3 = class(TForm)
		OldTable: TTable;
		Button1: TButton;
    DACManager1: TDACManager;
    SecurityObject1: TSecurityObject;
		procedure Button1Click(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	Form3: TForm3;

implementation

{$R *.DFM}
{*********encrypt string procedure*********}
function OldEncryptStr(lpTarget:string):string;
var
bit,bit2:byte;
i,x:integer;
lpEncrypt:char;
begin
x:=length(lpTarget);
bit:=x;
bit2:=bit XOR (bit + 1);

		for i:=1 to x do
		begin
				 lpEncrypt := lpTarget[i];
				 lpEncrypt:=chr(ord(lpEncrypt) XOR bit);
				 lpEncrypt:=chr(ord(lpEncrypt) XOR bit2);
		inc(bit2);
		dec(bit);
		lpTarget[i] :=lpEncrypt;
		end;

		result:=lpTarget;
end;{OldEncryptStr}
{This proc will convert an old table to a new table.
Each Old record is read in and decrypted - As the PIN could be of variable
length (if you altered our system!!) we deduct the OldName from the OldSID
(which is supposed to be PIN+Name) to leave us (hopefully) with the PIN.
At each record we add the old OList to a stringlist so we can convert this
list to the new format later.
A new record is created and we add to another list to allow us to match an
old record to a new record (the oldOID is a string, the newOID is a longint)
After completing part one, we have a new table with a record for each old
record BUT it has no permissions.

So stage 2, we go to the stringlist containing the OldOlist (SOL) and
process these one by one.
OK so we get a string, we must parse this to get an individual group..
the parsing is diferent for User and Object recs. Having got a group we
look it up in MatchList to find its corresponding new GroupOID and then
add this onto a new list that we are building.
When we have parsed all the string for this loop we wrrite this new list
into the security table.

A word on Permissions-The old and new Permissions are not really compatible
even more so under the new scheme you can make permissions anything you want
but we have tried our best
Old - ---> Input  Modify Delete         Exceute
New - Read Insert Modify Delete Approve Run
So what we have done is to say
1. If you have any permissions we will bump them up one as we now have
a new starting permission of Read
2. If you have any permissions for the object we will add in Read
3. If you have Execute permissions we will translate this to
Approve and Run under the new system

IF YOU WANT TO DO IT DIFFERENT LOOK AT THE CODE BELOW and see where we
manipulate the permissions.

WE REQUIRE EXCLUSIVE ACCESS TO THE NEW TABLE!!
}
procedure TForm3.Button1Click(Sender: TObject);
var
OldSID,OldOID,OldName,OldType,OldPIN,OldOList:string;
OID:longint;
SOL,MatchList:TStringList;
x,xcnt:integer;
AOID,AGroup:string;
TmpBGroupP:byte;
TmpAGroupP:string;
GroupP:TPermissions;
NewType:integer;
P:pointer;
Z:longint;
FL:TList;
begin
Button1.Caption:='Starting';
with DACM do EmptyTable;
SOL:=TStringList.Create;
MatchList:=TStringList.Create;
FL:=TList.Create;
with OldTable do
	begin
		xcnt:=0;
		first;
		while not EOF do
		begin
			OldSID:=OldEncryptStr(FieldByName('SID').AsString);
			OldOID:=FieldByName('OID').AsString;
			OldName:=OldEncryptStr(FieldByName('Name').AsString);
			OldType:=FieldByName('Type').AsString;
			OldOlist:=OldEncryptStr(FieldByName('OList').AsString);

			{build list of OLists}
			SOL.Add(OldOlist);

			if OldType='U' then begin
				OldPIN:=copy(OldSID,0,length(OldSID)-length(OldName));
				Security.AppendUser(OldPIN,OldName,OID);
				MatchList.AddObject(OldOID,pointer(OID));{build lsit to match old/new}
			end
			else if OldType='G' then begin
				Security.AppendGroup(OldName,OID);
				MatchList.AddObject(OldOID,pointer(OID));
			end
			else if OldType='O' then begin
				Security.AppendObject(OldName,OldSID,OID);
				MatchList.AddObject(OldOID,pointer(OID));
			end;

		Button1.Caption:='Processed Record '+inttostr(xcnt);
    inc(xcnt);
		next;
		end;

		Button1.Caption:='Stage2';

		{with the items in SOL}
		for x:=0 to SOL.Count-1 do
		begin
			FL.Clear;
			TmpBGroupP:=0;

			{Get a list from SOL}
			OldOlist:=SOL[x];

			{Find the new rec for this one}
			P:= MatchList.Objects[x];
			DACM.LocateOID(longint(P));
			NewType:=DACM.FieldByName('Type').AsInteger;

			while Length(OldOlist)>0 do
			begin
				AOID:=Copy(OldOlist,1,5);
				if NewType=3 then
				begin
					TmpAGroupP:=Copy(OldOlist,6,1);
					TmpBGroupP:=ord(TmpAGroupP[1])-32;
					TmpBGroupP:=TmpBGroupP shl 1 ;
					GroupP:=TPermissions(TmpBGroupP);
					system.delete(OldOlist,1,7);
					{Manipulate Permissions}
					if GroupP<>[] then include(GroupP,0);
					if (5 in GroupP) then Include(GroupP,4);
				end
				else
					system.delete(OldOlist,1,6);

				if MatchList.IndexOf(AOID) <> -1 then
				begin
					P:=MatchList.Objects[MatchList.IndexOf(AOID)];
					Z:=longint(P);
					TOIDRec(Z).Permissions:=GroupP;
					FL.Add(pointer(Z));
				end;
			end;
			P:= MatchList.Objects[x];
			{only write it if we can find the correct record}
			if DACM.LocateOID(longint(P)) then DACM.WriteToOList(FL);
		end;
	end;
	Button1.Caption:='Finished';
end;

end.
