/* Dansk installations program for Archive Folder.
   Skal kaldes fra afinst.cmd
*/
call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs

Call SysCls
lang = "Dansk"

Say
Say "         AF - The Arkiv Folderen - Installations program"
Say "         =============================================="
Say
Say "  Dette script vil kopiere programfilerne til installationsbiblioteket"
Say "  danne et program objekt og oprette associationer og skabeloner"
Say "  for Arkiv Folderen."
Say
Call charout, "  Vil du fortstte? (j/N): "

answer = SysGetKey(echo)


if answer <> "j" & answer <> "J" then return
Say

say "  Skriv det FULDE stinavn til det bibliotek hvor du vil installere"
say "  AF eller tryk ENTER for at installere fra det aktuelle bibliotek."
Call charout, "  Bibliotek (ingen efterflgende backslash!): "
pull InstallDir

if length(InstallDir) = 0 then do
  DontCopy = 1
  InstallDir = Directory()
end
else do
  DontCopy = 0
  if SysFileTree(InstallDir, dir, D) <> 0 then do
    Say "Ikke nok hukommelse!"
    return
  end
  if dir.0 = 0 then do
    Call charout, "  "InstallDir "findes ikke! vil du oprette det? (y/N): "
    answer = SysGetKey(echo);say
    if answer <> "y" & answer <> "Y" then return
    if SysMkDir(InstallDir) <> 0 then do
      Say "  Fejl ved oprettelse af" InstallDir"!"
      return -1
    end
  end
end

if exists(lang'.dll') then
  'copy' lang'.dll' InstallDir'\af.dll'
else do
  say "  Kunne ikke finde" lang'.dll'
  return -1
end

if \DontCopy Then do
  if exists(lang'.cmd') then
    'copy' lang'.cmd' InstallDir'\'lang'.cmd'
  else do
    say "  Kunne ikke finde" lang'.cmd'
    return -1
  end

  if exists('af.exe') then
    'copy af.exe' InstallDir
  else do
    say "  Kunne ikke finde af.exe"
    return -1
  end

  if exists('editarc.exe') then
    'copy af.hlp' InstallDir
  else do
    say "   Kunne ikke finde editarc.exe"
    return -1
  end

  if exists('af.hlp') then
    'copy af.hlp' InstallDir
  else do
    say "  Kunne ikke finde af.hlp"
    return -1
  end

  if exists('beta.txt') then
    'copy beta.txt' InstallDir
  else do
    say "  Kunne ikke finde beta.txt"
  end

  if exists('install.txt') then
    'copy install.txt' InstallDir
  else do
    say "  Kunne ikke finde install.txt"
  end

  if exists('whatsnew') then
    'copy whatsnew' InstallDir
  else do
    say "  Kunne ikke finde WhatsNew"
  end

  if exists(archiver.bb2) then
    'copy archiver.bb2' InstallDir
  else do
    say "  Kunne ikke finde ARCHIVER.BB2"
    return -1
  end
end

EAT_ASCII = REVERSE('FFFD'X)


TypeText = 'Archive'
Type     = EAT_ASCII || d2c(length(TypeText)) || '00'x || TypeText
Name     = "Arkiv Skabeloner"
LongName = EAT_ASCII || d2c(length(Name)) || '00'x || Name

if SysFileTree("TEMPLATE", dir, D) <> 0 then do
  Say "  Ikke nok hukommelse!"
  return
end

if \ SysCreateObject( "WPFolder", "Arkiv Folder", "<WP_DESKTOP>","OBJECTID=<AF_FOLDER>;","u")
then do
  Say "  Kunne ikke oprette folder!"
  return
end
else
  say "  Oprettet folder."

rc = SysCreateObject( "WPProgram", "Arkiv Folder", "<AF_FOLDER>","PROGTYPE=PM;EXENAME="InstallDir"\AF.EXE;STARTUPDIR="Installdir";ASSOCTYPE=Archive;ASSOCFILTER=*.lzh,*.zip,*.arc,*.arj,*.rar;OBJECTID=<AF>;","r")
if \rc then do
  Say "  Fejl ved oprettelse af programobjekt for Arkiv Folder!"
  return
end
else
  say "  Oprettet programobjekt for Arkiv Folder."

rc = SysCreateObject( "WPProgram", "Rediger Arkivprogram", "<AF_FOLDER>","PROGTYPE=PM;EXENAME="InstallDir"\EDITARC.EXE;STARTUPDIR="Installdir";ASSOCTYPE=Archive;ASSOCFILTER=*.lzh,*.zip,*.arc,*.arj,*.rar;OBJECTID=<AF_REG>;","r")
if \rc then do
  Say "  Fejl ved oprettelse af programobjekt for Rediger Arkiv Program!"
  return
end
else
  say "  Oprettet programobjekt for Rediger Arkiv Program."

if dir.0 = 0 then do
  if \ SysCreateObject( "WPFolder", "TEMPLATE", InstallDir,"OBJECTID=<AF_TEMPS>;","u")
  then do
    Say "  Fejl ved oprettelse af skabelon folder!"
    say "   Har du en anden AF skabelonfolder?"
    return
  end
  else
    say "  Opretter skabelon folder."
end
else do
  if \ SysSetObjectData(InstallDir"\TEMPLATE", "OBJECTID=<AF_TEMPS>;") then
    Say "  Fejl ved oprettelse af Objekt ID p skabelon folder!"
  else
    say "  Stter objekt ID p skabelonfolder."
end

if SysPutEA( "TEMPLATE", ".LONGNAME", LongName ) <> 0 then
  Say "  Kunne ikke stte .LONGNAME Extended Attribute p skabelon folder!"
else
  say "  Stter .LONGNAME Extended Attribute p skabelon folder."

if \ SysCreateObject( "WPShadow", "Archive templates", "<AF_FOLDER>", "SHADOWID=<AF_TEMPS>;OBJECTID=<AF_TEMPS_SHADOW>;","u" ) then
  Say "  Fejl ved oprettelse af afspejling af skabelonfolder p Arbejdpladsen!"

Call SysOpenObject "<AF_TEMPS>", 1, 1

file = "Archive.Arj"; ID = "<AF_ARJ_TEMPLATE>"
call SetData file ID
file = "Archive.Arc"; ID = "<AF_ARC_TEMPLATE>"
call SetData file ID
file = "Archive.Rar"; ID = "<AF_RAR_TEMPLATE>"
call SetData file ID
file = "Archive.Zip"; ID = "<AF_ZIP_TEMPLATE>"
call SetData file ID
file = "Archive.Lzh"; ID = "<AF_LZH_TEMPLATE>"
call SetData file ID

Say "  Arkiv Folder successfuldt installeret!"
Say
Say "  Du kan nu kopiere ARCHIVER.BB2 filen til et bibliotek i din PATH eller DPATH."
Say
'@pause'

return


SetData:
parse arg file ID
updated = 0
if \ exists( "TEMPLATE\"file ) then do
  say "  Opretterskabelon" file "med objekt ID" ID
  if \ SysCreateObject( "WPDataFile", file, "<AF_TEMPS>","TEMPLATE=YES;TYPE=Archive;OBJECTID="ID";","r")
    then Say "  Fejl ved oprettelse af "file" skabelon! Eksisterer den i forvejen?"
  else updated = 1
end
else do
  say "  Opdaterer skabelon" file "med objekt ID ID" ID
  if \ SysSetObjectData(InstallDir"\TEMPLATE\"file, "OBJECTID="ID";TEMPLATE=YES;TYPE=Archive;") then
    Say "  Fejl ved oprettelse af skabelon data!"
  else updated = 1
end
if updated then do
  if SysPutEA( "TEMPLATE\"file, ".TYPE", Type ) <> 0 then
    say "Kunne ikke stte .TYPE EA"
end
return

exists:
arg filename
if stream( filename, 'c', 'query exists') <> ''
  then return 1
else return 0

