i  
' Wall Effect.
' Blend the input image with a pattern of briks.
' The result is like an image over a wall.
' For a better and faster result use a 24 bit output.

' Input:	1-4-8-24 bit
' Output:	24 bit

' Author:	Andrea Benoni		rev:	1.2


string	inpFile,mskFile,outFile
DevCon	Ibmp,Mbmp,Obmp
RGB	pix
float  	x,y,L

inpFile="testi.bmp"
outFile="testo.bmp"
mskFile="bricks.bmp"

Ibmp=LoadImage(inpFile)
Mbmp=LoadImage(mskFile)
Obmp=CreateImage(Ibmp.Width,Ibmp.Height,24)

For y=0 to Ibmp.Height-1		' for every row
   For x=0 to Ibmp.Width-1		' for every columns
      pix=GetPixel(Mbmp,x,y)		' get a pixel from the pettern
      L=.50+(.50/255*pix.Lum)		' use pattern to modify 50% output lum
      pix=GetPixel(Ibmp,x,y)		' get image pixel
      pix.Red=pix.Red*L   		' modify RGB components
      pix.Green=pix.Green*L
      pix.Blue=pix.Blue*L		
      SetPixel(Obmp,x,y,pix)		' modify output image
   Next x
   if(y%10=0)
      DspWhile("Blending",100/Ibmp.Height*y)
      Preview(Obmp,"Output",5,5,Obmp.Width+10,Obmp.Height+30)	
   endif
Next y
SaveImage(Obmp,outFile)
DspMes("End")

