/*********************  Header Files  *********************/
#include <windows.h>
#include "generic.h"

#ifdef UNREFERENCED_PARAMETER
#undef UNREFERENCED_PARAMETER
#endif
#define UNREFERENCED_PARAMETER(P)          ((void)(P))

#define MODE_NO				2
#define MODE_STRLEN			5


/*********************     Globals    *********************/
static const char    szAbout[] = "About";
static const char 	szMode[MODE_NO][MODE_STRLEN] = {{"Auto"}, {"None"}};
static int				iCurrentMode = -1;


/* Each instance has different values */
static HANDLE			ghInst = NULL;

static void CenterWindowOverScreen(HWND hWnd);
LRESULT CALLBACK AboutProc(HWND hDlg, UINT message,
											WPARAM wParam,	LPARAM lParam);



/* ------------------------------------------------------------------- */
int FAR PASCAL LibMain( HANDLE hLibInst, WORD wDataSeg,
			WORD cbHeapSize, LPSTR lpszCmdLine)
{
	ghInst = hLibInst;

	UNREFERENCED_PARAMETER(wDataSeg);
	UNREFERENCED_PARAMETER(cbHeapSize);
	UNREFERENCED_PARAMETER(lpszCmdLine);

	return (1);
} // LibMain()


/* ------------------------------------------------------------------- */
int FAR PASCAL WEP( int bSystemExit )
{
	UNREFERENCED_PARAMETER(bSystemExit);
	return (1);
} // WEP()




/* Functions available in the language DLLs */

/* ------------------------------------------------------------------- */
UINT APIENTRY GetIndex(UINT16 WCharCode, BOOL fHole)
{
  /*
	  Descriptions:
	  -------------
	  Get the font index in the font file from the native character code.
	  The first font index in the font file should be '0' and the next '1',
	  and so on.

	  Parameters:
	  -----------
	  >> UINT16 WCharCode
	  The native character code, which is represented by and only by
	  normal two character (0-255) codes.

	  >> BOOL fHole
	  Indicator for whether the font file is with certain characters
	  removed in order to save space.

	  Return:
	  -------
	  Return the font index in the font file if successful. Otherwise
	  return (UINT)-1.
  */


  UNREFERENCED_PARAMETER(WCharCode);
  UNREFERENCED_PARAMETER(fHole);

  return ((UINT)-1);
}



/* ------------------------------------------------------------------- */
BOOL APIENTRY GetIndexArr(LPUINT16 WCharCode, UINT cbWCText,
												BOOL fHole, LPUINT lpIndex)
{
  /*
	  Descriptions:
	  -------------
	  Get the font index in the font file from the native character code.
	  The first font index in the font file should be '0' and the next '1',
	  and so on. This is similar to 'GetIndex' function but in array
	  format to speed up the conversion process.

	  Parameters:
	  -----------
	  >> LPUINT16 WCharCode
	  The native character code, which is represented by and only by
	  normal two character (0-255) codes.

	  >> UINT cbWCText
	  No of string

	  >> BOOL fHole
	  Indicator for whether the font file is with certain characters
	  removed in order to save space.

	  >> LPUINT lpIndex
	  Fill with the font indexes to be returned to the calling function.

	  Return:
	  -------
	  Return TRUE is successful, otherwise return FALSE.
  */

  UNREFERENCED_PARAMETER(WCharCode);
  UNREFERENCED_PARAMETER(cbWCText);
  UNREFERENCED_PARAMETER(fHole);
  UNREFERENCED_PARAMETER(lpIndex);

  return (FALSE);
}



/* ------------------------------------------------------------------- */
BOOL APIENTRY AboutBox(HWND hParent)
{
  /*
	  Descriptions:
	  -------------
	  Description about the DLL. Can be used to do special setup required
	  for the DLL. This may be due to multiple options possible. Currently
     not called by MView System.

	  Parameters:
	  -----------
	  >> HWND hParent
	  Window handle of parent

	  Return:
	  -------
	  Return TRUE is successful, otherwise return FALSE.
  */

  BOOL Result;

#if defined(WIN32) || defined(_WIN32)
  Result = DialogBox(ghInst, (LPSTR)szAbout, hParent,	(DLGPROC)AboutProc);
#else
  FARPROC lpfnDlgProc;

  /* Invoke the about dialog procedure */
  lpfnDlgProc = MakeProcInstance((FARPROC)AboutProc, ghInst);
  Result = DialogBox(ghInst, (LPSTR)szAbout, hParent,	(DLGPROC)lpfnDlgProc);
  FreeProcInstance(lpfnDlgProc);
#endif

  return (Result);
}





/* ------------------------------------------------------------------- */
BOOL APIENTRY SetCurrentMode(LPCSTR mode)
{
  /*
	  Descriptions:
	  -------------
	  Set the current mode for the conversion process.

	  Parameters:
	  -----------
	  >> LPCSTR mode
	  Mode in string format in line with the mode string defined in the
     respective encoding initialization file.

	  Return:
	  -------
	  Return TRUE is successful, otherwise return FALSE.
  */

  BOOL Result = FALSE;
  int  i;

  for (i=0; i<MODE_NO; i++) {
	 if (lstrcmpi(mode, szMode[i]) == 0) {
		iCurrentMode = i;
		Result = TRUE;
		break;
	 }
  }

  return (Result);
}




/* ------------------------------------------------------------------- */
BOOL APIENTRY SetupLib(LPCSTR mode, LPCSTR fileName)
{
  /*
	  Descriptions:
	  -------------
	  Initial setup for the library.

	  Parameters:
	  -----------
	  >> LPCSTR mode
	  Mode in string

	  >> LPCSTR fileName
	  Ini file for the DLL

	  Return:
	  -------
	  Return TRUE is successful, otherwise return FALSE.
  */




  UNREFERENCED_PARAMETER(fileName);
  return (SetCurrentMode(mode));
}




/* ------------------------------------------------------------------- */
BOOL APIENTRY ToText(LPCSTR lpszString, UINT cbString,
									LPCSTR frMode, LPCSTR toMode,
									LPSTR lpszASCII,
									LPINT16 cbStr)
{
  /*
	  Descriptions:
	  -------------
	  Convert text from one mode to another mode for example for saving
	  file in different format.

	  Parameters:
	  -----------
	  >> LPCSTR lpszString
	  String to be converted

	  >> INT cbString
	  Length of string to be converted

	  >> LPCSTR frMode
	  From mode string

	  >> LPCSTR toMode
	  To mode string

	  >> LPSTR lpszASCII
	  Converted ASCII string

	  >> LPINT16 cbStr
	  Converted ASCII string length. Also carries the maximum length
     of the space passed in

	  Return:
	  -------
	  Return TRUE is successful, otherwise return FALSE.
  */

  UNREFERENCED_PARAMETER(lpszString);
  UNREFERENCED_PARAMETER(cbString);
  UNREFERENCED_PARAMETER(frMode);
  UNREFERENCED_PARAMETER(toMode);
  UNREFERENCED_PARAMETER(lpszASCII);
  UNREFERENCED_PARAMETER(cbStr);

  return (FALSE);
}





/* ------------------------------------------------------------------- */
int APIENTRY GetNativeText(LPCSTR lpszString, UINT cbString,
											LPSTR lpszASCII, LPUINT16 lpWChars,
											LPINT16 cbStr)
{
  /*
	  Descriptions:
	  -------------
	  Convert text to native mode.

	  Parameters:
	  -----------
	  >> LPCSTR lpszString
	  String to be converted

	  >> INT cbString
	  Length of string to be converted

	  >> LPSTR lpszASCII
	  Converted ASCII string

	  >> LPUINT16 lpWChars
	  Converted Wide characters

	  >> LPINT16 cbStr
	  Converted ASCII string length

	  Return:
	  -------
	  Return no of wide charcaters converted.
  */

  UNREFERENCED_PARAMETER(lpszString);
  UNREFERENCED_PARAMETER(cbString);
  UNREFERENCED_PARAMETER(lpszASCII);
  UNREFERENCED_PARAMETER(lpWChars);
  UNREFERENCED_PARAMETER(cbStr);

  return (0);
}




/* -------------------------------------------------------------- */
BOOL APIENTRY EnableNativeCode(BOOL fEnable)
{

  /*
	  Descriptions:
	  -------------
	  Enable to native mode when TRUE, otherwise restore the previous
     mode before setting the native mode

	  Parameters:
	  -----------
	  >> BOOL fEnable
	  Boolean if true, must set to Native mode, otherwise set back to
     previous mode before the native mode

	  Return:
	  -------
	  Return TRUE if set successfully.
  */

  UNREFERENCED_PARAMETER(fEnable);

  return (TRUE);
}



/* -------------------------------------------------------------- */
static void CenterWindowOverScreen(HWND hWnd)
{
  RECT	rect;
  int		wWidth, wHeight;

  GetWindowRect(hWnd, &rect);

  wWidth =GetSystemMetrics(SM_CXSCREEN);
  wHeight=GetSystemMetrics(SM_CYSCREEN);

  MoveWindow(hWnd,(wWidth/2)- ((rect.right - rect.left)/2),
						(wHeight/2) - ((rect.bottom - rect.top)/2),
						rect.right - rect.left,
						rect.bottom - rect.top,
						FALSE);
}




/* -------------------------------------------------
	About Dialog Proc
	------------------------------------------------- */
LRESULT CALLBACK AboutProc(
		HWND hDlg,           /* window handle of the dialog box */
		UINT message,        /* type of message */
		WPARAM wParam,       /* message-specific information */
		LPARAM lParam)
{
  switch(message) {
  case WM_INITDIALOG:  /* message: initialize dialog box */
		/* Center the dialog */
		CenterWindowOverScreen(hDlg);
		return (TRUE);
  case WM_COMMAND:     /* message: received a command */
		{
		  int wmId, wmEvent;

		  // Message packing of uParam and lParam have changed for Win32,
		  // let us handle the differences in a conditional compilation:
		  #if (defined _WIN32 || defined WIN32)
				 wmId    = LOWORD(wParam);
				 wmEvent = HIWORD(wParam);
		  #else
				wmId    = wParam;
				wmEvent = HIWORD(lParam);
		  #endif


		  switch(wmId) {
		  case IDOK:
			EndDialog(hDlg, TRUE);          /* Exit the dialog */
			break;
		  }

		  UNREFERENCED_PARAMETER(wmEvent);
		}
		break;
  case WM_CLOSE:
		EndDialog(hDlg, TRUE);          /* Exit the dialog */
		break;
  }


  UNREFERENCED_PARAMETER(lParam);
  return (FALSE); /* Didn't process the message */
}  /* AboutProc */





