// --------------------------------------------------------------------------
//  PROJECT     SOLO2
//  MODULE      CRC.C           
//  PURPOSE     32 bit CRC routines
//  COPYRIGHT   (c) Francois Liger, 1994
// --------------------------------------------------------------------------
//  COMMENTS    CRC 32 implementation complies with 
// --------------------------------------------------------------------------

#include <windows.h>
#include "crc.h"

// --------------------------------------------------------------------------
//  module wide definitions
// --------------------------------------------------------------------------

#define CRC_POLYNOMIAL  0xEDB88320L     // standard polynomial constant

DWORD dwCRCTable[256];                  // CRC table (1 KB)

// --------------------------------------------------------------------------
//  FUNCTION    InitializeCRCTable
//  PURPOSE     initializes CRC table with proper values
// --------------------------------------------------------------------------
//  INPUT       void
//
//  OUTPUT      void
// --------------------------------------------------------------------------
//  COMMENTS    
// --------------------------------------------------------------------------

void InitializeCRCTable(void)
{
  int   i, j;
  DWORD dwCRC;

  for(i = 0; i < 256; i++)
  {
    dwCRC = i;
    for(j = 8; j > 0; j--)
    {
      if(dwCRC & 1)
	dwCRC = (dwCRC >> 1) ^ CRC_POLYNOMIAL; 
      else  
	dwCRC >>= 1;
    }
    dwCRCTable[i] = dwCRC;
  }
}

// --------------------------------------------------------------------------
//  FUNCTION    ComputeBufferCRC
//  PURPOSE     compute buffer CRC
// --------------------------------------------------------------------------
//  INPUT       dwCRC           CRC initial value
//              pvBuffer        pointer to buffer to compute CRC for
//              cbBuffer        size of buffer in bytes
//
//  OUTPUT      DWORD           CRC value
// --------------------------------------------------------------------------
//  COMMENTS    this function computes the CRC for a block of data.
//              it accepts a CRC initial value and returns the updated value.
//              uses dwCRCTable array.
// --------------------------------------------------------------------------
#pragma optimize("agt",on)
DWORD ComputeBufferCRC(DWORD dwCRC, void *pvBuffer, DWORD cbBuffer)
{
  PBYTE pb;
  DWORD dwTmp1, dwTmp2;
  UINT  i;

  pb = (PBYTE)pvBuffer;
  /*
  for(i = 0; i < cbBuffer; i++)
  {
    dwTmp1 = (dwCRC >> 8) & 0x00FFFFFFL;
    dwTmp2 = dwCRCTable[((int)dwCRC ^ *pb++) & 0xFF];
    dwCRC  = dwTmp1 ^ dwTmp2;
  }	*/
  {
  DWORD dwFour,dwRest;
  dwFour = cbBuffer/8;
  dwRest = cbBuffer - (dwFour*8);

    for(i = 0; i < dwFour ; i++)
    {
			
      dwCRC  = (dwCRC >> 8) ^ (dwCRCTable[(BYTE)(((BYTE)dwCRC ^ *pb))]);
	  dwCRC  = (dwCRC >> 8) ^ (dwCRCTable[(BYTE)(((BYTE)dwCRC ^ *(pb+1)))]);
	  dwCRC  = (dwCRC >> 8) ^ (dwCRCTable[(BYTE)(((BYTE)dwCRC ^ *(pb+2)))]);
	  dwCRC  = (dwCRC >> 8) ^ (dwCRCTable[(BYTE)(((BYTE)dwCRC ^ *(pb+3)))]);
      
      dwCRC  = (dwCRC >> 8) ^ (dwCRCTable[(BYTE)(((BYTE)dwCRC ^ *(pb+4)))]);
	  dwCRC  = (dwCRC >> 8) ^ (dwCRCTable[(BYTE)(((BYTE)dwCRC ^ *(pb+5)))]);
	  dwCRC  = (dwCRC >> 8) ^ (dwCRCTable[(BYTE)(((BYTE)dwCRC ^ *(pb+6)))]);
	  dwCRC  = (dwCRC >> 8) ^ (dwCRCTable[(BYTE)(((BYTE)dwCRC ^ *(pb+7)))]);

	  pb+=8;

    }	

    for(i = 0; i < dwRest; i++)
    {
      dwTmp1 = (dwCRC >> 8) & 0x00FFFFFFL;
      dwTmp2 = dwCRCTable[((int)dwCRC ^ *pb++) & 0xFF];
      dwCRC  = dwTmp1 ^ dwTmp2;
    }	

  }
  return dwCRC;
}

// --------------------------------------------------------------------------
//  FUNCTION    ComputeFileCRC
//  PURPOSE     compute file CRC
// --------------------------------------------------------------------------
//  INPUT       hf              file handle
//              lpOverlapped    pointer to OVERLAPPED info for async. I/O 
//
//  OUTPUT      DWORD           CRC value
// --------------------------------------------------------------------------
//  COMMENTS    this function computes the CRC for a file. The CRC value is
//              set with all 1's and then every it is inverted once the file
//              hqs been done. This gives a CRC value that corresponds with
//              the values calculated by PKZIP, ARJ...
// --------------------------------------------------------------------------

DWORD ComputeFileCRC(HANDLE hfile, LPOVERLAPPED lpOverlapped)
{
  DWORD dwCRC;
  BYTE  bBuffer[CRC_BUFFER_SIZE];
  DWORD cbBuffer;

  // set CRC with 1's
  dwCRC = 0xFFFFFFFFL;

  // read file and compute CRC
  for(;;)
  {
    ReadFile(hfile, &bBuffer, CRC_BUFFER_SIZE, &cbBuffer, lpOverlapped);
    if(cbBuffer == 0)
      break;

    dwCRC = ComputeBufferCRC(dwCRC, &bBuffer, cbBuffer);
  }
  
  // invert CRC
  return(dwCRC ^= 0xFFFFFFFFL);
}
