#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "crc.h"

DWORD ReadAFile(char * pszBeginPath,char * fn,DWORD dwSizeFile,char * ptr,char * ptrcpy,
					DWORD dwSizeBlock,LPDWORD lpdwCrc,BOOL fList,BOOL fMap)
{
DWORD dwBeg,dwEnd,dwCount;
DWORD dwRead;                 
HANDLE hf;
char szuseFn[MAX_PATH];
  lstrcpy(szuseFn,pszBeginPath);
  lstrcat(szuseFn,fn) ;
  dwCount = 0;
  dwBeg = GetTickCount();
  //hf = _lopen(fn,OF_READ) ;
  {
  //SECURITY_ATTRIBUTES sa;
  hf = CreateFile(szuseFn,GENERIC_READ,0,NULL,OPEN_EXISTING,
                            FILE_ATTRIBUTE_NORMAL | FILE_FLAG_NO_BUFFERING,
                            NULL);
  }

  if (lpdwCrc!=NULL)
    {
      //InitializeCRCTable();
      *lpdwCrc = 0xFFFFFFFFL;
    }

  if (hf !=INVALID_HANDLE_VALUE)
    {
	  if (fMap)
	  {
      HANDLE hFileMap;
	  PCHAR  pchFileBase;

	      hFileMap = CreateFileMapping(hf, NULL, PAGE_READONLY, 0, 0, NULL);
		  pchFileBase = (PCHAR)MapViewOfFile(hFileMap, FILE_MAP_READ, 0, 0, 0);
		  if (lpdwCrc!=NULL)
           *lpdwCrc = ComputeBufferCRC(*lpdwCrc,pchFileBase,dwSizeFile);
		  dwRead=dwSizeFile;
		  dwCount += dwRead;
          UnmapViewOfFile(pchFileBase);
          CloseHandle(hFileMap);
	  }
	  else
      do
       {         
		 dwRead=0;
		 ReadFile(hf,ptr,dwSizeBlock,&dwRead,NULL);
         if (lpdwCrc!=NULL)
           *lpdwCrc = ComputeBufferCRC(*lpdwCrc,ptr,dwRead);
         if (ptrcpy != NULL)
           memcpy(ptrcpy,ptr,dwRead);
         dwCount += dwRead;
      
       } while (dwRead > 0);
      CloseHandle(hf);
    }

  dwEnd = GetTickCount();
  if (!fList)
	   printf("File=%6u Kb/Sec with %9u bytes : %s",dwCount/(1+dwEnd-dwBeg),dwCount,fn);
  else
	  printf("%s,%s,%s,%u",pszBeginPath,szuseFn,fn,dwCount);
  if (lpdwCrc!=NULL)
    {
      *lpdwCrc = ((*lpdwCrc) ^= 0xFFFFFFFFL);
	  if (fList) printf(","); else printf(" ");
      printf("Crc=%lX",*lpdwCrc);
    }
  printf("\n");
  return dwCount;
}

void testmem()
{
DWORD dwSize = 0x10000 * 0x10;
char * base;
char * ptr1;
char * ptr2;
int i;
DWORD dwBeg,dwEnd;
DWORD dwBegA,dwEndA,dwCount;
  base = (char*)malloc(dwSize*2);
  ptr1 = base;
  ptr2 = base + dwSize;
  memset(ptr1,0,dwSize);
  dwCount=0;

  dwBegA = GetTickCount();
  for (i=0;i<10;i++)
	 {
		 dwBeg = GetTickCount();
		 memcpy(ptr2,ptr1,dwSize);
		 dwEnd = GetTickCount();
		 printf(": %6u Kb/Sec with %9u bytes on mem\n",dwSize/(1+dwEnd-dwBeg),dwSize);
		 dwCount += dwSize;
	 }
  dwEndA = GetTickCount();
  printf("= %6u Kb/Sec with %9u bytes on mem\n",dwCount/(1+dwEndA-dwBegA),dwCount);
}

void txthelp()
{
printf("Usage : READFILE                            test memcopy speed\n" \
       "        READFILE filespec                   test file reading (bypass cache)\n" \
       "        READFILE filespec /d                test file reading + copy mem\n" \
       "        READFILE filespec /c                test file reading + compute CRC32\n" \
       "        READFILE filespec /s                test file reading + rec. dir parse\n" \
       "        READFILE filespec /l                test file reading + listing output\n" \

       "\n"\
       " filespec is file specification with joker, by example : *.*\n" \
	   " /d /c /s and /l options can be combined*.*\n"
	   );
}

LPSTR GetOnlyJoker(LPSTR lpFn)
{
LPSTR lpRet=lpFn;
  while ((*lpFn) != '\0')
  {
	  if ((*lpFn)==':') lpRet = lpFn+1;
	  if ((*lpFn)=='\\') lpRet = lpFn+1;
	  lpFn++;
  }
  return lpRet;
}

DWORD DoLoopFile(LPSTR szBeginPath,LPSTR lpFN,LPSTR ptr,LPSTR ptrcpy,
				 DWORD dwSizeBlock,LPDWORD lpdwCrc,
				 BOOL fList,
				 BOOL fRecursive,BOOL fMap)
{
WIN32_FIND_DATA ffblk;
HANDLE hFind;
DWORD dwCount=0;
  if ((hFind = FindFirstFile(lpFN,&ffblk)) == INVALID_HANDLE_VALUE)
	 return 0;
  
		do
		{
		  if (!(ffblk.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			 dwCount += ReadAFile(szBeginPath,ffblk.cFileName,ffblk.nFileSizeLow,
										ptr,ptrcpy,
										dwSizeBlock,lpdwCrc,fList,fMap);
		  else if (fRecursive && (strcmp(ffblk.cFileName,".")!=0) && 
			                     (strcmp(ffblk.cFileName,"..")!=0))
		  {
		  char szNewPath[MAX_PATH];
		  char szNewFN[MAX_PATH];
		    wsprintf(szNewPath,"%s%s\\",(LPSTR)szBeginPath,(LPSTR)ffblk.cFileName);
			wsprintf(szNewFN,"%s%s",(LPSTR)szNewPath,GetOnlyJoker(lpFN));
			DoLoopFile(szNewPath,szNewFN,ptr,ptrcpy,dwSizeBlock,lpdwCrc,fList,fRecursive,fMap); 
		  }

		} while (FindNextFile(hFind,&ffblk));
  FindClose(hFind);
  return dwCount;
}

void main(int argc,char *argv[])
{
DWORD dwBeg,dwEnd,dwCount;
char * ptr;
char * ptrcpy=NULL;
DWORD dwSizeBlock ;
BOOL fDouble=FALSE;
BOOL fCrc=FALSE;
BOOL fList=FALSE;
BOOL fRecursive=FALSE;
BOOL fMap=FALSE;
LPDWORD lpdwCrc=NULL;
DWORD dwCrc;
int i;
char szBeginPath[ MAX_PATH ]; 

  InitializeCRCTable();
  printf("ReadFile 1.10 - http://ourworld.compuserve.com/homepages/gvollant/readfile.htm\n");

  if (argc == 1)
	 {
        txthelp();
		testmem();
		return;
	 }
  dwSizeBlock = 65536L * 16;
  ptr = (char*)malloc(dwSizeBlock) ;
  if (ptr==NULL)
	 return;
  i=2;
  while (argv[i]!=NULL)
    {
	char c=*(argv[i]);
	if ((c=='-') || (c=='/'))
	  c=*(argv[i]+1);
	if ((c>='a') && (c<='z')) c-=0x20;

	 if (((c)) == 'D')
           fDouble=TRUE;
	 if (((c)) == 'S')
           fRecursive=TRUE;
	 if (((c)) == 'C')
           fCrc=TRUE;
	 if (((c)) == 'L')
           fList=TRUE;
	 if (((c)) == 'M')
           fMap=TRUE;
         i++;
    }
             

    if (fCrc)
      lpdwCrc = &dwCrc;

    if (fDouble)
		ptrcpy = (char*)malloc(dwSizeBlock) ;

  if (ptrcpy!=NULL)
	 printf("Use double-buffering\n");

  dwBeg = GetTickCount();

  szBeginPath[0]='\0';
  for (i=0;i<lstrlen(argv[1]);i++)
  {
  char c=*(argv[1]+i);
    if ((c=='\\') || (c==':'))
    {
	  memcpy(szBeginPath,argv[1],i+1);
      szBeginPath[i+1]='\0';
	}
  }
  dwCount = DoLoopFile(szBeginPath,argv[1],ptr,ptrcpy,dwSizeBlock,lpdwCrc,fList,fRecursive,fMap); 

  dwEnd = GetTickCount();
  printf("Average = %6u Kb/Sec with %9u bytes (total : %u msec)\n",
                        dwCount/(1+dwEnd-dwBeg),dwCount,dwEnd-dwBeg);
  free(ptr);
  if (ptrcpy != NULL)
    free(ptrcpy);
}

