/***************************************************************************/
/*   Areas.cmd for use with Aman The 'Advanced Message Area Navigator'     */
/*   Makes the mgroupA.asc file with file descriptions as comments,        */
/*   mgroupA.asc is a listing of all available message areas.              */
/*   Just cut lines from this file to create the other mgroup?.asc files.  */
/***************************************************************************/

areafile = '\adept\system\message_areas'
outfile = 'MgroupA.asc'
call SysFileDelete(outfile)

rc = stream( areafile, 'c', 'OPEN READ' )
rc = stream( outfile, 'c', 'OPEN WRITE' )

  DO WHILE Lines(areafile)
      line = LineIn(areafile)
      parse var line keyword value
  SELECT
      WHEN keyword = 'NUMBER' THEN
       num = strip(value)
      WHEN keyword = 'DESC' THEN
       desc = strip(value)
      WHEN keyword = 'AREAEND' THEN
       Call LineOut outfile, Left(num,6)'- 'desc
      OTHERWISE
       NOP
    END
  END

rc = stream( areafile, 'c', 'CLOSE' )
rc = stream( outfile, 'c', 'CLOSE' )
