/* BackTalk simple installation, you will need UNZIP.EXE in your path
 * or current directory.  It will use its execution directory files, NOT
 * the initial one.  Samuel Audet <guardia@cam.org> */

/* Load necessary RexxUtil functions */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs' 
call SysLoadFuncs

parse arg parm

/* Help screen */

if parm = '' then do
   say 'Usage:  INSTALL <target directory>'
   say 'ie:  install g:\backtalk'
   exit
end

/* Finding UNZIP.EXE */

unzipper = SysSearchPath('PATH', 'UNZIP.EXE')
if rc = '' then do
   say 'UNZIP.EXE not found.'
   exit
end

/* Finding and switching execution directory */

parse source . . sourcename
sourcedir = filespec('D', sourcename)||filespec('P', sourcename)
sourcedir = left(sourcedir, length(sourcedir)-1)
call directory sourcedir

/* Queries */

Call CharOut, 'Install BackTalk in ' || parm || ' ? '
AKey = SysGetKey( 'ECHO' )
If AKey <> 'y' & AKey <> 'Y' Then Exit

say

Call CharOut, 'Install flip (necessary for MR/2 ICE)? '
AKey = SysGetKey( 'ECHO' )
If AKey = 'y' | AKey = 'Y' Then mr2 = 1

/* Making specified directory */

if SysMkDir(parm) > 0 or = 5 then do
  say 'Failed creating directory'
  exit
end

/* Unzipping the files */

unzipper' rsynth22 -d 'parm'\RSynth'
unzipper' rexx -d 'parm'\REXX'
unzipper' uptime -d 'parm'\Uptime'
'copy readme 'parm
'copy 'parm'\rexx\speechq.cmd 'parm'\rsynth'
'copy 'parm'\rexx\spkstats.cmd 'parm'\uptime'
if mr2 = 1 then unzipper' flip1os2 -d 'parm'\flip'

/* Creating WPS Objects */

say

classname='WPFolder'
title='BackTalk'
location='<WP_DESKTOP>'
setup='OBJECTID=<BACK_TALK>;'||,
      'ICONFILE='sourcedir'\backfld.ico;'||,
      'ICONNFILE=1,'sourcedir'\backfldn.ico;'
Call BldObj

classname='WPProgram'
title='Speech Queue'
location='<BACK_TALK>'
setup='OBJECTID=<SPCH_QUEUE>;'||,
      'EXENAME='parm'\rsynth\speechq.cmd;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='Stop Speech'
location='<BACK_TALK>'
setup='OBJECTID=<STOP_SPCH>;'||,
      'EXENAME='parm'\rexx\spchcmd.cmd;'||,
      'PARAMETERS=COMMAND_END;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='Mute Speech'
location='<BACK_TALK>'
setup='OBJECTID=<MUTE_SPCH>;'||,
      'EXENAME='parm'\rexx\spchcmd.cmd;'||,
      'PARAMETERS=COMMAND_MUTE;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='Unmute Speech'
location='<BACK_TALK>'
setup='OBJECTID=<UNMUTE_SPCH>;'||,
      'EXENAME='parm'\rexx\spchcmd.cmd;'||,
      'PARAMETERS=COMMAND_UNMUTE;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='Discard Messages'
location='<BACK_TALK>'
setup='OBJECTID=<DISCARD_SPCH>;'||,
      'EXENAME='parm'\rexx\spchcmd.cmd;'||,
      'PARAMETERS=COMMAND_DISCARD;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='Say Queued'
location='<BACK_TALK>'
setup='OBJECTID=<QUEUED_SPCH>;'||,
      'EXENAME='parm'\rexx\spchcmd.cmd;'||,
      'PARAMETERS=COMMAND_NUMQUEUED;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='Say Something'
location='<BACK_TALK>'
setup='OBJECTID=<SPEECH>;'||,
      'EXENAME='parm'\rexx\spchsnd.cmd;'||,
      'PARAMETERS=[Enter text to say:];'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='System Stats'
location='<BACK_TALK>'
setup='OBJECTID=<SYS_SPCH>;'||,
      'EXENAME='parm'\uptime\spkstats.cmd;'||,
      'PARAMETERS=COMMAND_END;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

say 'Creating Shadow: README'
if SysCreateShadow(parm'\readme','<BACK_TALK>') = 0 then
   say 'Error: Object not created.'

Exit

/* Build Object */

BldObj:
   say 'Creating Object: 'title
   result = SysCreateObject(classname, title, location, setup, 'R')
   If result > 1 Then say 'Error: Object not created. Return code='result
Return
