/* Time Speech - part of the BackTalk project - not even close to realtime */

lapmins = 5                /* Defines the lap between time speech in       */
                           /* minutes, decimal allowed if sec has trunc.   */
lapsecs=trunc(lapmins*60)  /* Replace the 'mins * 60' if you want to       */
                           /* specify in seconds directly.                 */
time = "civil"             /* Specify 'civil' for am, pm times and any     */
                           /* other values for international, time.        */

/* Give some visual information */

if time = 'civil' then
   say 'Speaking civil time.'
else
   say 'Speaking international time.'
say 'laps time between spoken time:' lapmins 'minutes.'

call rxfuncadd 'SysSleep','RexxUtil','SysSleep'

queuename='REXXSPEECH'
rc = rxqueue('Set', queuename)

if time = "civil" then do forever  /* Parses time() value in civil mode and changes */
   current = time('C')             /* 'am' to 'AY M' for Rsynth to pronounce it correctly. */
   ampos=pos('am',current)
   if ampos > 0 then do
      current = delstr(current,ampos)
      current = current "AY M"
   end
   queue "It is" current
   call syssleep lapsecs
end                       /* Parses international time values into variables */
else do forever           /* and speaks them. */
   parse value time() with hours ':' mins ':' secs
   queue "It is" hours "hundred hours" mins "minutes and" secs "seconds"
   call syssleep lapsecs           /* Waits some time before speaking again. */
end
