/* REXX *********************************************/
/* Frame for your Rexx program. Verify please!      */
/* Program name:                                    */
/* Function    :                                    */
/* Syntax      :                                    */
/* Changes     :                                    */
/*                                                  */
/* Made use of GREED.  15 Mar 1996 / 10:58:16   JRK */
/****************************************************/
Parse Arg arg1, arg2

/*==============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

/*==========(Initialize RexxUtil support)===========*/
If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

destDir = CpyGreed()

/*================(End this program)================*/
Exit

CLEARUP:
  Say 'GREED001E - Break, Failure or Syntax Error'
Exit

CpyGreed: Procedure

greedDir = "F:\DEVELOP\VISPROC\PROJECTS\GREED\"
trg.1  = greedDir"GREED.FNC"
trg.2  = greedDir"GREED.HLP"
trg.3  = greedDir"GREED.ICO"
trg.4  = greedDir"GREED.INF"
trg.5  = greedDir"GREED.MSG"
trg.6  = greedDir"GREEDX.FNC"
trg.7  = greedDir"HTML.FNC"
trg.8  = greedDir"GLOBAL.FNC"
trg.9  = greedDir"TSOISPF.FNC"
trg.10 = greedDir"RUN.EXE"
trg.11  = greedDir"WAKuM.ICO"
funwDir  = "F:\DEVELOP\VISPRORX\PROJECTS\INIWRITE\"
trg.12 = funwDir"TemplEd.ICO"
trg.13 = funwDir"RUN.EXE"
brwseDir = "F:\DEVELOP\VISPROC\PROJECTS\BROWSEG\"
trg.14 = brwseDir"PMBROWSE.ICO"
trg.15 = brwseDir"PMBROWSE.HLP"
trg.16 = brwseDir"RUN.EXE"
ftpdDir = "F:\DEVELOP\VISPROC\PROJECTS\FTPDEF\"
trg.17 = ftpdDir"FTPDEF.HLP"
trg.18 = ftpdDir"FTPDEF.INF"
trg.19 = ftpdDir"RUN.EXE"
gtsDir ="F:\DEVELOP\VISPRORX\PROJECTS\GREEDX\"
trg.20 = gtsDir"GREEDX.HLP"
trg.21 = gtsDir"GREEDX.INF"
trg.22 = gtsDir"GREEDX.ICO"
trg.23 = gtsDir"RUN.EXE"
insDir ="F:\DEVELOP\VISPRORX\PROJECTS\INSTALL\"
trg.24 = insDir"INSTALL.ICO"
trg.25 = insDir"CPYGREED.CMD"
trg.26 = insDir"INSTALL.DOC"
/*---(Installation program - not pack it!)---*/
trg.27 = insDir"SAVEPRE.CMD"
trg.28 = insDir"DELSAVES.CMD"
trg.29 = insDir"RESTOREP.CMD"
trg.30 = insDir"RUN.EXE"
trg.31 = insDir"INSTALL.HLP"
trg.32 = insDir"INSTALL.DAT"
trg.0 = 32

tempDir = MadeDir("F:\NFNFUZIP\INSGREED\TEMP")
If Datatype(tempDir) = 'NUM' Then Do 
  Say 'Temporary directory not allocated. RC='tempDir
  Return
End
Else Do
  Say
  Say tempDir
  Call CharOut ,'Is it OK (y/n)? '
  response = CharIn(,,1)
  If Translate(response) \= 'Y' Then Return 1
End 
temp.1  = tempDir"\Greed.FNC"
temp.2  = tempDir"\Greed.HLP"
temp.3  = tempDir"\Greed.ICO"
temp.4  = tempDir"\Greed.INF"
temp.5  = tempDir"\Greed.MSG"
temp.6  = tempDir"\GreedX.FNC"
temp.7  = tempDir"\HTML.FNC"
temp.8  = tempDir"\Global.FNC"
temp.9  = tempDir"\TSOISPF.FNC"
temp.10  = tempDir"\Greed.EXE"
temp.11 = tempDir"\WAKuM.ICO"
temp.12 = tempDir"\TemplEd.ICO"
temp.13 = tempDir"\TemplEd.EXE"
temp.14 = tempDir"\PMBROWSE.ICO"
temp.15 = tempDir"\PMBROWSE.HLP"
temp.16 = tempDir"\PMBROWSE.EXE"
temp.17 = tempDir"\FtpDef.HLP"
temp.18 = tempDir"\FtpDef.INF"
temp.19 = tempDir"\FtpDef.EXE"
temp.20 = tempDir"\GreedX.hlp"
temp.21 = tempDir"\GreedX.Inf"
temp.22 = tempDir"\GreedX.ICO"
temp.23 = tempDir"\GreedX.EXE"
temp.24 = tempDir"\INSTALL.ICO"
temp.25 = tempDir"\CPYGREED.CMD"
temp.26 = tempDir"\INSTALL.DOC"
temp.27 = tempDir"\SAVEPRE.CMD"
temp.28 = tempDir"\DELSAVES.CMD"
temp.29 = tempDir"\RESTOREP.CMD"
temp.30 = tempDir"\INSTALL.EXE"
temp.31 = tempDir"\INSTALL.HLP"
temp.32 = tempDir"\INSTALL.DAT"

temp.0 = trg.0 

do i = 1 to trg.0
  "COPY" trg.i temp.i
  If rc > 0 Then Return 1
End
/* "lxLite /y" tempDir"\*.exe" */

destDir = "F:\NFNFUZIP\INSGREED"
dest.1  = destDir"\Greed.FN@"
dest.2  = destDir"\Greed.HL@"
dest.3  = destDir"\Greed.IC@"
dest.4  = destDir"\Greed.IN@"
dest.5  = destDir"\Greed.MS@"
dest.6  = destDir"\GreedX.FN@"
dest.7  = destDir"\HTML.FN@"
dest.8  = destDir"\Global.FN@"
dest.9  = destDir"\TSOISPF.FN@"
dest.10 = destDir"\Greed.EX@"
dest.11 = destDir"\WAKuM.IC@"
dest.12 = destDir"\TemplEd.IC@"
dest.13 = destDir"\TemplEd.EX@"
dest.14 = destDir"\PMBROWSE.IC@"
dest.15 = destDir"\PMBROWSE.HL@"
dest.16 = destDir"\PMBROWSE.EX@"
dest.17 = destDir"\FtpDef.HL@"
dest.18 = destDir"\FtpDef.IN@"
dest.19 = destDir"\FtpDef.EX@"
dest.20 = destDir"\GreedX.HL@"
dest.21 = destDir"\GreedX.IN@"
dest.22 = destDir"\GreedX.IC@"
dest.23 = destDir"\GreedX.EX@"
dest.24 = destDir"\INSTALL.IC@"
dest.25 = destDir"\CPYGREED.CM@"
dest.26 = destDir"\INSTALL.DO@"
/*---(Installation program - not pack it!)---*/
dest.27 = destDir"\SAVEPRE.CMD"
dest.28 = destDir"\DELSAVES.CMD"
dest.29 = destDir"\RESTOREP.CMD"
dest.30 = destDir"\INSTALL.EXE"
dest.31 = destDir"\INSTALL.HLP"
dest.32 = destDir"\INSTALL.DAT"

dest.0 = temp.0

/* PACK is a part of CSET++. If you not have it,   */
/* use COPY instead of PACK. It haven't any affect */ 
/* for Install-Routine!                            */
do i = 1 to temp.0 - 6
  "PACK" temp.i dest.i
  If rc > 0 Then Return 1
End

/*---(Installation program - not pack it!)---*/
do i = temp.0 - 5 to temp.0 
  "COPY" temp.i dest.i
  If rc > 0 Then Return 1
End

"DEL" tempDir"\*.*"
"RD" tempDir

Return destDir

/*+++++++++++++++++++++++++++++++++++++++++++*/
MadeDir: Procedure 

Arg dest_path

dest_path = Strip(dest_path,,'\')
rc = SysFileTree( dest_path, fileList, 'DO' )
If fileList.0 = 0 Then Do
  Parse Var dest_path new_path '\' rest 
  Do Until rest = '' 
    Parse Var rest qf '\' rest
    new_path = new_path||'\'||qf
    rc = SysMkDir( new_path )
    If rc > 0 & rc \= 5 Then Return rc
  End
End

Return dest_path
