.. Some optimization procedures

function simplex1 (A,b,z)
## Minimize z.x=b under the conditions A.x=b.
	{Res,ri,ci,det}=lu(A);
	c1=nonzeros(ci); c2=nonzeros(ci==0);
	if cols(c1)!=rows(A); error("Rank of A to low"); endif;
	B=A[:,c1];
	{x,f}=simplex(B\A[:,c2],B\b,z[c2]-z[c1].A[:,c2]);
	if f==0;
		xr=zeros(size(z));
		xr[:,c2]=x';
		xr[c1]=(B\(b-A[:,c2].x))';
		endif;
	return {xr',f};
endfunction

.. EOF
