/* acl32.h
 *
 * Author:  Kai Uwe Rommel <rommel@ars.muc.de>
 * Created: Mon Aug 08 1994
 */
 
/* $Id: acl32.h,v 2.1 1994/08/09 14:23:55 ak Exp $ */

/*
 * $Log: acl32.h,v $
 * Revision 2.1  1994/08/09  14:23:55  ak
 * Added Kai Uwe Rommels ACL implementation.
 * 
 */

#ifndef _ACL32_H
#define _ACL32_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
/* bin, set by load and text2bin, used by bin2text and store */
  char * data;			/* API buffer */
  unsigned short datalen;	/* actual size of .. */
/* text, set by bin2text, used by text2bin */
  char *text;			/* ACL description */
  int textlen;			/* actual size of .. */
/* info, set by bin2text */
  char *name;			/* resource name */
}
ACL;

ACL *acl_alloc(void);
void acl_free(ACL *acl);
int  acl_load(ACL *acl, char *server, char *resource);
int  acl_store(ACL *acl, char *server, char *resource);
int  acl_bin2text(ACL *acl);
int  acl_text2bin(ACL *acl);

#ifdef __cplusplus
}
#endif

#endif /* _ACL32_H */

/* end of acl32.h */
