
#define SECTNUMTYPE  unsigned long

int initreadwrite(unsigned short hVPB, MOUNT_RECORD *mr);
/* This function will map the volume hVPB to a staterec.  The
   staterec is then the magic cookie used to read/write the device

   returns nonzero on failure.
*/

int closereadwrite(MOUNT_RECORD *mr);
/* This function is called to flush all writes to the device and close
   the device.  The staterecord is marked as invalid.
*/

int readabsolutesector(MOUNT_RECORD *mr, SECTNUMTYPE sect, char *buf);


int readsects(MOUNT_RECORD *mr, SECTNUMTYPE sect, int num, char *buf);
/*
   Given staterec, starting sector sect, number of sectors num, and a buffer,
   either buf is filled with the sectors read, and the number read is returned,
   or no sectors are read and a negative number is returned.  

   NOTE: you can get fewer sectors than you asked for!
*/

int writesects(MOUNT_RECORD *mr, SECTNUMTYPE sect, int num, char *buf);
/* 
   Similar to readsects. Should be used for anything other than system
   stuff.  After this has been called mr->sr.maxwritesbeforemrflush or more
   times, it will call syncmountrecord(mr), which SHOULD USE writesectsunbuf()
   for its writes.
*/
 
int writesectsunbuf(MOUNT_RECORD *mr, SECTNUMTYPE sect, int num, char *buf);
/*
   Similar to writesects, except that this will not call syncmountrecord or
   update the numwritten fields of the status record.  This is what to call
   to do things like write the volume bitmap, volinfo, etc.
*/

int syncmountrecord(MOUNT_RECORD *mr);