#include "../defs.h"
#include "../errors.h"
#include "../Lock/lock.h"
#include "../mountrec.h"
#include "../btree/btree.h"
#include "../Volume/volbmap.h"
#include "../LibFuncs/macreadwrite.h"
#include "../Times/mac_time.h"
#include "catalog.h"
#include "catalog_local.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#define NODEBUG

int mopenroot(MOUNT_RECORD *mr,
	      CATALOG_RECORD *cr,
	      char *name)
{
  int rc;
  LONGWORD foundpid;
  char fnbuf[MAXFNLENGTH];

  rc=GetCatalogRecord(mr,ROOTPID,BIGESTFN,cr,&foundpid,fnbuf);

  if (rc && rc!=BT_FOUNDLESS)
    return rc;
  else {
    if ((foundpid!=ROOTPID))
      return OPENROOTNOSUCHFILE;
  }

  if (name!=NULL)
    strcpy(name,fnbuf);

  return 0;
}


int validfolderid(MOUNT_RECORD *mr, LONGWORD dirid)
{
  CATALOG_RECORD cr;
  LONGWORD foundpid;
  char foundname[MAXFNLENGTH];
  int rc;

  rc=GetCatalogRecord(mr,dirid,BIGESTFN, &cr, &foundpid, foundname);

  if (rc && rc!=BT_FOUNDLESS)
    return rc;
  else {
    if ((foundpid!=dirid)) { 
      return NOSUCHFOLDER;
    } else { 
      if (cr.cdrType==CDR_FTHREAD) {
	return NOSUCHFOLDER;
      } else {
	return 0;
      }
    }
  }
}
    



int filliconpos(LONGWORD id, WORD dirvalence, BYTE *finder)
{
  WORD iconx, icony;
  BYTE *t;

  iconx=((WORD)id)&0xffff;

  iconx=iconx%(dirvalence+EXTRAICONROWS*ICONSHOR);

  icony=(iconx/ICONSHOR)*ICONYPELS;

  iconx=(iconx%ICONSHOR)*ICONXPELS;
  
  reorderwordintobuf(finder,10,icony);

  reorderwordintobuf(finder,12,iconx);
  
  return 0;

}


#define setcreator(finderinfoptr,creatorptr)                          \
         memcpy(&((finderinfoptr)[4]),creatorptr, 4)           

#define settype(finderinfoptr, creatorptr)    \
         memcpy(finderinfoptr, creatorptr, 4)
    
  


int mcreatefile(MOUNT_RECORD *mr,
		CATALOG_RECORD *parentcr,
		char *fn,
		CATALOG_RECORD *cr)
{
  int rc;
  int blocks;
  EXTENT_DESCRIPTOR ed;
  int i;
  LONGWORD foundpid, overwriteid;
  CATALOG_RECORD foundcr;
  
  
  if (parentcr->cdrType!=CDR_DIR)
    return CANTCREATEINNONDIR;

  overwriteid=0;

  if (!GetCatalogRecord(mr,
			parentcr->U.cdrDirRec.dirDirID,
			fn,
			&foundcr,
			&foundpid,
			NULL)) {
    if (foundcr.cdrType!=CDR_FILE)
      return CANTOVERWRITEDIR;

/* Delete Space */
    if ((rc=mtruncatefile(mr, &foundcr, 0)))
      return rc;

    overwriteid=foundcr.U.cdrFilRec.filFlNum;
  }
      

  cr->cdrType=CDR_FILE;
  cr->cdrResrv2=0;

  


  if ((rc=alloccontiguousspace(mr,
			       mr->vib.ClpSiz/mr->vib.AlBlkSiz,
			       &ed))<0) {
    return rc;
  }

  blocks=ed.length;

  if (blocks==0) {
    return MACCREATEFILENOSPACE;
  }

  cr->lastgrowsize=blocks;

  cr->U.cdrFilRec.filFlags=STDFILEFLAGS;
  cr->U.cdrFilRec.filTyp=STDFILETYPE;

  memcpy(cr->U.cdrFilRec.filUsrWds, STDFILEFINDERINFO, 16);

  lock(mr->viblock);

  filliconpos(mr->vib.NxtCNID,
	      parentcr->U.cdrDirRec.dirVal + 1,  
	      cr->U.cdrFilRec.filUsrWds);

  if (overwriteid==0) {
    cr->U.cdrFilRec.filFlNum=mr->vib.NxtCNID; ++(mr->vib.NxtCNID);
  } else {
    cr->U.cdrFilRec.filFlNum=overwriteid;
  }
  cr->U.cdrFilRec.filStBlk=ed.first;
  cr->U.cdrFilRec.filLgLen=0;
  cr->U.cdrFilRec.filPyLen=blocks*mr->vib.AlBlkSiz;
  cr->U.cdrFilRec.filRLgLen=0;
  cr->U.cdrFilRec.filRPyLen=0;
  cr->U.cdrFilRec.filCrDat=now();
  cr->U.cdrFilRec.filMdDat=now();
  cr->U.cdrFilRec.filBkDat=never();
  memcpy(cr->U.cdrFilRec.filFndrInfo, STDFILEFINDERINFO2,16);
  cr->U.cdrFilRec.filClpSize=mr->vib.ClpSiz;
  cr->U.cdrFilRec.filExtRec[0].first=ed.first;
  cr->U.cdrFilRec.filExtRec[0].length=ed.length;
  cr->U.cdrFilRec.filExtRec[1].first=0;
  cr->U.cdrFilRec.filExtRec[1].length=0;
  cr->U.cdrFilRec.filExtRec[2].first=0;
  cr->U.cdrFilRec.filExtRec[2].length=0;
  for (i=0;i<3;i++)
    cr->U.cdrFilRec.filRExtRec[i].first=cr->U.cdrFilRec.filRExtRec[i].length=0;
  cr->U.cdrFilRec.filResrv=STDFILERESERVED;

  unlock(mr->viblock);

  rc=PutCatalogRecord(mr, parentcr->U.cdrDirRec.dirDirID, fn, cr);

  if (rc) {
    if (freecontiguousspace(mr, &ed))
      return MACCREATEFILECANTDEALLOC;
    else
      return rc;
  }

  ++(parentcr->U.cdrDirRec.dirVal);
  parentcr->U.cdrDirRec.dirMdDat=now();

  lock(mr->viblock);
  ++(mr->vib.FilCnt);

  if (parentcr->U.cdrDirRec.dirDirID==ROOTID) {
    ++(mr->vib.NmFls);
  }
  unlock(mr->viblock);

  return 0;
  
}

int mcreatefolder(MOUNT_RECORD *mr,
		  CATALOG_RECORD *parcr,
		  char *foldername,
		  CATALOG_RECORD *cr)
{
  int rc, rc2;
  CATALOG_RECORD ltr,tempcr;
  int i;
  LONGWORD foundpid;


  if (parcr->cdrType!=CDR_DIR)
    return CANTCREATEINNONDIR;

  if (!GetCatalogRecord(mr,
			parcr->U.cdrDirRec.dirDirID,
			foldername,
			&tempcr,
			&foundpid,
			NULL))
    return CREATEFOLDWOULDOVERWRITE;

  cr->cdrType=CDR_DIR;
  cr->cdrResrv2=0;

  cr->U.cdrDirRec.dirFlags=STDDIRFLAGS;
  cr->U.cdrDirRec.dirVal=0;

  lock(mr->viblock);

  cr->U.cdrDirRec.dirDirID=mr->vib.NxtCNID; ++(mr->vib.NxtCNID);
  
  unlock(mr->viblock);

  cr->U.cdrDirRec.dirCrDat=now();
  cr->U.cdrDirRec.dirMdDat=now();
  cr->U.cdrDirRec.dirBkDat=never();
  memcpy(cr->U.cdrDirRec.dirUsrInfo, STDDIRFINDERINFO,16);

  filliconpos(cr->U.cdrDirRec.dirDirID, 
	      parcr->U.cdrDirRec.dirVal + 1,  
	      cr->U.cdrDirRec.dirUsrInfo);


  memcpy(cr->U.cdrDirRec.dirFndrInfo, STDDIRFINDERINFO2, 16);

  for(i=0;i<4;i++)
    cr->U.cdrDirRec.dirResrv[i]=0;

  rc=PutCatalogRecord(mr, parcr->U.cdrDirRec.dirDirID, foldername, cr);

  if (rc) {
    return rc;
  }

  ltr.cdrType=CDR_DTHREAD;
  ltr.cdrResrv2=0;
  
  ltr.U.cdrThdRec.thdResrv[0]=0;
  ltr.U.cdrThdRec.thdResrv[1]=0;
  ltr.U.cdrThdRec.thdParID=parcr->U.cdrDirRec.dirDirID;
  strcpy(ltr.U.cdrThdRec.thdCName, foldername);

  rc=PutCatalogRecord(mr, cr->U.cdrDirRec.dirDirID, SMALLESTFN, &ltr);

  if (rc) {
    rc2=DelCatalogRecord(mr, parcr->U.cdrDirRec.dirDirID, foldername);
    if (rc2) {
      return MACCREATEFOLDCANTDEALLOC;
    } else {
      return rc;
    }
  }

  ++(parcr->U.cdrDirRec.dirVal);

  parcr->U.cdrDirRec.dirMdDat=now();
  
  lock(mr->viblock);

  ++(mr->vib.DirCnt);

  if (parcr->U.cdrDirRec.dirDirID==ROOTID) {
    ++(mr->vib.NmRtDirs);
  }

  unlock(mr->viblock);

  return 0;
}  


int mmove(MOUNT_RECORD *mr,
	  CATALOG_RECORD *oldparcr,
	  char *name,
	  CATALOG_RECORD *cr,
	  CATALOG_RECORD *newparcr,
	  char *newname)
{


  if (strlen(newname)>MAXFNLENGTH)
    return NAMETOOLONG;

  switch (cr->cdrType) {
  case CDR_FILE:
    return mmovefile(mr, oldparcr, name, cr, newparcr, newname);
  case CDR_DIR:
    return mmovefolder(mr, oldparcr, name, cr, newparcr, newname);
  default:
    return MOVENOTFILEORFOLDER;
  }

  return -1;

}


int mmovefile(MOUNT_RECORD *mr,
	      CATALOG_RECORD  *oldparcr,
	      char *name,
	      CATALOG_RECORD *cr,
	      CATALOG_RECORD *newparcr,
	      char *newname)
{
  int rc;
  CATALOG_RECORD tempcr;
  LONGWORD foundpid;

  if (cr->cdrType!=CDR_FILE)
    return MOVENOTFILE;

  if (!GetCatalogRecord(mr, 
			newparcr->U.cdrDirRec.dirDirID, 
			newname, 
			&tempcr, 
			&foundpid, 
			NULL))
    return MOVEWOULDOVERWRITE;

  if ((rc=PutCatalogRecord(mr, 
			   newparcr->U.cdrDirRec.dirDirID,
			   newname, 
			   cr)))
    return MOVECANTPUTNEWFILEREC;

  ++(newparcr->U.cdrDirRec.dirVal);
  newparcr->U.cdrDirRec.dirMdDat=now();

  if ((rc=DelCatalogRecord(mr, 
			   oldparcr->U.cdrDirRec.dirDirID,
			   name)))
    return MOVECANTDELFILEREC;

  --(oldparcr->U.cdrDirRec.dirVal);
  oldparcr->U.cdrDirRec.dirMdDat=now();

  lock(mr->viblock);

  if (oldparcr->U.cdrDirRec.dirDirID==ROOTID) {
    --(mr->vib.NmFls);
  }

  if (newparcr->U.cdrDirRec.dirDirID==ROOTID) {
    ++(mr->vib.NmFls);
  }

  unlock(mr->viblock);

  return 0;

}


int ismoveparentintochild(MOUNT_RECORD *mr,
			  LONGWORD dirid,
			  LONGWORD newpid)
{
  LONGWORD testpid, foundpid;
  CATALOG_RECORD tcr;
  int rc;

  testpid=newpid;

  if (newpid==dirid)
    return MOVEPARENTINTOCHILD;

  while (testpid!=ROOTID) {
    if ((rc=GetCatalogRecord(mr,
			     testpid,
			     SMALLESTFN,
			     &tcr,
			     &foundpid,
			     NULL))) 
      return rc;

    if ((foundpid!=testpid)||(tcr.cdrType!=CDR_DTHREAD))
      return CANTFINDTHDREC;
    
    if ((tcr.U.cdrThdRec.thdParID==dirid))
      return MOVEPARENTINTOCHILD;

    testpid=tcr.U.cdrThdRec.thdParID;
  }

  return 0;

}

  

int mmovefolder(MOUNT_RECORD *mr,
		CATALOG_RECORD *oldparcr,
		char *name,
		CATALOG_RECORD *cr,
		CATALOG_RECORD *newparcr,
		char *newname)
{
  int rc;
  CATALOG_RECORD tcr;
  LONGWORD foundpid;
  char tn[MAXFNLENGTH];
  int errorstage;


  errorstage=0;

  if (strlen(newname)>MAXFNLENGTH)
    return NAMETOOLONG;

  if (cr->cdrType!=CDR_DIR)
    return MOVENOTFOLDER;

  if (!GetCatalogRecord(mr,
			newparcr->U.cdrDirRec.dirDirID,
			newname,
			&tcr,
			&foundpid,
			NULL))
    return MOVEWOULDOVERWRITE;


  if ((rc=ismoveparentintochild(mr, 
				cr->U.cdrDirRec.dirDirID, 
				newparcr->U.cdrDirRec.dirDirID)))
    return rc;


/* Get the Thread Record */

  if ((rc=GetCatalogRecord(mr,
			   cr->U.cdrDirRec.dirDirID,
			   SMALLESTFN,
			   &tcr,
			   &foundpid,
			   tn))) 
    return rc;

  if (foundpid!=cr->U.cdrDirRec.dirDirID || tcr.cdrType!=CDR_DTHREAD) {
    return MOVENOTHDREC;
  }

/* Copy the new name and pid into the thread record */

  strcpy(tcr.U.cdrThdRec.thdCName, newname);
  tcr.U.cdrThdRec.thdParID=newparcr->U.cdrDirRec.dirDirID;

  rc=0;

/* Place the New directory record */

  rc=PutCatalogRecord(mr, 
		      newparcr->U.cdrDirRec.dirDirID,
		      newname, 
		      cr);

/* Modify the Thread Record */

  if (rc) {
    errorstage=1;
  } else {
    rc=PutCatalogRecord(mr, cr->U.cdrDirRec.dirDirID, tn, &tcr);
  }

/* Remove the old folder record */
  
  if (rc) {
    errorstage=2;
  } else {
    rc=DelCatalogRecord(mr, newparcr->U.cdrDirRec.dirDirID, name);
  }

  if (rc) 
    errorstage=3;

  switch (errorstage) {
  case 0:

    ++(newparcr->U.cdrDirRec.dirVal);

    newparcr->U.cdrDirRec.dirMdDat=now();

    --(oldparcr->U.cdrDirRec.dirVal);

    oldparcr->U.cdrDirRec.dirMdDat=now();

    lock(mr->viblock);

    if (oldparcr->U.cdrDirRec.dirDirID==ROOTID) {
      --(mr->vib.NmRtDirs);
    }
    
    if (newparcr->U.cdrDirRec.dirDirID==ROOTID) {
      ++(mr->vib.NmRtDirs);
    }
    unlock(mr->viblock);

    return 0;
  case 1:
    return MOVECANTPUTNEWFOLDREC;
  case 2:
    if (DelCatalogRecord(mr, newparcr->U.cdrDirRec.dirDirID, newname))
      return MOVEFAILDURINGFAIL;
    else
      return MOVECANTMODIFYTHDREC;
  case 3:
    rc=DelCatalogRecord(mr, newparcr->U.cdrDirRec.dirDirID, newname);
    strcpy(tcr.U.cdrThdRec.thdCName, name);
    tcr.U.cdrThdRec.thdParID=oldparcr->U.cdrDirRec.dirDirID;
    rc|=PutCatalogRecord(mr, cr->U.cdrDirRec.dirDirID, tn, &tcr);
    if (rc)
      return MOVEFAILDURINGFAIL;
    else
      return MOVECANTMODIFYTHDREC;
  default:
    return MOVEINTERNALERROR;
  }

  return MOVEINTERNALERROR;

}

  
int mdeletefile(MOUNT_RECORD *mr,
		CATALOG_RECORD *parcr,
		char *fn,
		CATALOG_RECORD *cr)
{
  int rc, numeds;
  EXTENT_DESCRIPTOR *edlist;

  if ((rc=validfolderid(mr, parcr->U.cdrDirRec.dirDirID)))
    return rc;

  if (cr->cdrType!=CDR_FILE)
    return MACDELNOTAFILE;

  if ((numeds=getcompleteedlist(mr,
				cr,
				&edlist))<0)
    return numeds;


  if (numeds>0) {
    if ((rc=freespace(mr,
		      cr->U.cdrFilRec.filFlNum,
		      edlist,
		      numeds,
		      0,
		      0))) {
      free(edlist);
      return rc;
    }
    free(edlist);
  }

  if (DelCatalogRecord(mr, parcr->U.cdrDirRec.dirDirID, fn)) 
    return MACDELFILEFAILED;

  --(parcr->U.cdrDirRec.dirVal);
  parcr->U.cdrDirRec.dirMdDat=now();

  lock(mr->viblock);

  --(mr->vib.FilCnt);

  if (parcr->U.cdrDirRec.dirDirID==ROOTID) {
    --(mr->vib.NmFls);
  }

  unlock(mr->viblock);

  return 0;

}


int mdeletefolder(MOUNT_RECORD *mr,
		  CATALOG_RECORD *parcr,
		  char *name,
		  CATALOG_RECORD *fcr)
{
  int rc;
  CATALOG_RECORD tcr;
  LONGWORD foundpid;
  char foundname[MAXFNLENGTH];

  if (fcr->cdrType!=CDR_DIR)
    return MACDELNOTAFOLDER;

  rc=GetCatalogRecord(mr, fcr->U.cdrDirRec.dirDirID, 
		      BIGESTFN, &tcr, &foundpid, foundname);

  if (rc && rc!=BT_FOUNDLESS)
    return MACDELBADFOLDER;

  if (foundpid==fcr->U.cdrDirRec.dirDirID) {
    if (tcr.cdrType!=CDR_DTHREAD)
      return MACDELFOLDERNOTEMPTY;
  } else {
    return MACDELNOTHREADREC;
  }

  if ((rc=DelCatalogRecord(mr, foundpid, foundname)))
      return MACDELCANTDELTHREADREC;
    
  if ((rc=DelCatalogRecord(mr, parcr->U.cdrDirRec.dirDirID, name)))
    return MACDELCANTDELFOLDER;
  
  --(parcr->U.cdrDirRec.dirVal);
  parcr->U.cdrDirRec.dirMdDat=now();


  lock(mr->viblock);

  --(mr->vib.DirCnt);

  if (parcr->U.cdrDirRec.dirDirID==ROOTID) {
    --(mr->vib.NmRtDirs);
  }

  unlock(mr->viblock);

  return 0;
}


int mdirentries(MOUNT_RECORD *mr,
		LONGWORD dirid,
		CATRECANDNAME **child)
{
  CATRECANDNAME *crn, *tmp;
  char queryfn[MAXFNLENGTH];
  int fi, rc;
  LONGWORD foundpid;
  int hitlowestfile;




  if ((crn=(CATRECANDNAME *) 
       malloc(sizeof(CATRECANDNAME)*CRNALLOCUNITS))==NULL) 
    return MACDIROUTOFMEM;

  strcpy(queryfn, BIGESTFN);

  fi=0;
  hitlowestfile=0;

  do {

    if ( !(fi%CRNALLOCUNITS) && (fi!=0) ) {
      if ((tmp=(CATRECANDNAME *)
	   realloc(crn,(fi+CRNALLOCUNITS)*sizeof(CATRECANDNAME)))==NULL) {
	free(crn);
	return MACDIROUTOFMEM;
      } else {
	crn=tmp;
      }
    }

    rc=GetCatalogRecord(mr,
			dirid,
			queryfn,
			&(crn[fi].cr),
			&foundpid,
			(char *) &(crn[fi].name));
    
    if (!rc || (rc==BT_FOUNDLESS && foundpid==dirid)) {

      if (crn[fi].cr.cdrType==CDR_DTHREAD) {
	if (crn[fi].cr.U.cdrThdRec.thdParID==dirid) {
	  break;
	}
      }

      memcpy(queryfn,
	     &(crn[fi].name),
	     MAXFNLENGTH);

      if (reducefn(queryfn)==LOWESTFN) {
	break;
      } 

      ++fi;

    } else {
      free(crn);
      return rc;
    }

  } while ((foundpid==dirid));

  *child=crn;

  return fi;

}
    
#define toup(c)  ( ((c)>='a' && (c)<='z') ? ((c)-('a'-'A')) : (c))

int reducefn(char *fn) 
{
  int i;
  int s;

  if ((s=strlen(fn))==0) 
    return LOWESTFN;

  for (i=s;i<MAXFNLENGTH;i++)
    fn[i]=0xff;

  fn[s-1]=toup(fn[s-1])-1;

  return 0; 

}
    


int mopen(MOUNT_RECORD *mr,
	  LONGWORD pid,
	  char *name,
	  CATALOG_RECORD *cr)
{
  int rc;
  LONGWORD foundpid;

  if ((rc=GetCatalogRecord(mr, pid, name, cr, &foundpid, NULL)))
    return rc;

  cr->lastgrowsize=mr->vib.ClpSiz/mr->vib.AlBlkSiz;

  return 0;
}


int mclose(MOUNT_RECORD *mr, 
	   LONGWORD pid,
	   char *name,
	   CATALOG_RECORD *cr)
{
  int rc;

  if ((rc=PutCatalogRecord(mr,
			   pid,
			   name,
			   cr)))
    return rc;
  
  return 0;
  
}


		     




