

#include "../defs.h"
#include "../Lock/lock.h"
#include "../mountrec.h"
#include "btree.h"
#include "local_btree.h"
#include "../errors.h"


static int BT_ReadHeader(MOUNT_RECORD *mnt, BT_HEADER *head, BYTE* buffer);
static int    BTreeFlush(MOUNT_RECORD *mnt, int unmount);



					/* Function to be called for  */
					/* initialization of Btree internal */
					/* structures; MNT structure should */
					/* be completed with a open statrec */
					/* structure and volume info*/

int    BTreeMount(MOUNT_RECORD *mnt) {
int err, i;
EXTENT_CACHE_ENTRY *p_cache;
BYTE buff[BT_NODESIZE];

					/* Extents tree */
   mnt->extents.KeyCmp = &KeyCmpExt;	/* Compare function */
   mnt->extents.ClpSiz = mnt->vib.XTClpSiz;  
   mnt->extents.KeyExpand = &KeyExpandExt;

   mnt->extents.bth.RecLen = sizeof(EXTENT_RECORD);   
   p_cache = & mnt->extents.cache[0];
   mnt->extents.BTfileid = 0;		/* Not valid */
   bcopy(mnt->vib.XTExtRec, p_cache->ext, sizeof(EXTENT_RECORD));
   p_cache->flags = 0;
   for(i=0, p_cache->length=0; i<3 ;i++)
     p_cache->length +=  p_cache->ext[i].length;

   mnt->extents.cache_hand = 0;
   mnt->extents.cache_size = 1;
   CHKERR(BT_ReadHeader(mnt, &(mnt->extents), buff))
			      /* Initialize locks for Extents Tree */
   mnt->extents.cache_lock = make_lock();
   mnt->extents.tree_lock  = make_lock();
     

					/* Catalog tree */
   mnt->catalog.KeyCmp = &KeyCmpCat;	/* Compare function */
   mnt->catalog.KeyExpand = &KeyExpandCat;
   mnt->catalog.ClpSiz = mnt->vib.CTClpSiz;   
   mnt->catalog.bth.RecLen = sizeof(CATALOG_RECORD);
   mnt->catalog.BTfileid = CATALOG_FILE_ID;

   p_cache = & mnt->catalog.cache[0];

   bcopy(mnt->vib.CTExtRec, p_cache->ext, sizeof(EXTENT_RECORD));
   p_cache->flags = 0;
   for(i=0, p_cache->length=0; i<3 ;i++)
     p_cache->length +=  p_cache->ext[i].length;

   mnt->catalog.cache_hand = 0;
   mnt->catalog.cache_size = 1;
   CHKERR(BT_ReadHeader(mnt, &(mnt->catalog), buff));   
 
   mnt->catalog.cache_lock = make_lock();
   mnt->catalog.tree_lock  = make_lock();

   return 0;
}

					/* To be called at unmount time */
static int    BTreeFlush(MOUNT_RECORD *mnt, int unmount) {
int err;
BYTE buffer[BT_NODESIZE];

/*   if(!unmount)
     lock(mnt->extents.tree_lock);
*/					/* Extents tree */
   CHKERR(BT_WriteHeader(mnt, &(mnt->extents), buffer))
   if(unmount) {  
     unmake_lock(mnt->extents.cache_lock);
     unmake_lock(mnt->extents.tree_lock);
   }
/*   else
     unlock(mnt->extents.tree_lock);
*/ 
					/* Catalog tree */
/*  if(!unmount)
     lock(mnt->catalog.tree_lock);
*/
   CHKERR(BT_WriteHeader(mnt, &(mnt->catalog), buffer))
   if(unmount) {  
     unmake_lock(mnt->catalog.cache_lock);
     unmake_lock(mnt->catalog.tree_lock);
   }
/*   else
     unlock(mnt->catalog.tree_lock);
*/
   return 0;
}

int BTreeSync(MOUNT_RECORD *mnt)  {
  return(BTreeFlush(mnt, 0));
}

int BTreeUnmount(MOUNT_RECORD *mnt)  {
  return(BTreeFlush(mnt, 1));
}

static int BT_ReadHeader(MOUNT_RECORD *mnt, BT_HEADER *head, BYTE *buffer)  {

  int err;
  BT_HEADER_NODE *ph;
  BYTE *p_char;

   CHKERR(BT_ReadNode(mnt, head, 0, buffer)) /* Read the header node */

   ph = & head->bth;

   ph->bthAddMap = GetLongWord(& buffer[ND_FLINK]); 
                                        /* Additional Map Node */

   p_char = & buffer[GetWord(& buffer[btnOffsetRec(0)])]; 
                                                 /* Header record */

   ph->bthDepth  =     GetWord(& p_char[BTH_DEPTH]);
   ph->bthRoot   = GetLongWord(& p_char[BTH_ROOT]);
   ph->bthNRecs  = GetLongWord(& p_char[BTH_NRECS]);
   ph->bthFNode  = GetLongWord(& p_char[BTH_FNODE]);
   ph->bthLNode  = GetLongWord(& p_char[BTH_LNODE]);
   ph->bthNodeSize  =  GetWord(& p_char[BTH_NODESIZE]);
   ph->bthKeyLen =     GetWord(& p_char[BTH_KEYLEN]);
   ph->bthNNodes = GetLongWord(& p_char[BTH_NNODES]);
   ph->bthFree   = GetLongWord(& p_char[BTH_FREE]);
   bcopy( & p_char[BTH_RESV], & ph->bthResv , sizeof(ph->bthResv));

   p_char = & buffer[GetWord(& buffer[btnOffsetRec(2)])]; 
                                        /* Map record */

   bcopy( p_char , & ph->btMap, sizeof(ph->btMap));

  if(ph->bthDepth > BT_MAX_DEPTH)
    return (BT_TOOHIGH);
  
  return 0;
}


int BT_WriteHeader(MOUNT_RECORD *mnt, BT_HEADER *head, BYTE* buffer) {

int err;
BT_HEADER_NODE *ph;
BYTE *p_char;

   ph = & head->bth;

   CHKERR(BT_ReadNode(mnt, head, 0, buffer)) /* Read the header node */

   PutLongWord(ph->bthAddMap, & buffer[ND_FLINK]); 
                                        /* Additional Map Node */

   p_char = & buffer[14];		/* Header record */

   PutWord(ph->bthDepth, & p_char[BTH_DEPTH]);
   PutLongWord(ph->bthRoot, & p_char[BTH_ROOT]);
   PutLongWord(ph->bthNRecs, & p_char[BTH_NRECS]);
   PutLongWord(ph->bthFNode, & p_char[BTH_FNODE]);
   PutLongWord(ph->bthLNode, & p_char[BTH_LNODE]);
   PutWord(ph->bthNodeSize, & p_char[BTH_NODESIZE]);
   PutWord( ph->bthKeyLen, & p_char[BTH_KEYLEN]);
   PutLongWord(ph->bthNNodes, & p_char[BTH_NNODES]);
   PutLongWord(ph->bthFree, & p_char[BTH_FREE]);
   
   bcopy(& ph->bthResv, & p_char[BTH_RESV], sizeof(ph->bthResv));

   p_char = & buffer[GetWord(& buffer[btnOffsetRec(2)])]; /* Map record */

   bcopy( ph->btMap, p_char , sizeof(ph->btMap));

   CHKERR(BT_WriteNode(mnt, head, 0, buffer)) /* Write the header node */
          
   return 0;
}



















