#ifndef _MOUNTREC_H
#define _MOUNTREC_H

#include "defs.h"
#include "Lock/lock.h"

#define           EXTENT_CACHE_SIZE  5

typedef struct {			/* Information from the header */
					/* node of the B-tree */
  
  LONGWORD        bthAddMap;		/* The pointer to an eventual */
  WORD            RecLen;		/* The maximum length of a record */
					/* MAP node - taken from node descr.*/
  
					/*Next Fields are from Header Record*/

  WORD            bthDepth;		/* Current depth of the tree */
  LONGWORD        bthRoot;		/* Number of root node */
  LONGWORD        bthNRecs;		/* Number of leaf nodes in the tree */
  LONGWORD        bthFNode;		/* Number of first leaf node */
  LONGWORD        bthLNode;		/* Number of last leaf node */
  WORD            bthNodeSize;		/* Size of a node */
  WORD            bthKeyLen;		/* Maximum length of a key */
  LONGWORD        bthNNodes;		/* Total number of nodes in tree */
  LONGWORD        bthFree;		/* Number of free nodes */
  BYTE            bthResv[76];		/* Reserved info */

					/* Next Field is the Map Record */
  BYTE            btMap[256];               

} BT_HEADER_NODE;

  


/*** EXTENT RECORD ***/

typedef struct {
  WORD first;				/* The block number of the first */
					/* block in this extent */
  WORD length;				/* The length of the extent */
} EXTENT_DESCRIPTOR;


typedef EXTENT_DESCRIPTOR  EXTENT_RECORD[3];

typedef struct {
  WORD block;
  WORD length;
  WORD flags;
  EXTENT_RECORD ext;
} EXTENT_CACHE_ENTRY;



typedef struct {
  BT_HEADER_NODE      bth;		/* B-tree header node info */
  LONGWORD        ClpSiz;		/* Clump size for this tree */
  int (*KeyCmp)();			/* The function used to compare keys*/
					/* One of KeyCmpExt or KeyCmpCat */
  int (*KeyExpand)();

  LONGWORD            BTfileid;
  EXTENT_CACHE_ENTRY  cache[EXTENT_CACHE_SIZE];
  int                 cache_size;
  int                 cache_hand;
  LOCK                cache_lock;
  LOCK                tree_lock;

  
} BT_HEADER;



/*** CATALOG RECORD ***/

typedef struct {
  BYTE          cdrType;		/* Type of the record */
  BYTE          cdrResrv2;
  union     {
					/* Directory Record */
    struct {
      WORD      dirFlags;		/* Directory flags  */
      WORD      dirVal;			/* Directory Valence */
      LONGWORD  dirDirID;		/* Directory ID */
      LONGWORD  dirCrDat;		/* Date and time of creation */
      LONGWORD  dirMdDat;		/* Date and Time of last modification*/
      LONGWORD  dirBkDat;		/* Date and time of last backup */
      BYTE      dirUsrInfo[16];		/* Finder Information */
      BYTE      dirFndrInfo[16];	/* Additional finder information */
      LONGWORD  dirResrv[4];
    } cdrDirRec;
    
					/* File Record */
    struct {
      BYTE      filFlags;		/* File flags */
      BYTE      filTyp;			/* File type */
      BYTE      filUsrWds[16];		/* Finder information */
      LONGWORD  filFlNum;		/* File ID */
      WORD      filStBlk;		/* First alloc. block of Data Fork*/
      LONGWORD  filLgLen;		/* Logical EOF of Data Fork */
      LONGWORD  filPyLen;		/* Physical EOF of Data Fork */
      WORD      filRStBlk;		/* First alloc. block of Res. Fork*/
      LONGWORD  filRLgLen;		/* Logical EOF of Res. Fork */
      LONGWORD  filRPyLen;		/* Physical EOF of Res. Fork */
      LONGWORD  filCrDat;		/* Date and time of creation */
      LONGWORD  filMdDat;		/* Date and Time of last modification*/
      LONGWORD  filBkDat;		/* Date and time of last backup */
      BYTE      filFndrInfo[16];	/* Additional Finder info */
      WORD      filClpSize;		/* File clump size */
      EXTENT_RECORD filExtRec;		/* First data fork extent record */
      EXTENT_RECORD filRExtRec;		/* First res. fork extent record */
      LONGWORD  filResrv;
    } cdrFilRec;

					/* Directory thread record */
    struct {
      LONGWORD  thdResrv[2];
      LONGWORD  thdParID;		/* Parent ID for this directory   */
      char      thdCName[32];		/* Name of this directory (0 end) */
    } cdrThdRec;

					/* File thread record */
    struct {
      LONGWORD  fthdResrv[2];
      LONGWORD  fthdParID;		/* Parent ID for this file   */
      char      fthdCName[32];		/* Name of this file(0 end) */
    } cdrFThdRec;
  } U;					/* the union */

  WORD  lastgrowsize;

#ifdef USER
  LOCK  locked;
  int   status;
  int   refcount;
#endif

} CATALOG_RECORD;      
       


                                        /* Types for Catalog records*/
#define       CDR_DIR        1
#define       CDR_FILE       2
#define       CDR_DTHREAD    3
#define       CDR_FTHREAD    4  

					/* Masks for file flags */
#define       FFLAGS_LOCK     1
#define       FFLAGS_THREAD   2
#define       FFLAGS_USED     128

#define       DELETED         1         /* Flags for status */
#define       MOVED           2



struct staterec {
#ifdef USER
  int diskfd;
#endif
#ifdef VFS
  struct vnode *device;
#endif
#ifdef IFS
  unsigned short hVPB;
#endif
  int sectoffsettopartition;
  WORD sectsize; 
  char validflag;
  int maxwritesbeforemrflush;
  int currentnumwrites;
};



struct volinfo {
  WORD     SigWord;      /* 0x4244 */
  LONGWORD CrDate;       /* initialization date/time */
  LONGWORD LsMod;        /* last modification date */
  WORD     Atrb;         /* vol. attributes */
  WORD     NmFls;        /* Number of files in dir */
  WORD     VBMSt;        /* 1st block of vol bitmap */
  WORD     AllocPtr;     /* Internal Use Only */
  WORD     NmAlBlks;     /* number of allocation blocks */
  LONGWORD AlBlkSiz;     /* Size of an allocation block */
  LONGWORD ClpSiz;       /* clump size */
  WORD     AlBlSt;       /* first block in Bit Map */
  LONGWORD NxtCNID;      /* next unused dir ID or fn */
  WORD     FreeBks;      /* number of free allocation block */
  BYTE     VNlen;        /* Length of Volume Name */
  BYTE     VN[26];       /* Volume Name Chars */
  LONGWORD VolBkUp;      /* Date of Last Backup */
  WORD     VSeqNum;      /* Internal Use */
  LONGWORD WrCnt;        /* Volume Write Count */
  LONGWORD XTClpSiz;     /* Clump size of extents tree file */
  LONGWORD CTClpSiz;     /* Clump size of catalog tree file */
  WORD     NmRtDirs;     /* Number of directories in Root */
  LONGWORD FilCnt;       /* Number of files on volume */
  LONGWORD DirCnt;       /* Number of dirs on volume */
  BYTE     FndrInfo[32]; /* Finder Information */
  WORD     VCSize;       /* Internal Use */
  WORD     VCBMSize;     /* Internal Use */
  WORD     CtlCSize;     /* Internal Use */
  LONGWORD XTFlSize;     /* Length of extents tree */
  EXTENT_RECORD   XTExtRec; /* Extents Record for Extents Tree */
  LONGWORD CTFlSize;     /* Length of catalog tree */
  EXTENT_RECORD   CTExtRec; /* First extent record for catalog tree */
};





typedef struct {
  struct staterec sr;
  struct volinfo  vib;
  LOCK            viblock;
  BYTE            *vbmap;
  LOCK            vbmaplock;
  BT_HEADER       catalog;
  BT_HEADER       extents;
} MOUNT_RECORD;
  


typedef struct catrecandname {
  CATALOG_RECORD cr;
  char name[MAXFNLENGTH+1];
} CATRECANDNAME;

typedef struct mfile {
  MOUNT_RECORD *mr;
  CATALOG_RECORD *cr;
  LONGWORD pid;
  char name[MAXFNLENGTH+1];
  int mode;
  LONGWORD offset;
  char valid;
} MFILE;

#endif /* _MOUNTREC_H */