/* diskfunc.c
   Functions for reading and writing sectors.
*/

#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>

#include <string.h>

#include "diskfunc.h"
#include "fsd.h"
#include "../r0r3shar.h"
#include "r3global.h"
#include "cache.h"
#include "fsctl.h"

unsigned read_sector(secno start, unsigned short num_sectors,
                     unsigned short hVPB, void *buf)
{
  secno i, first_miss=0;
  unsigned n_sec=0;

  /* Collect consecutive cache misses into one read request */
  for(i=start; i<start+num_sectors; i++) {
    char *p = search_cache(hVPB, i);
    if(p) {
      /* Get the new sector so that it isn't subsequently invalidated */
      char tempbuf[SECTOR_SIZE];
      memcpy(tempbuf, p, SECTOR_SIZE);

      /* Read consecutive sectors not in cache */
      if(n_sec) {
	RWSTRUC rw;
	APIRET rc;
	unsigned long len_data, len_rw;
	unsigned j;
	
	rw.starting_sector = first_miss;
	rw.n_sectors = n_sec;
	rw.hVPB = hVPB;

	if((rc=do_FSCtl(buf, n_sec*SECTOR_SIZE, &len_data, 
		    &rw, sizeof(rw), &len_rw, FSCTL_FUNC_READSECTORS))
	   != NO_ERROR)
	  return rc;
	/* Insert sectors into cache */
	for(j=first_miss; j<first_miss+n_sec; j++) {
	  cache_insert(hVPB, j, buf);
	  buf += SECTOR_SIZE;
	}

	n_sec=first_miss=0;
      }
      memcpy(buf, tempbuf, SECTOR_SIZE);
      buf+=SECTOR_SIZE;
    }
    else {
      /* Cache miss */
      if(!first_miss)
	first_miss=i;
      n_sec++;
    }
  }
  /* Read last bunch of sectors */
  if(n_sec) {
    RWSTRUC rw;
    APIRET rc;
    unsigned long len_data, len_rw;
    unsigned j;
    
    rw.starting_sector = first_miss;
    rw.n_sectors = n_sec;
    rw.hVPB = hVPB;
    
    if((rc=do_FSCtl(buf, n_sec*SECTOR_SIZE, &len_data, 
		&rw, sizeof(rw), &len_rw, FSCTL_FUNC_READSECTORS))
       != NO_ERROR)
      return rc;

    /* Insert sectors into cache */
    for(j=first_miss; j<first_miss+n_sec; j++) {
      cache_insert(hVPB, j, buf);
      buf += SECTOR_SIZE;
    }
  }

  return NO_ERROR;
}

unsigned write_sector(secno start, unsigned short num_sectors,
                     unsigned short hVPB, void *buf)
{
  RWSTRUC rw;
  APIRET rc;
  unsigned long len_data, len_rw;
  unsigned i;

  rw.starting_sector = start;
  rw.n_sectors = num_sectors;
  rw.hVPB = hVPB;

  rc = do_FSCtl(buf, num_sectors*SECTOR_SIZE, &len_data,
                &rw, sizeof(rw), &len_rw, FSCTL_FUNC_WRITESECTORS);

  /* Update the cache */
  for(i=start; i<start+num_sectors; i++) {
    if(rc==NO_ERROR)
      cache_insert(hVPB, i, buf);
    else
      cache_delete(hVPB, i);
    buf+=SECTOR_SIZE;
  }
  return rc;
}
