/* diskstruc.h
   Disk structures
*/

#ifndef _HFSSTRUC_H
#define _HFSSTRUC_H

#pragma pack(1)

/* Extended BPB */
typedef struct Extended_BPB {
  unsigned short BytePerSector;
  unsigned char SectorPerCluster;
  unsigned short ReservedSectors;
  unsigned char NumberOfFats;
  unsigned short RootEntries;
  unsigned short TotalSectors;
  unsigned char MediaDescriptor;
  unsigned short SectorsPerFat;
  unsigned short SectorsPerTrack;
  unsigned short Heads;
  unsigned long HiddenSectors;
  unsigned long Ext_TotalSectors;
} EXTENDED_BPB;

/* Extended DOS boot block. */
typedef struct Extended_Boot {
  unsigned char Boot_jmp[3];
  unsigned char Boot_OEM[8];
  struct Extended_BPB Boot_BPB;
  unsigned char Boot_DriveNumber;
  unsigned char Boot_CurrentHead;
  unsigned char Boot_Sig;              /* = 0x29. Indicate Extended Boot */
  unsigned char Boot_Serial[4];
  unsigned char Boot_Vol_Label[11];
  unsigned char Boot_System_ID[8];
} EXTENDED_BOOT, *PEXTENDED_BOOT;

#endif /* _HFSSTRUC_H */