/* logger.c
   Thread that takes care of log info
*/

#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSPROCESS
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "fsd.h"
#include "../r0r3shar.h"
#include "r3global.h"

#define BUFSIZE 4096
static char Buf[BUFSIZE];
char name[30];

void log_thread(void *arg)
{
  FILE *fp = (FILE *)arg;
  ULONG dataio;
  APIRET rc;

#ifdef DEBUG
  printf("Logging thread running\n");
#endif
  strcpy(name, FS_NAME);

  for (;;) {
    dataio = 0;
    memset(Buf, 0, BUFSIZE);
    if ((rc = DosFSCtl(Buf, BUFSIZE, &dataio,
                       NULL, 0, NULL,
                       FSCTL_FUNC_GETLOGDATA, name,
                       -1,  FSCTL_FSDNAME)) != NO_ERROR) {
      printf("logger: DosFSCtl failed!\n");
      _endthread();
    }
    printf(Buf);
    if(fp) {
      fprintf(fp, Buf);
      fflush(fp);
    }
  }
}