/* sync.c
   Send a sync command to the control program.
*/

#define INCL_DOSFILEMGR
#define INCL_DOSNMPIPES
#define INCL_DOSERRORS
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "status_pipe.h"

static int parse_args(short argc, char *argv[]);

/* The name of the status pipe */
const char status_pipe_name[] = "\\PIPE\\HFS_STATUSPIPE";

/* The drive given on the command line */
unsigned short drive;

int main(int argc, char *argv[])
{
  APIRET rc;
  STATUS_CMD_SYNC msg;
  STATUS_RES res;
  ULONG bytes;

  if(parse_args(argc, argv)) {
    printf("\nsync writes any buffered data to the specified volume.\n");
    printf("Usage: sync d:\n");
    printf("where d: is the drive to sync.\n");
    return 1;
  }

  /* Send a SYNC message to the control program */
  msg.id = STATUS_ID_SYNC;
  msg.drive = drive;

  rc = DosCallNPipe(status_pipe_name, &msg, sizeof(msg), &res, sizeof(res), &bytes, 10000L);
  if(rc!=NO_ERROR) {
    printf("sync: Error communicating with the control program.\n");
    return 1;
  }

  switch(res) {
  case STATUS_RES_NO_ERROR:
    printf("The volume may now be removed safely from the drive.\n");
    return 0;
  case STATUS_RES_NOT_HFS:
    printf("The specified drive does not contain an HFS volume.\n");
    return 1;
  default:
    printf("Failed to sync the volume!\n");
    return 1;
  }
}

static int parse_args(short argc, char *argv[])
{
  int i, got_drive=0;
  for(i=1; i<argc; i++) {
    if(argv[i][0]=='/' || argv[i][0]=='-') {
      /* Switch */
      strupr(argv[i]);
      /* Check for switches here - none supported */
      fprintf(stderr, "Invalid option %s\n", argv[i]);
      return 1;
    }
    else if(strlen(argv[i])==2 && argv[i][1]==':') {
      /* Drive letter */
      if(got_drive) {
        fprintf(stderr, "Unexpected drive letter %s\n", argv[i]);
        return 1;
      }
      if(!isalpha(argv[i][0])) {
        fprintf(stderr, "Invalid drive letter %s\n", argv[i]);
        return 1;
      }
      drive = toupper(argv[i][0])-'A';
      got_drive = 1;   
    }
    else {
      /* Unrecognized argument */
      fprintf(stderr, "Invalid argument %s\n", argv[i]);
      return 1;
    }
  }

  /* Check that we got all necessary arguments */
  if(!got_drive) {
    fprintf(stderr, "No drive letter specified.\n");
    return 1; 
  }

  return 0;
}
