/* times.c
   Time conversion functions
*/

#define INCL_NOPMAPI
#define INCL_DOSDATETIME
#include <os2.h>

#include <time.h>

#include "MacFS/defs.h"
#include "MacFS/Times/mac_time.h"

FDATE mac_to_os2_date(LONGWORD mac_time)
{
  time_t unix_time = mac_to_unix_time(mac_time);
  struct tm *local = localtime(&unix_time);
  FDATE d;

  d.day = local->tm_mday;
  d.month = local->tm_mon+1;
  d.year = local->tm_year - 80;

  return d;
}

FTIME mac_to_os2_time(LONGWORD mac_time)
{
  time_t unix_time = mac_to_unix_time(mac_time);
  struct tm *local = localtime(&unix_time);
  FTIME t;

  t.twosecs = local->tm_sec/2;
  t.minutes = local->tm_min;
  t.hours = local->tm_hour;
  return t;
}

unsigned short mac_to_os2_date_int(LONGWORD mac_time)
{
  union {
    FDATE d;
    unsigned short i;
  } u;

  u.d=mac_to_os2_date(mac_time);
  return u.i;
}

unsigned short mac_to_os2_time_int(LONGWORD mac_time)
{
  union {
    FTIME t;
    unsigned short i;
  } u;

  u.t=mac_to_os2_time(mac_time);
  return u.i;
}

LONGWORD os2_to_mac_time(FDATE d, FTIME t)
{
  time_t unix_time;
  struct tm local;

  local.tm_mday = d.day;
  local.tm_mon = d.month-1;
  local.tm_year = d.year+80;
  local.tm_sec = 2*t.twosecs;
  local.tm_min = t.minutes;
  local.tm_hour = t.hours;
  unix_time=mktime(&local)+timezone;

  return unix_to_mac_time(unix_time);
}

LONGWORD os2_to_mac_time_int(unsigned short idate, unsigned short itime)
{
  union {
    FDATE d;
    unsigned short i;
  } date;
  union {
    FTIME t;
    unsigned short i;
  } time;

  date.i = idate;
  time.i = itime;
  return os2_to_mac_time(date.d, time.t);
}
