.**********************************************************************
.* hfs.ipfs
.**********************************************************************

:userdoc.
:docprof toc=12.

.nameit symbol=HFS text='HFS/2'

:title.&HFS.

.**********************************************************************
:h1.Title page
.**********************************************************************

:font facename=Helv size=28x18.
.ce HFS/2
:font facename=default size=0x0.
.ce A Hierarchical File System Driver for OS/2
.ce Copyright (C) 1996 by Marcus Better
.ce Based on "MacFS", Copyright (C) 1996 by
.ce Peter A. Dinda, George C. Necula, and Morgan Price

.**********************************************************************
:h1 id=100.Introduction
.**********************************************************************

:p.
&HFS. is a file system driver for OS/2 which reads and writes 
Macintosh diskettes. With &HFS., a Macintosh diskette can be used
seamlessly with OS/2 just as if it were an ordinary DOS diskette.
At least, that is how it is supposed to be once the rough edges
get smoothed out.

:p.
This program supports 1.4MB Macintosh diskettes formatted with 
the :hp1.Hierarchical File System:ehp1. only. 
Old 800k diskettes or diskettes formatted with the "flat" file system
cannot be used.
In the future, it should be possible to make &HFS. handle
hard disks as well.

:hp8.
:warning.
This program is in an early, experimental stage. It is almost certainly
lacking some important features, and may still have many bugs and problems.
You should always make backup copies of any diskettes that you use with
this program.:ewarning.:ehp8.&HFS. is based on MacFS, a free, 
portable implementation of the Macintosh Hierarchical File System by
Peter A. Dinda, George C. Necula, and Morgan Price. The source code
for MacFS is incorporated in &HFS., slightly modified.
I have found it helpful to look at the source code of Matthieu Willm's 
ext2-os2 driver, and have borrowed some ideas from him. 
The IFS part of &HFS. follows an architecture for a split ring 0/ring 3
IFS described in articles by Andre Asselin in the
Electronic OS/2 Developer's Magazine.

:p.
The latest version of &HFS. is available on the WWW at 
http&colon.//www.abc.se/~m9111/HFS.

:p.
I hope you will find &HFS. useful. You are welcome to send me any 
comments, suggestions, bug reports and contributions.

:p.
Marcus Better

:p.
:parml tsize=15 break=fit.
:pt.Email:
:pd.Marcus.Better@abc.se
:eparml.

.**********************************************************************
:h1 id=200.Licence and Conditions of Use
.**********************************************************************
:sl compact.
:li.:link reftype=hd refid=210.Licence for &HFS.:elink.
:li.:link reftype=hd refid=220.Licence for MacFS:elink.
:esl.

:h2 id=210.Licence for &HFS.

:p.
:hp8.
:nt text='Disclaimer'.
This program is supplied as is. The author assumes no responsibility
for damages which may result from the use of this program.
:ent.
:ehp8.
:p.
&HFS. may be used and freely distributed within the limits stated below.
You may also modify &HFS. and incorporate it in other programs within
these limits.

:ol.
:li.
&HFS. may be freely used for non-commercial purposes only.

:li.
If you alter &HFS. in any way and distribute the work, then that work
must be similarly free, and the source code must be freely available
to the public.
:eol.

:p.
This program incorporates MacFS, which is covered by a 
:link reftype=hd refid=220.licence:elink. of its own.

:p.
&HFS. is Copyright (C) 1996 by Marcus Better.

:h2 id=220.Licence for MacFS

:p.
:xmp.
WARNINGS
--------

THIS SOURCE CODE IS NOT PUBLIC DOMAIN, FREEWARE, SHAREWARE, or "COPY-LEFTED."

THIS SOURCE CODE MAY BE FREELY DISTRIBUTED UNDER THE LIMITS SPECIFIED BELOW.

THIS SOURCE CODE HAS NO ACTUAL OR IMPLIED WARRANTY OR GUARANTEE OF ANY
KIND FROM PETER A. DINDA, GEORGE C. NECULA, MORGAN PRICE, CARNEGIE MELLON
UNIVERSITY, OR ANY OTHER PARTY.

THIS SOURCE CODE IS NOT SUPPORTED BY PETER A. DINDA, GEORGE C. NECULA,
MORGAN PRICE, CARNEGIE MELLON UNIVERSITY, OR ANY OTHER PARTY.

To the best of our knowledge, this source code, "MacFS", is correct 
and suitable.  However, no warranty or guarantee of any kind, either actual
or implied, is provided for this software.  Additionally, no support is
provided for this software.  It is used at your own risk.

==============================================================================

LICENSE
-------

This source code, "MacFS", is 
                
  Copyright (c) 1996 by Peter A. Dinda, George C. Necula, and Morgan Price
                                         

Current version is available via:
    http&colon.//www.cs.cmu.edu/afs/cs.cmu.edu/usr/pdinda/html/pdinda.html
    ftp&colon.//ftp.cs.cmu.edu/user/pdinda

Permission is granted to distribute and freely use and extend "MacFS", or
to incorporate the "MacFS" source code into other software within these
limits&colon.

   0) "MacFS" and any derivatives of "MacFS" must retain this license,
display the above copyright notice when run, and include this file.

   1) "MacFS" and any derivatives of "MacFS" may only be freely used for
non-commercial purposes.  If you are interested in commercial use of
"MacFS", contact Peter A. Dinda (pdinda@cs.cmu.edu).

   2) "MacFS" and any derivatives of "MacFS" may not be used for military
purposes.

   3) Peter A. Dinda (pdinda@cs.cmu.edu) must be notified of any
derivatives of "MacFS"


In simple terms, "MacFS" may be freely used for any non-commercial,
non-military purposes.  Derivatives of "MacFS" must be similarly free
and Peter A. Dinda (pdinda@cs) must be notified of their existence.  
Commercial use of "MacFS" and commercial derivatives of "MacFS" are NOT
ALLOWED under this license.  To use "MacFS" commercially, contact
Peter A. Dinda (pdinda@cs.cmu.edu) for more information.



Peter August Dinda                                     pdinda@cs.cmu.edu
Doctoral Student, School of Computer Science, Carnegie Mellon University
   http&colon.//www.cs.cmu.edu/afs/cs.cmu.edu/usr/pdinda/html/pdinda.html
:exmp.

.**********************************************************************
:h1 id=300.Installation instructions
.**********************************************************************

:p.
The following steps describe how to install &HFS..
:ol.
:li.
Unpack the distribution archive hfs:hp1.nnn:ehp1..zip into a directory
anywhere on your system.
:li.
Add the following line to the CONFIG.SYS file on your boot drive:
:xmp.IFS=d&colon.\path\HFS.IFS

:exmp.
where d&colon.\path\ is the path to the directory where you unpacked
the files. The line must be located after the IFS= statement for the
file system where &HFS. resides, if any.
.*:li.
.*Copy the file :link reftype=fn refid=emxrt.emx.dll:elink.
.*to a directory on your DLLPATH. Usually \OS2\APPS\DLL
.*will do.
:li.
You may add the line
:xmp.RUN=d&colon.\path\HFS.EXE

:exmp.
to the CONFIG.SYS file to have the :link reftype=fn refid=control.Control 
Program:elink. HFS.EXE started in the background at boot time. This program
must be activated, either in this way or simply by running it from an OS/2
prompt, before using &HFS..
:li.
Optionally add the &HFS. directory to the PATH line in CONFIG.SYS.
:eol.

.**********************************************************************
:h1 id=400.Using &HFS.
.**********************************************************************

:p.
&HFS. is made up mainly of two parts:
:ul compact.
:li.the IFS, and
:li.the :link reftype=hd refid=420.Control Program:elink..
:eul.
:p.
The IFS resides in the file HFS.IFS, and is loaded at boot time with
a line in CONFIG.SYS. The Control Program resides in the file HFS.EXE.

:p.
In addition, the &HFS. package contains the utilities 
:link reftype=hd refid=430.PREPARE.EXE:elink., 
:link reftype=hd refid=450.SYNC.EXE:elink. and FSKILL.EXE. 
Their function is described in the following sections.

:p.
Here is a short summary of the steps involved in using a Macintosh
diskette with &HFS.:
:ol compact.
:li.Make sure the Control Program is running.
:li.Insert the diskette into a diskette drive. We will assume this
drive is A&colon. for this example.
:li.If the diskette has not been prepared for use with &HFS., prepare
it with the command
:xmp.PREPARE /P A&colon.

:exmp.
See the section on :link reftype=hd refid=430.PREPARE:elink. for a
closer description of this command.
:li.Access the files on the diskette in any way you like.
:li.Synchronize the data on the diskette by invoking
:xmp.SYNC A&colon.

:exmp.
See the section on :link reftype=hd refid=450.SYNC:elink. for further
information on this command.
:li.Optionally restore the diskette with the command
:xmp.PREPARE /R A&colon.
:exmp.
:li.Remove the diskette from its drive.
:eol.

:h2 id=420.The Control Program

:p.
The file HFS.EXE is known as the :hp1.Control Program:ehp1.. It is the Control
Program that carries out most tasks on behalf of the file system
driver. HFS.EXE can be started either from an OS/2 prompt, or using
a RUN= statement in CONFIG.SYS. There are no command-line options
for HFS.EXE.

:p.
When the Control Program is started, it connects to the IFS and starts
processing file system requests. Macintosh volumes can be accessed
only when the Control Program is running. The Control Program will
refuse to load if another instance of the program is already running.

:warning.
If the Control Program is interrupted while a Macintosh diskette is
mounted, data may be lost and the diskette left in an inconsistent
state.:ewarning.It is best to let the Control Program run once it has been started.
If you need to interrupt it for some reason, be sure to
:link reftype=hd refid=450.sync:elink. and remove all diskettes first.
The Control Program may also cause a fault as a result of a bug. If
this happens, you should remove any Macintosh diskettes immediately.
It may also be necessary to run the FSKILL utility before continuing
if the Control Program traps. FSKILL will tell the HFS.IFS to
disconnect from the crashed Control Program.

:h2 id=430.Preparing a diskette for use with &HFS.

:p.
Because of the way OS/2 handles diskettes, a Macintosh diskette cannot
be used directly on an OS/2 system. The diskette needs an OS/2-compatible
boot sector in order to be recognized. Naturally, Macintosh diskettes
do not have OS/2-compatible boot sectors.

:p.
PREPARE.EXE remedies this by supplying an OS/2-style boot sector. The
syntax for this command is
:xmp.PREPARE /P d&colon.

:exmp.
where d&colon. is the drive with the diskette to be prepared.

:p.
PREPARE.EXE will save the original boot sector in a data file in the current
directory. The name  will be the hexadecimal serial number of the
diskette. If a file with that name already exists, PREPARE will complain
and not prepare the diskette.

:p.
In order to restore the boot sector from this data file, use the command
:xmp.PREPARE /R d&colon.

:exmp.
This will copy the saved original boot sector from the data file back
to the diskette. The data file must be found in the current directory,
or PREPARE will complain.

:p.
Macintosh diskettes usually do not need a boot sector unless they are
used to boot from. An HFS diskette will work in a Macintosh computer
even if it has an OS/2 boot sector. If you do not intend to restore
a diskette, you can delete the data file generated by PREPARE.

:p.
I believe there are better ways to work around this problem, and hope
that future versions of &HFS. will make the PREPARE program unnecessary.

:h2 id=450.Synchronizing a volume

:p.
When an HFS diskette is accessed, the file system driver keeps 
some HFS data structures
in memory for performance reasons. Before the diskette is removed from
the drive, these structures must be written to the diskette. This
is known as :hp1.synchronizing:ehp1. the buffers, and it is done
by running the program SYNC.EXE.

:p.
Invoking SYNC is simple. Just type
:xmp.SYNC d&colon.

:exmp.
at a command prompt to sync the diskette in drive d&colon..
If the sync succeeds, the program will notify you that the diskette
may be removed.

:warning.
If you remove an HFS diskette from the drive without running SYNC first,
the diskette may be left in an inconsistent state. You can, however,
reinsert the diskette immediately after and continue using it without losing
data.
:ewarning.

.**********************************************************************
:h1 id=500.Building the source
.**********************************************************************

:sl compact.
:li.:link reftype=hd refid=510.The tools needed:elink.
:li.:link reftype=hd refid=515.The sources:elink.
:li.:link reftype=hd refid=520.The Ring 0 piece:elink.
:li.:link reftype=hd refid=520.The Ring 3 piece:elink.
:esl.

:h2 id=510.The tools needed

:p.
To build &HFS., you will need two C compilers&colon. a 16-bit compiler
for the IFS, and a 32-bit compiler for the Control Program and the
utilities. Small modifications to the sources and makefiles may
be necessary if you use different compilers than the ones listed below.
Some modifications to the makefiles will be necessary either way in order
to adjust them to
your system.

:p.
I used the following tools to develop &HFS..
:ul compact.
:li.
emx 0.9b (gcc) for the 32-bit parts.
:li.
Borland C 3.1, Turbo Assembler and Borland's MAKE utility for the IFS.
:li.
GNU Make version 3.67.
:li.
The library OS2286.LIB which came with IBM VisualAge C++ 3.0, for
linking with the 16-bit part.
:li.
The IFS Toolkit, which is available from various IBM sources and
includes the library FSHELPER.LIB.
:li.
Header files from the Warp Toolkit (which came with IBM VisualAge C++),
used by the 16-bit part.
:eul.

:h2 id=515.The sources

:p.
The file hfssrc.zip contains the source tree. Some of the source files
have long filenames, so you will have unzip it to an HPFS drive. The
directories in the tree are as follows:

:p.
:parml compact break=all.
:pt..
:pd.The root directory of the development tree contains header
files shared by the ring 0 and ring 3 pieces, as well as the 
top-level Makefile which is only used to create the distribution
archive.
:pt..\Ring0
:pd.This directory contains the source for the ring 0 piece (the IFS).
:pt..\Ring3
:pd.This directory contains the source for the Control Program and
the utilities.
:pt..\Ring3\MacFS
:pd.This is a slightly modified version of MacFS.
:pt..\doc
:pd.The source for the documentation.
:eparml.

:h2 id=520.The Ring 0 piece

:p.
The .\Ring0 directory in the development tree contains C and asm sources,
and a makefile for Borland's MAKE utility. You will
have to edit the makefile so that the paths are correct for your
system.

:p.
The makefile contains compiler options for BCC. I have
sometimes experienced unexpected results after changing some
of these options, in particular those related to optimizations.
It seems that BCC can sometimes "optimize" perfectly good code so
that it no longer works correctly.

:p.
If the DEBUG symbol is defined, then the IFS will print some
debugging information through a logging facility. The messages
are printed out by the logging thread of the Control Program
if it is also compiled with DEBUG defined. 

:p.
To compile the IFS with debugging enabled, a vsprintf function
is needed. For reasons of licencing, there is no such function
included in this distribution, so you must supply your own.

:h2 id=530.The Ring 3 piece

:p.
The .\Ring3 directory has several subdirectories, each with its
own Makefile (for GNU Make). They are all invoked as sub-makes
by the top-level makefile (.\Ring3\Makefile).

:p.
Dependencies can be generated by doing a
:xmp.make dep

:exmp.
This generates a dependency file called .depend in each subdirectory. 
However, the makefiles require the .depend files to be present
from the beginning, so you will have to create an empty .depend
file in each directory manually before you can run make. 
There are better ways to write
makefiles to avoid this, I just haven't got around to it yet.

:p.
Note that GNU Make doesn't like dependencies that contain drive
letters because of the colons.
This can be a problem if the default search path for gcc is
given by the C_INCLUDE_PATH environment variable and that
variable contains drive letters. gcc will prepend the pathname
from C_INCLUDE_PATH to the header file name when it generates
dependencies, so you will have to remove the drive letter
from C_INCLUDE_PATH. As a consequence, the emx header files will 
need to reside on the same drive as the &HFS. source.

:p.
The TOPDIR variable in .\Ring3\Makefile will need to be modified
to suit your system. When that is done, just type
:xmp.make

:exmp.
to compile everything.

:p.
If the symbol DEBUG is defined, HFS.EXE will print some information
on its actions. It will also create a logging thread which prints
messages from the IFS.

.**********************************************************************
.* Footnotes
.**********************************************************************

:fn id=control.
The :hp1.Control Program:ehp1., HFS.EXE, is the part of &HFS. that runs
in ring 3 (user privilege level). In order to access a Macintosh
diskette, the Control Program must be running.
:efn.

.*:fn id=emxrt.
.*This file is the emx run-time module. The full emx run-time
.*package can be obtained from ftp.uni-stuttgart.de in the directory
.*/pub/systems/os2/emx-0.9b.
.*:efn.

:euserdoc.
