/****************************************************************** PROFILE.H
 *                                                                          *
 *                      Profile Object definitions                          *
 *                                                                          *
 ****************************************************************************/

#ifndef PROFILE_H
#define PROFILE_H

#include "Items.h"
#include "ReString.h"

class Profile {

   private:
      HINI   Handle ;               // INI file handle.
      PSZ    Name ;                 // Application Name.

   public:
      Profile ( PSZ Name, HAB Anchor, HMODULE Library,
         int DialogID, HWND HelpWindow, BOOL ResetFlag ) ;

      ~Profile ( ) ;

      HINI QueryHandle ( ) { return ( Handle ) ; }

      PSZ QueryName ( ) { return ( Name ) ; }

      VOID Reset ( ) {
         PrfWriteProfileData ( Handle, Name, 0, 0, 0 ) ;
      }
} ;

#define MAX_DRIVES        (26)

enum {
   ITEM_CLOCK,
   ITEM_ELAPSEDTIME,
   ITEM_MEMORYFREE,
   ITEM_VIRTUALFREE,
   ITEM_SWAPFILESIZE,
   ITEM_SWAPDISKFREE,
   ITEM_SWAPFILESLACK,
   ITEM_SPOOLFILESIZE,
   ITEM_CPULOAD,
   ITEM_TASKCOUNT,
   ITEM_PROCESSCOUNT,
   ITEM_THREADCOUNT,
   ITEM_TOTALFREE,
   ITEM_BASE_COUNT
} ;

typedef struct {
   Item *pItem ;
   BOOL  fLabel ;
   char  Label [80] ;
} ITEM, *PITEM ;

typedef struct {      // Parameters saved to system.

   // The Display Item List - - -
   USHORT ItemCount ;
   ITEM Items [ ITEM_BASE_COUNT + MAX_DRIVES ] ;

   // Data required for the display item objects to function.
   ULONG           MemoryFree ;
   time_t          MemoryTime ;
   ULONG           IdleCount ;
   ULONG           MaxCount ;
   BYTE            SwapPath [_MAX_PATH] ;
   ULONG           MinFree ;
   PBYTE           SpoolPath ;
   int             idCountry ;
   COUNTRYINFO     CountryInfo ;
   char            szAm [8] ;
   char            szPm [8] ;
   ResourceString *Day ;
   ResourceString *Days ;
   ResourceString *DaysOfWeek ;
   ResourceString *DriveError ;

   // Window size and location
   SWP    Position ;
   BOOL   fPosition ;

   // User Options
   BOOL   HideControls ;
   BOOL   fHideControls ;

   BOOL   Float ;
   BOOL   fFloat ;

   BOOL   Animate ;
   BOOL   fAnimate ;

   BOOL   TableFormat ;
   BOOL   fTableFormat ;

   BOOL   ShowRemoteDrives ;
   BOOL   fShowRemoteDrives ;

   BOOL   ShowFileSystemNames ;
   BOOL   fShowFileSystemNames ;

   BOOL   ShowDiskLabels ;
   BOOL   fShowDiskLabels ;

   BOOL   ShowSeconds ;
   BOOL   fShowSeconds ;

   USHORT ShowK ;
   BOOL   fShowK ;

   BYTE   MonitorPriority ;
   BOOL   fMonitorPriority ;

   USHORT TimerInterval ;
   BOOL   fTimerInterval ;

   USHORT AnchorCorner ;
   BOOL   fAnchorCorner ;

   // Presentation Parameters
   BYTE   FontNameSize [80] ;
   BOOL   fFontNameSize ;

   COLOR  BackColor ;
   BOOL   fBackColor ;

   COLOR  TextColor ;
   BOOL   fTextColor ;

} INIDATA, *PINIDATA ;

extern int GetIniData ( HINI IniHandle, PINIDATA IniData ) ;
extern void PutIniData ( HINI IniHandle, PINIDATA IniData ) ;

#endif
